/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.synchronization.types;

import java.io.Serializable;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;

public class SyncObject
implements Serializable {
    private final String nodeId;
    private final String pid;
    private final String taskLabel;
    private Integer attempt = 1;
    private Integer lockAttempt = 1;
    private long sleepUntil = -1L;

    public SyncObject(NodeReference nodeId, Identifier pid) {
        this(nodeId.getValue(), pid.getValue());
    }

    public SyncObject(String nodeId, String pid) {
        this.nodeId = nodeId;
        this.pid = pid;
        this.taskLabel = String.format("Task-%s-%s", nodeId, pid);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getPid() {
        return this.pid;
    }

    public String taskLabel() {
        return this.taskLabel;
    }

    public Integer getAttempt() {
        return this.attempt;
    }

    public void setAttempt(Integer attempt) {
        this.attempt = attempt;
    }

    public Integer getLockAttempt() {
        return this.lockAttempt;
    }

    public void setLockAttempt(Integer attempt) {
        this.lockAttempt = attempt;
    }

    public long getSleepUntil() {
        return this.sleepUntil;
    }

    public void setSleepUntil(long dateTimeLong) {
        this.sleepUntil = dateTimeLong;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskLabel == null ? 0 : this.taskLabel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncObject)) {
            return false;
        }
        SyncObject other = (SyncObject)obj;
        return !(this.taskLabel == null ? other.taskLabel != null : !this.taskLabel.equals(other.taskLabel));
    }
}

