/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import junit.framework.Assert;
import org.dataone.cn.ldap.DirContextProvider;
import org.dataone.cn.ldap.MockLDAPService;
import org.dataone.configuration.Settings;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapServiceTestUnit {
    private static final Logger log = LoggerFactory.getLogger(LdapServiceTestUnit.class);
    private MockLDAPService mockLDAPService = new MockLDAPService();
    private String DC_TEST_DN = "DC=test,DC=org";
    private String COUNTRY_TEST_DN = "C=GH,DC=test,DC=org";
    private String ORG_TEST_DN = "O=Clydestone,C=GH,DC=test,DC=org";
    private String ORG_UNIT_TEST_DN = "OU=Sales,O=Clydestone,C=GH,DC=test,DC=org";
    private String TREE_TEST_DN = "CN=Benjamin Leinfelder A515,O=University of Chicago,C=US,DC=cilogon,DC=org";
    private String ATTRIBUTE_VALUES_DN = "CN=urn:node:testcn,DC=dataone,DC=org";
    private String ALT_TREE_TEST_DN = Settings.getConfiguration().getString("test.primarySubject");

    @Test
    public void testBase() {
        String base = Settings.getConfiguration().getString("mock.ldap.base");
        Assert.assertTrue(base.equals(this.mockLDAPService.getBase()));
    }

    @Test
    public void testAddDc() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        try {
            this.mockLDAPService.addDc(dirContext, this.DC_TEST_DN);
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    @Test
    public void testAddCountry() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        try {
            this.mockLDAPService.addCountry(dirContext, this.COUNTRY_TEST_DN);
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    @Test
    public void testAddOrg() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        try {
            this.mockLDAPService.addOrg(dirContext, this.ORG_TEST_DN);
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    @Test
    public void testAddUnit() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        try {
            this.mockLDAPService.addOrgUnit(dirContext, this.ORG_UNIT_TEST_DN);
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        boolean check = this.mockLDAPService.removeEntry(dirContext, this.ORG_UNIT_TEST_DN);
        Assert.assertTrue(check);
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    public void testConstructTree() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        try {
            boolean success = this.mockLDAPService.constructTree(dirContext, this.TREE_TEST_DN);
            Assert.assertTrue(success);
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        try {
            boolean success = this.mockLDAPService.constructTree(dirContext, this.ALT_TREE_TEST_DN);
            Assert.assertTrue(success);
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    @Test
    public void testGetAttributeValues() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        try {
            List<Object> attributeValues = this.mockLDAPService.getAttributeValues(dirContext, this.ATTRIBUTE_VALUES_DN, "d1NodeApproved");
            Assert.assertFalse(attributeValues.isEmpty());
            String d1NodeApprovalValue = (String)attributeValues.get(0);
            assert (d1NodeApprovalValue.equalsIgnoreCase("TRUE"));
        }
        catch (NamingException ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    @Test
    public void testCheckAttributeValue() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        boolean check = this.mockLDAPService.checkAttribute(dirContext, this.ATTRIBUTE_VALUES_DN, "d1NodeApproved", "TRUE");
        Assert.assertTrue(check);
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }
}

