/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.dao;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.dataone.cn.dao.MetacatDataSourceFactory;
import org.dataone.cn.dao.SystemMetadataDaoMetacatImpl;
import org.dataone.cn.dao.SystemMetadataDaoMetacatImplTestUtil;
import org.dataone.cn.dao.SystemMetadataStatus;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.jdbc.core.JdbcTemplate;

public class SystemMetadataDaoMetacatImplTest {
    private JdbcTemplate jdbc = new JdbcTemplate(MetacatDataSourceFactory.getMetacatDataSource());
    private SystemMetadataDaoMetacatImpl systemMetadataDao = new SystemMetadataDaoMetacatImpl();

    @Before
    public void createTables() {
        SystemMetadataDaoMetacatImplTestUtil.createTables(this.jdbc);
    }

    @After
    public void dropTables() {
        SystemMetadataDaoMetacatImplTestUtil.dropTables(this.jdbc);
    }

    @Test
    public void testGetSystemMetadataCount() throws DataAccessException {
        SystemMetadataDaoMetacatImplTestUtil.populateSystemMetadata(this.jdbc);
        int systemMetadataCount = this.systemMetadataDao.getSystemMetadataCount();
        Assert.assertTrue(systemMetadataCount == 10);
    }

    @Test
    public void testListSystemMetadataStatus() throws DataAccessException {
        SystemMetadataDaoMetacatImplTestUtil.populateSystemMetadata(this.jdbc);
        List<SystemMetadataStatus> statusList = this.systemMetadataDao.listSystemMetadataStatus(0, 0);
        Assert.assertTrue(statusList.size() == 10);
    }

    @Test
    public void testGetSystemMetadata() throws DataAccessException, ParseException {
        SystemMetadataDaoMetacatImplTestUtil.populateTablesWithTestA(this.jdbc);
        Identifier id = new Identifier();
        id.setValue("6f632bd1cc2772bdcc43bafdbb9d8669.1.1");
        SystemMetadata smd = this.systemMetadataDao.getSystemMetadata(id);
        Assert.assertNotNull(smd);
        SystemMetadataDaoMetacatImplTestUtil.verifyTestA(smd);
    }

    @Test
    public void testSimpleSaveSystemMetadata() throws DataAccessException {
        ArrayList<SystemMetadata> smdList = new ArrayList<SystemMetadata>();
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("testId", "123456"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("noise.1", "999"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("noise.3", "33331"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("foo", "1"));
        for (SystemMetadata smd : smdList) {
            this.systemMetadataDao.saveSystemMetadata(smd, SystemMetadataDaoMetacatImpl.tableMap);
        }
        Assert.assertEquals(smdList.size(), this.systemMetadataDao.getSystemMetadataCount());
        for (SystemMetadata smd : smdList) {
            SystemMetadata actualSmd = this.systemMetadataDao.getSystemMetadata(smd.getIdentifier());
            SystemMetadataDaoMetacatImplTestUtil.verifySystemMetadataFields(smd, actualSmd);
        }
    }

    @Test
    public void testComplexSaveSystemMetadata() throws DataAccessException {
        ArrayList<SystemMetadata> smdList = new ArrayList<SystemMetadata>();
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("testCompPid", "12345"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("noisePid1", "456"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("noisePid.2", "1111"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("noisePid.3", "2222"));
        for (SystemMetadata smd : smdList) {
            this.systemMetadataDao.saveSystemMetadata(smd, SystemMetadataDaoMetacatImpl.tableMap);
        }
        Assert.assertEquals(smdList.size(), this.systemMetadataDao.getSystemMetadataCount());
        for (SystemMetadata smd : smdList) {
            SystemMetadata actualSmd = this.systemMetadataDao.getSystemMetadata(smd.getIdentifier());
            SystemMetadataDaoMetacatImplTestUtil.verifySystemMetadataFields(smd, actualSmd);
        }
    }

    @Test
    public void testSimpleAndComplexSaveSystemMetadata() throws DataAccessException {
        ArrayList<SystemMetadata> smdList = new ArrayList<SystemMetadata>();
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("testCompPid", "12345"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("noisePid1", "456"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("noisePid.2", "1111"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("noisePid.3", "2222"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("simple.test-id", "887721"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("noise.99", "999"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("noise.3", "33331"));
        smdList.add(SystemMetadataDaoMetacatImplTestUtil.createSimpleSystemMetadata("foo", "1"));
        for (SystemMetadata smd : smdList) {
            this.systemMetadataDao.saveSystemMetadata(smd, SystemMetadataDaoMetacatImpl.tableMap);
        }
        Assert.assertEquals(smdList.size(), this.systemMetadataDao.getSystemMetadataCount());
        for (SystemMetadata smd : smdList) {
            SystemMetadata actualSmd = this.systemMetadataDao.getSystemMetadata(smd.getIdentifier());
            SystemMetadataDaoMetacatImplTestUtil.verifySystemMetadataFields(smd, actualSmd);
        }
    }

    @Test
    public void testUniquePidConstraint() throws DataAccessException {
        SystemMetadata smd1 = SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("pid1", "12345");
        SystemMetadata smd2 = SystemMetadataDaoMetacatImplTestUtil.createComplexSystemMetadata("pid1", "456");
        this.systemMetadataDao.saveSystemMetadata(smd1, SystemMetadataDaoMetacatImpl.tableMap);
        this.systemMetadataDao.saveSystemMetadata(smd2, SystemMetadataDaoMetacatImpl.tableMap);
        Assert.assertEquals(1, this.systemMetadataDao.getSystemMetadataCount());
        Identifier id = new Identifier();
        id.setValue("pid1");
        SystemMetadata actual = this.systemMetadataDao.getSystemMetadata(id);
        Assert.assertEquals(456, actual.getSize().intValue());
    }

    @Test
    public void testNotFound() throws DataAccessException {
        Identifier id = new Identifier();
        id.setValue("pid1");
        SystemMetadata actual = this.systemMetadataDao.getSystemMetadata(id);
        Assert.assertNull(actual);
    }
}

