/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.MetacatDataSourceFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.ReplicationDaoMetacatImplTestUtil;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ReplicationStatus;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.jdbc.core.JdbcTemplate;

public class ReplicationDaoMetacatImplTest {
    private JdbcTemplate jdbc = new JdbcTemplate(MetacatDataSourceFactory.getMetacatDataSource());
    private ReplicationDao replicationDao = DaoFactory.getReplicationDao();

    @Before
    public void createTables() {
        ReplicationDaoMetacatImplTestUtil.createTables(this.jdbc);
    }

    @After
    public void dropTables() {
        ReplicationDaoMetacatImplTestUtil.dropTables(this.jdbc);
    }

    @Test
    public void testMemberNodeReplicasByDateQuery() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','" + ReplicationDaoMetacatImplTestUtil.cnNodeId + "','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','COMPLETED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        List<Identifier> results = this.replicationDao.getCompletedMemberNodeReplicasByDate(new Date(System.currentTimeMillis()), 0, 0);
        Assert.assertTrue(results.size() == 2);
        Assert.assertTrue(results.get(0).getValue().equals("test_guid"));
        Assert.assertTrue(results.get(1).getValue().equals("test_guid2"));
    }

    @Test
    public void testCoordinatingNodeReplicasByDateQuery() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','" + ReplicationDaoMetacatImplTestUtil.cnNodeId + "','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','COMPLETED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        List<Identifier> results = this.replicationDao.getCompletedCoordinatingNodeReplicasByDate(new Date(System.currentTimeMillis()), 0, 0);
        Assert.assertTrue(results.size() == 1);
        Assert.assertTrue(results.get(0).getValue().equals("test_guid"));
    }

    @Test
    public void testPendingReplicasByNode() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','QUEUED',TIMESTAMP '2020-01-01 12:00:00')");
        Map<NodeReference, Integer> results = this.replicationDao.getPendingReplicasByNode();
        Assert.assertTrue(results.size() == 2);
    }

    @Test
    public void testRecentFailedReplicasByNode() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','QUEUED',TIMESTAMP '2020-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:2','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        Map<NodeReference, Integer> results = this.replicationDao.getRecentFailedReplicas();
        Assert.assertTrue(results.size() == 0);
    }

    @Test
    public void testRecentCompletedReplicasByNode() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        Map<NodeReference, Integer> results = this.replicationDao.getRecentCompletedReplicas();
        Assert.assertTrue(results.size() == 0);
    }

    @Test
    public void testCountsByNodeStatus() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        Map<String, Integer> results = this.replicationDao.getCountsByNodeStatus();
        Assert.assertTrue(results.size() == 3);
    }

    @Test
    public void testRequestedReplicasByDate() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:3','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        List<ReplicationDao.ReplicaDto> results = this.replicationDao.getRequestedReplicasByDate(new Date(System.currentTimeMillis()));
        Assert.assertTrue(results.size() == 2);
        for (ReplicationDao.ReplicaDto result : results) {
            Assert.assertTrue(ReplicationStatus.REQUESTED.equals(result.replica.getReplicationStatus()));
        }
    }

    @Test
    public void testRequestedReplicasCount() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:3','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        NodeReference nodeRef = new NodeReference();
        nodeRef.setValue("mn:test:1");
        int count = this.replicationDao.getRequestedReplicationCount(nodeRef);
        Assert.assertTrue(count == 2);
    }

    @Test
    public void testGetMemberNodesWithQueuedReplica() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid4','mn:test:1','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid5','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid6','mn:test:3','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        Collection<NodeReference> nodes = this.replicationDao.getMemberNodesWithQueuedReplica();
        Assert.assertTrue(nodes.size() == 2);
    }

    @Test
    public void testGetQueuedReplicaCountByNode() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid7','mn:test:3','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid4','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid5','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid6','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid4','mn:test:1','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid5','mn:test:3','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid6','mn:test:4','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:4','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        int count = this.replicationDao.getQueuedReplicaCountByNode("mn:test:33");
        Assert.assertTrue(count == 0);
        count = this.replicationDao.getQueuedReplicaCountByNode("mn:test:1");
        Assert.assertTrue(count == 2);
        count = this.replicationDao.getQueuedReplicaCountByNode("mn:test:2");
        Assert.assertTrue(count == 4);
        count = this.replicationDao.getQueuedReplicaCountByNode("mn:test:3");
        Assert.assertTrue(count == 1);
        count = this.replicationDao.getQueuedReplicaCountByNode("mn:test:4");
        Assert.assertTrue(count == 2);
    }

    @Test
    public void testGetQueuedReplicasByNode() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid7','mn:test:3','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid4','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid5','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid6','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:1','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid4','mn:test:1','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid5','mn:test:3','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid6','mn:test:4','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:4','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        Assert.assertTrue(2 == this.replicationDao.getQueuedReplicasByNode("mn:test:1").size());
        Assert.assertTrue(4 == this.replicationDao.getQueuedReplicasByNode("mn:test:2").size());
        Assert.assertTrue(1 == this.replicationDao.getQueuedReplicasByNode("mn:test:3").size());
        Assert.assertTrue(2 == this.replicationDao.getQueuedReplicasByNode("mn:test:4").size());
    }

    @Test
    public void testQueuedReplicaExists() throws DataAccessException {
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid','mn:test:1','COMPLETED',TIMESTAMP '2011-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid2','mn:test:2','REQUESTED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid7','mn:test:3','REQUESTED',TIMESTAMP '2020-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid3','mn:test:2','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        this.jdbc.execute("INSERT INTO smreplicationstatus VALUES ('test_guid4','mn:test:3','QUEUED',TIMESTAMP '2012-01-01 12:00:00')");
        Assert.assertFalse(this.replicationDao.queuedReplicaExists("nosuch", "mn:test:2"));
        Assert.assertTrue(this.replicationDao.queuedReplicaExists("test_guid3", "mn:test:2"));
        Assert.assertTrue(this.replicationDao.queuedReplicaExists("test_guid4", "mn:test:3"));
    }
}

