/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECPoint;

public class MontgomeryLadderMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        int n;
        ECPoint[] eCPointArray = new ECPoint[]{eCPoint.getCurve().getInfinity(), eCPoint};
        int n2 = n = bigInteger.bitLength();
        while (--n2 >= 0) {
            int n4 = bigInteger.testBit(n2) ? 1 : 0;
            int n5 = 1 - n4;
            eCPointArray[n5] = eCPointArray[n5].add(eCPointArray[n4]);
            eCPointArray[n4] = eCPointArray[n4].twice();
        }
        return eCPointArray[0];
    }
}

