/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.solr.common.util.ContentStream;

public abstract class ContentStreamBase
implements ContentStream {
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    protected String name;
    protected String sourceInfo;
    protected String contentType;
    protected Long size;

    public static String getCharsetFromContentType(String contentType) {
        int idx;
        if (contentType != null && (idx = contentType.toLowerCase(Locale.ROOT).indexOf("charset=")) > 0) {
            return contentType.substring(idx + "charset=".length()).trim();
        }
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        String charset = ContentStreamBase.getCharsetFromContentType(this.getContentType());
        return charset == null ? new InputStreamReader(this.getStream(), DEFAULT_CHARSET) : new InputStreamReader(this.getStream(), charset);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public static class ByteArrayStream
    extends ContentStreamBase {
        private final byte[] bytes;

        public ByteArrayStream(byte[] bytes, String source) {
            this.bytes = bytes;
            this.contentType = null;
            this.name = source;
            this.size = new Long(bytes.length);
            this.sourceInfo = source;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class StringStream
    extends ContentStreamBase {
        private final String str;

        public StringStream(String str2) {
            this(str2, StringStream.detect(str2));
        }

        public StringStream(String str2, String contentType) {
            this.str = str2;
            this.contentType = contentType;
            this.name = null;
            this.size = new Long(str2.length());
            this.sourceInfo = "string";
        }

        public static String detect(String str2) {
            String detectedContentType = null;
            int lim = str2.length() - 1;
            for (int i = 0; i < lim; ++i) {
                char ch = str2.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                if (ch == '#' || ch == '/' && (str2.charAt(i + 1) == '/' || str2.charAt(i + 1) == '*') || ch == '{' || ch == '[') {
                    detectedContentType = "application/json";
                    break;
                }
                if (ch != '<') break;
                detectedContentType = "text/xml";
                break;
            }
            return detectedContentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.str.getBytes(DEFAULT_CHARSET));
        }

        @Override
        public Reader getReader() throws IOException {
            String charset = StringStream.getCharsetFromContentType(this.contentType);
            return charset == null ? new StringReader(this.str) : new InputStreamReader(this.getStream(), charset);
        }
    }

    public static class FileStream
    extends ContentStreamBase {
        private final File file;

        public FileStream(File f) {
            this.file = f;
            this.contentType = null;
            this.name = this.file.getName();
            this.size = this.file.length();
            this.sourceInfo = this.file.toURI().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getContentType() {
            if (this.contentType == null) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(this.file);
                    char first = (char)((InputStream)stream).read();
                    if (first == '<') {
                        String string = "application/xml";
                        return string;
                    }
                    if (first == '{') {
                        String string = "application/json";
                        return string;
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            return this.contentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }

    public static class URLStream
    extends ContentStreamBase {
        private final URL url;

        public URLStream(URL url) {
            this.url = url;
            this.sourceInfo = "url";
        }

        @Override
        public InputStream getStream() throws IOException {
            URLConnection conn = this.url.openConnection();
            this.contentType = conn.getContentType();
            this.name = this.url.toExternalForm();
            this.size = new Long(conn.getContentLength());
            return conn.getInputStream();
        }
    }
}

