/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanFirstQuery
extends SpanQuery {
    private SpanQuery match;
    private int end;

    public SpanFirstQuery(SpanQuery match2, int end) {
        this.match = match2;
        this.end = end;
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    public int getEnd() {
        return this.end;
    }

    public String getField() {
        return this.match.getField();
    }

    public Collection getTerms() {
        return this.match.getTerms();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public void extractTerms(Set terms) {
        this.match.extractTerms(terms);
    }

    public Spans getSpans(final IndexReader reader) throws IOException {
        return new Spans(){
            private Spans spans;
            {
                this.spans = SpanFirstQuery.this.match.getSpans(reader);
            }

            public boolean next() throws IOException {
                while (this.spans.next()) {
                    if (this.end() > SpanFirstQuery.this.end) continue;
                    return true;
                }
                return false;
            }

            public boolean skipTo(int target) throws IOException {
                if (!this.spans.skipTo(target)) {
                    return false;
                }
                if (this.spans.end() <= SpanFirstQuery.this.end) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.spans.doc();
            }

            public int start() {
                return this.spans.start();
            }

            public int end() {
                return this.spans.end();
            }

            public String toString() {
                return "spans(" + SpanFirstQuery.this.toString() + ")";
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanFirstQuery clone = null;
        SpanQuery rewritten = (SpanQuery)this.match.rewrite(reader);
        if (rewritten != this.match) {
            clone = (SpanFirstQuery)this.clone();
            clone.match = rewritten;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanFirstQuery)) {
            return false;
        }
        SpanFirstQuery other = (SpanFirstQuery)o;
        return this.end == other.end && this.match.equals(other.match) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = this.match.hashCode();
        h ^= h << 8 | h >>> 25;
        return h ^= Float.floatToRawIntBits(this.getBoost()) ^ this.end;
    }
}

