/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.PrettyPrinter;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;

public final class CollectionUtilities {
    public static final int ALL_EMPTY = 0;
    public static final int NOT_A_SUPERSET_B = 1;
    public static final int NOT_A_DISJOINT_B = 2;
    public static final int NOT_A_SUBSET_B = 4;
    public static final int NOT_A_EQUALS_B = 5;
    public static final int A_PROPER_SUBSET_OF_B = 3;
    public static final int A_PROPER_SUPERSET_B = 6;
    public static final int A_PROPER_OVERLAPS_B = 7;

    public static String join(Object[] array, String separator) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                result.append(separator);
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    public static String join(Collection collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    public static Map asMap(Object[][] source, Map target, boolean reverse) {
        int from = 0;
        int to = 1;
        if (reverse) {
            from = 1;
            to = 0;
        }
        for (int i = 0; i < source.length; ++i) {
            target.put(source[i][from], source[i][to]);
        }
        return target;
    }

    public static Collection addAll(Iterator source, Collection target) {
        while (source.hasNext()) {
            target.add(source.next());
        }
        return target;
    }

    public static int size(Iterator source) {
        int result = 0;
        while (source.hasNext()) {
            source.next();
            ++result;
        }
        return result;
    }

    public static Map asMap(Object[][] source) {
        return CollectionUtilities.asMap(source, new HashMap(), false);
    }

    public static Map removeAll(Map m, Collection itemsToRemove) {
        Iterator it = itemsToRemove.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            m.remove(item);
        }
        return m;
    }

    public Object getFirst(Collection c) {
        Iterator it = c.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static Object getBest(Collection c, Comparator comp, int direction) {
        Iterator it = c.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Object bestSoFar = it.next();
        while (it.hasNext()) {
            Object item = it.next();
            if (comp.compare(item, bestSoFar) != direction) continue;
            bestSoFar = item;
        }
        return bestSoFar;
    }

    public static Collection removeAll(Collection c, ObjectMatcher f) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!f.matches(item)) continue;
            it.remove();
        }
        return c;
    }

    public static Collection retainAll(Collection c, ObjectMatcher f) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (f.matches(item)) continue;
            it.remove();
        }
        return c;
    }

    public static boolean containsSome(Collection a, Collection b) {
        if (a.size() == 0 || b.size() == 0) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a instanceof SortedSet && b instanceof SortedSet) {
            SortedSet aa = (SortedSet)a;
            SortedSet bb = (SortedSet)b;
            aa.containsAll(null);
            Comparator bbc = bb.comparator();
            Comparator aac = aa.comparator();
            if (bbc == null) {
                if (aac == null) {
                    Iterator ai = aa.iterator();
                    Iterator bi = bb.iterator();
                    Comparable ao = (Comparable)ai.next();
                    Comparable bo = (Comparable)bi.next();
                    while (true) {
                        int rel;
                        if ((rel = ao.compareTo(bo)) < 0) {
                            if (!ai.hasNext()) {
                                return false;
                            }
                            ao = (Comparable)ai.next();
                            continue;
                        }
                        if (rel <= 0) break;
                        if (!bi.hasNext()) {
                            return false;
                        }
                        bo = (Comparable)bi.next();
                    }
                    return true;
                }
            } else if (((Object)bbc).equals(a)) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Object ao = ai.next();
                Object bo = bi.next();
                while (true) {
                    int rel;
                    if ((rel = aac.compare(ao, bo)) < 0) {
                        if (!ai.hasNext()) {
                            return false;
                        }
                        ao = ai.next();
                        continue;
                    }
                    if (rel <= 0) break;
                    if (!bi.hasNext()) {
                        return false;
                    }
                    bo = bi.next();
                }
                return true;
            }
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (!b.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection a, Collection b) {
        if (a == b) {
            return true;
        }
        if (b.size() == 0) {
            return true;
        }
        if (a.size() == 0) {
            return false;
        }
        if (a instanceof SortedSet && b instanceof SortedSet) {
            SortedSet aa = (SortedSet)a;
            SortedSet bb = (SortedSet)b;
            Comparator bbc = bb.comparator();
            Comparator aac = aa.comparator();
            if (bbc == null) {
                if (aac == null) {
                    Iterator ai = aa.iterator();
                    Iterator bi = bb.iterator();
                    Comparable ao = (Comparable)ai.next();
                    Comparable bo = (Comparable)bi.next();
                    while (true) {
                        int rel;
                        if ((rel = ao.compareTo(bo)) == 0) {
                            if (!bi.hasNext()) {
                                return true;
                            }
                            if (!ai.hasNext()) {
                                return false;
                            }
                            bo = (Comparable)bi.next();
                            ao = (Comparable)ai.next();
                            continue;
                        }
                        if (rel >= 0) break;
                        if (!ai.hasNext()) {
                            return false;
                        }
                        ao = (Comparable)ai.next();
                    }
                    return false;
                }
            } else if (((Object)bbc).equals(a)) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Object ao = ai.next();
                Object bo = bi.next();
                while (true) {
                    int rel;
                    if ((rel = aac.compare(ao, bo)) == 0) {
                        if (!bi.hasNext()) {
                            return true;
                        }
                        if (!ai.hasNext()) {
                            return false;
                        }
                        bo = bi.next();
                        ao = ai.next();
                        continue;
                    }
                    if (rel >= 0) break;
                    if (!ai.hasNext()) {
                        return false;
                    }
                    ao = ai.next();
                }
                return false;
            }
        }
        return a.containsAll(b);
    }

    public static boolean containsNone(Collection a, Collection b) {
        return !CollectionUtilities.containsSome(a, b);
    }

    public static int getContainmentRelation(Collection a, Collection b) {
        int result;
        if (a.size() == 0) {
            return b.size() == 0 ? 0 : 1;
        }
        if (b.size() == 0) {
            return 4;
        }
        Iterator it = a.iterator();
        for (result = 0; result != 6 && it.hasNext(); result |= b.contains(it.next()) ? 2 : 4) {
        }
        it = b.iterator();
        while ((result & 3) != 3 && it.hasNext()) {
            result |= a.contains(it.next()) ? 2 : 1;
        }
        return result;
    }

    public static String remove(String source, UnicodeSet removals) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(source, i);
            if (removals.contains(cp)) continue;
            UTF16.append(result, cp);
        }
        return result.toString();
    }

    public static String prettyPrint(UnicodeSet uset, boolean compressRanges, UnicodeSet toQuote, Transliterator quoter, Comparator ordering, Comparator spaceComparator) {
        PrettyPrinter pp = new PrettyPrinter().setCompressRanges(compressRanges);
        if (toQuote != null) {
            pp.setToQuote(toQuote);
        }
        if (ordering != null) {
            pp.setOrdering(ordering);
        }
        if (spaceComparator != null) {
            pp.setSpaceComparator(spaceComparator);
        }
        return pp.toPattern(uset);
    }

    public static UnicodeSet flatten(UnicodeSet exemplar1) {
        UnicodeSet result = new UnicodeSet();
        boolean gotString = false;
        UnicodeSetIterator it = new UnicodeSetIterator(exemplar1);
        while (it.nextRange()) {
            if (it.codepoint == UnicodeSetIterator.IS_STRING) {
                result.addAll(it.string);
                gotString = true;
                continue;
            }
            result.add(it.codepoint, it.codepointEnd);
        }
        if (gotString) {
            exemplar1.set(result);
        }
        return exemplar1;
    }

    public static class RegexIterator
    extends FilteredIterator {
        private Matcher matcher;

        public RegexIterator set(Iterator baseIterator, Matcher matcher) {
            super.set(baseIterator);
            this.matcher = matcher;
            return this;
        }

        public boolean isIncluded(Object item) {
            return this.matcher.reset((String)item).matches();
        }
    }

    public static class PrefixIterator
    extends FilteredIterator {
        private String prefix;

        public PrefixIterator set(Iterator baseIterator, String prefix) {
            super.set(baseIterator);
            this.prefix = prefix;
            return this;
        }

        public boolean isIncluded(Object item) {
            return ((String)item).startsWith(this.prefix);
        }
    }

    public static abstract class FilteredIterator
    implements Iterator {
        private Iterator baseIterator;
        private static final Object EMPTY = new Object();
        private static final Object DONE = new Object();
        private Object nextObject = EMPTY;

        public FilteredIterator set(Iterator baseIterator) {
            this.baseIterator = baseIterator;
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException("Doesn't support removal");
        }

        public Object next() {
            Object result = this.nextObject;
            this.nextObject = EMPTY;
            return result;
        }

        public boolean hasNext() {
            if (this.nextObject == DONE) {
                return false;
            }
            if (this.nextObject != EMPTY) {
                return true;
            }
            while (this.baseIterator.hasNext()) {
                this.nextObject = this.baseIterator.next();
                if (!this.isIncluded(this.nextObject)) continue;
                return true;
            }
            this.nextObject = DONE;
            return false;
        }

        public abstract boolean isIncluded(Object var1);
    }

    static class MultiComparator
    implements Comparator {
        private Comparator[] comparators;

        public MultiComparator(Comparator[] comparators) {
            this.comparators = comparators;
        }

        public int compare(Object arg0, Object arg1) {
            for (int i = 0; i < this.comparators.length; ++i) {
                int result = this.comparators[i].compare(arg0, arg1);
                if (result == 0) continue;
                if (result > 0) {
                    return i + 1;
                }
                return -(i + 1);
            }
            return 0;
        }
    }

    public static class InverseMatcher
    implements ObjectMatcher {
        ObjectMatcher other;

        public ObjectMatcher set(ObjectMatcher toInverse) {
            this.other = toInverse;
            return this;
        }

        public boolean matches(Object value) {
            return !this.other.matches(value);
        }
    }

    public static interface ObjectMatcher {
        public boolean matches(Object var1);
    }
}

