/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class TestResourceUtils
extends TestCase {
    public static final String NS = "http://jena.hp.com/test#";

    public TestResourceUtils(String name) {
        super(name);
    }

    public void testMaximalLowerElements() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        b.addProperty(RDFS.subClassOf, a);
        c.addProperty(RDFS.subClassOf, a);
        d.addProperty(RDFS.subClassOf, c);
        d.addProperty(RDFS.subClassOf, a);
        List<Object> abcd = Arrays.asList(a, b, c, d);
        List<Object> bcd = Arrays.asList(b, c, d);
        List<Object> cd = Arrays.asList(c, d);
        TestResourceUtils.assertEquals("Wrong number of remaining resources", 1, ResourceUtils.maximalLowerElements(abcd, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals("Result should be a", a, ResourceUtils.maximalLowerElements(abcd, RDFS.subClassOf, true).iterator().next());
        TestResourceUtils.assertEquals("Wrong number of remaining resources", 2, ResourceUtils.maximalLowerElements(bcd, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals("Wrong number of remaining resources", 1, ResourceUtils.maximalLowerElements(cd, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals("Result should be a", c, ResourceUtils.maximalLowerElements(cd, RDFS.subClassOf, true).iterator().next());
    }

    public void testRenameResource() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        Property p = m.createProperty(NS, "p");
        Property q = m.createProperty(NS, "q");
        a.addProperty(p, b);
        a.addProperty(q, c);
        d.addProperty(p, a);
        d.addProperty(p, b);
        Resource e2 = ResourceUtils.renameResource(a, "http://jena.hp.com/test#e");
        TestResourceUtils.assertTrue("should be no properties of a", !a.listProperties().hasNext());
        TestResourceUtils.assertEquals("uri of a", "http://jena.hp.com/test#a", a.getURI());
        TestResourceUtils.assertEquals("uri of e", "http://jena.hp.com/test#e", e2.getURI());
        TestResourceUtils.assertTrue("d should not have p a", !d.hasProperty(p, a));
        TestResourceUtils.assertTrue("d should have p e", d.hasProperty(p, e2));
        TestResourceUtils.assertTrue("e should have p b", e2.hasProperty(p, b));
        TestResourceUtils.assertTrue("e should have q c", e2.hasProperty(q, c));
        TestResourceUtils.assertTrue("d p b should be unchanged", d.hasProperty(p, b));
        Resource anon = ResourceUtils.renameResource(e2, null);
        TestResourceUtils.assertTrue("should be no properties of e", !e2.listProperties().hasNext());
        TestResourceUtils.assertEquals("uri of e", "http://jena.hp.com/test#e", e2.getURI());
        TestResourceUtils.assertTrue("anon", anon.isAnon());
        TestResourceUtils.assertTrue("d should not have p e", !d.hasProperty(p, e2));
        TestResourceUtils.assertTrue("d should have p anon", d.hasProperty(p, anon));
        TestResourceUtils.assertTrue("anon should have p b", anon.hasProperty(p, b));
        TestResourceUtils.assertTrue("anon should have q c", anon.hasProperty(q, c));
        TestResourceUtils.assertTrue("d p b should be unchanged", d.hasProperty(p, b));
        Resource f = m.createResource("http://jena.hp.com/test#f");
        f.addProperty(p, f);
        Resource f1 = ResourceUtils.renameResource(f, "http://jena.hp.com/test#f1");
        TestResourceUtils.assertFalse("Should be no f statements", m.listStatements(f, null, (RDFNode)null).hasNext());
        TestResourceUtils.assertTrue("f1 has p f1", f1.hasProperty(p, f1));
    }

    public void testReachableGraphClosure() {
        Model m0 = ModelFactory.createDefaultModel();
        Resource a = m0.createResource("a");
        Resource b = m0.createResource("b");
        Resource c = m0.createResource("c");
        Resource d = m0.createResource("d");
        Property p = m0.createProperty("p");
        m0.add(a, p, b);
        m0.add(a, p, c);
        m0.add(b, p, b);
        m0.add(b, p, a);
        m0.add(d, p, a);
        Model m1 = ModelFactory.createDefaultModel();
        m1.add(a, p, b);
        m1.add(a, p, c);
        m1.add(b, p, b);
        m1.add(b, p, a);
        TestResourceUtils.assertTrue("m1 should be isomorphic with the reachable sub-graph from a", m1.isIsomorphicWith(ResourceUtils.reachableClosure(a)));
    }

    public void testRemoveEquiv() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        Resource e2 = m.createResource("http://jena.hp.com/test#e");
        b.addProperty(RDFS.subClassOf, a);
        a.addProperty(RDFS.subClassOf, b);
        d.addProperty(RDFS.subClassOf, e2);
        e2.addProperty(RDFS.subClassOf, d);
        a.addProperty(RDFS.subClassOf, a);
        b.addProperty(RDFS.subClassOf, b);
        c.addProperty(RDFS.subClassOf, c);
        d.addProperty(RDFS.subClassOf, d);
        e2.addProperty(RDFS.subClassOf, e2);
        List<Object> abcde = Arrays.asList(a, b, c, d, e2);
        List<Object> ab = Arrays.asList(a, b);
        List<Object> cde = Arrays.asList(c, d, e2);
        List<Object> abde = Arrays.asList(a, b, d, e2);
        List<Object> de = Arrays.asList(d, e2);
        ArrayList<Object> in = new ArrayList<Object>();
        in.addAll(abcde);
        List out = null;
        TestResourceUtils.assertTrue(((Object)in).equals(abcde));
        TestResourceUtils.assertFalse(((Object)in).equals(cde));
        TestResourceUtils.assertNull(out);
        out = ResourceUtils.removeEquiv(in, RDFS.subClassOf, a);
        TestResourceUtils.assertFalse(((Object)in).equals(abcde));
        TestResourceUtils.assertTrue(((Object)in).equals(cde));
        TestResourceUtils.assertNotNull(out);
        TestResourceUtils.assertEquals(out, ab);
        out = ResourceUtils.removeEquiv(in, RDFS.subClassOf, e2);
        TestResourceUtils.assertFalse(((Object)in).equals(abcde));
        TestResourceUtils.assertTrue(((Object)in).equals(Collections.singletonList(c)));
        TestResourceUtils.assertNotNull(out);
        TestResourceUtils.assertEquals(out, de);
    }

    public void testPartition() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        Resource e2 = m.createResource("http://jena.hp.com/test#e");
        b.addProperty(RDFS.subClassOf, a);
        a.addProperty(RDFS.subClassOf, b);
        d.addProperty(RDFS.subClassOf, e2);
        e2.addProperty(RDFS.subClassOf, d);
        a.addProperty(RDFS.subClassOf, a);
        b.addProperty(RDFS.subClassOf, b);
        c.addProperty(RDFS.subClassOf, c);
        d.addProperty(RDFS.subClassOf, d);
        e2.addProperty(RDFS.subClassOf, e2);
        List<Object> abcde = Arrays.asList(a, b, c, d, e2);
        List<Object> ab = Arrays.asList(b, a);
        List<Object> cc = Arrays.asList(c);
        List<Object> de = Arrays.asList(e2, d);
        List partition = ResourceUtils.partition(abcde, RDFS.subClassOf);
        TestResourceUtils.assertEquals("Should be 3 partitions", 3, partition.size());
        TestResourceUtils.assertEquals("First parition should be (a,b)", ab, partition.get(0));
        TestResourceUtils.assertEquals("First parition should be (c)", cc, partition.get(1));
        TestResourceUtils.assertEquals("First parition should be (d,e)", de, partition.get(2));
    }
}

