/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class OneToManyMap
implements Map {
    private Map m_table = new HashMap();

    public OneToManyMap() {
    }

    public OneToManyMap(OneToManyMap map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Iterator j = map.getAll(key);
            while (j.hasNext()) {
                this.put(key, j.next());
            }
        }
    }

    public void clear() {
        this.m_table.clear();
    }

    public boolean containsKey(Object key) {
        return this.m_table.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Iterator values = this.m_table.values().iterator();
        while (values.hasNext()) {
            Object x = values.next();
            if (x.equals(value)) {
                return true;
            }
            if (!(x instanceof List) || !((List)x).contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object key, Object value) {
        Iterator i = this.getAll(key);
        while (i.hasNext()) {
            if (!i.next().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        Set s = CollectionFactory.createHashedSet();
        Iterator e0 = this.m_table.keySet().iterator();
        while (e0.hasNext()) {
            Object key = e0.next();
            List values = (List)this.m_table.get(key);
            ListIterator e1 = values.listIterator();
            while (e1.hasNext()) {
                s.add(new Entry(key, e1.next()));
            }
        }
        return s;
    }

    public boolean equals(Object o) {
        if (o instanceof Map) {
            return ((Object)this.entrySet()).equals(((Map)o).entrySet());
        }
        return false;
    }

    public Object get(Object key) {
        ArrayList entry = (ArrayList)this.m_table.get(key);
        if (entry != null && !entry.isEmpty()) {
            return entry.get(0);
        }
        return null;
    }

    public Iterator getAll(Object key) {
        ArrayList entry = (ArrayList)this.m_table.get(key);
        return entry != null ? entry.iterator() : NullIterator.instance;
    }

    public int hashCode() {
        int hc = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            hc ^= i.next().hashCode();
        }
        return hc;
    }

    public boolean isEmpty() {
        return this.m_table.isEmpty();
    }

    public Set keySet() {
        return this.m_table.keySet();
    }

    public Object put(Object key, Object value) {
        ArrayList entries = (ArrayList)this.m_table.get(key);
        entries = entries == null ? new ArrayList() : entries;
        entries.add(value);
        this.m_table.put(key, entries);
        return null;
    }

    public void putAll(Map m) {
        boolean many = m instanceof OneToManyMap;
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (many) {
                Iterator j = ((OneToManyMap)m).getAll(key);
                while (j.hasNext()) {
                    this.put(key, j.next());
                }
                continue;
            }
            this.put(key, m.get(key));
        }
    }

    public Object remove(Object key) {
        this.m_table.remove(key);
        return null;
    }

    public void remove(Object key, Object value) {
        List entries = (List)this.m_table.get(key);
        if (entries != null) {
            entries.remove(value);
            if (entries.isEmpty()) {
                this.m_table.remove(key);
            }
        }
    }

    public int size() {
        int size = 0;
        Iterator i = this.m_table.keySet().iterator();
        while (i.hasNext()) {
            size += ((List)this.m_table.get(i.next())).size();
        }
        return size;
    }

    public Collection values() {
        Set s = CollectionFactory.createHashedSet();
        Iterator e2 = this.m_table.keySet().iterator();
        while (e2.hasNext()) {
            s.addAll((List)this.m_table.get(e2.next()));
        }
        return s;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("OneToManyMap{");
        String sep = "";
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            buf.append(sep);
            buf.append(key);
            buf.append("={");
            String sep1 = "";
            Iterator j = this.getAll(key);
            while (j.hasNext()) {
                buf.append(sep1);
                buf.append(j.next());
                sep1 = ",";
            }
            buf.append("}");
            sep = ",";
        }
        buf.append("}");
        return buf.toString();
    }

    public static class Entry
    implements Map.Entry {
        private Object m_key = null;
        private Object m_value = null;

        private Entry(Object key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        public boolean equals(Object x) {
            if (x instanceof Map.Entry) {
                Map.Entry e1 = (Map.Entry)x;
                return (e1.getKey() == null ? this.m_key == null : e1.getKey().equals(this.m_key)) && (e1.getValue() == null ? this.m_value == null : e1.getValue().equals(this.m_value));
            }
            return false;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not implemented");
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

