/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.test;

import com.hp.hpl.jena.assembler.test.TestAssemblerPackage;
import com.hp.hpl.jena.mem.test.TestMemPackage;
import com.hp.hpl.jena.n3.test.N3TestSuite;
import com.hp.hpl.jena.n3.turtle.test.TurtleTestSuite;
import com.hp.hpl.jena.rdf.arp.states.test.TestARPStates;
import com.hp.hpl.jena.rdf.arp.test.MoreTests;
import com.hp.hpl.jena.rdf.arp.test.SAX2RDFTest;
import com.hp.hpl.jena.rdf.arp.test.TaintingTests;
import com.hp.hpl.jena.rdf.arp.test.URITests;
import com.hp.hpl.jena.regression.MegaTestSuite;
import com.hp.hpl.jena.shared.test.TestSharedPackage;
import com.hp.hpl.jena.test.TestPackageARQ;
import com.hp.hpl.jena.vocabulary.test.TestVocabularies;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestPackage
extends TestSuite {
    public static Test suite() {
        return new TestPackage();
    }

    private TestPackage() {
        super("Jena");
        this.addTest("Enhanced", com.hp.hpl.jena.enhanced.test.TestPackage.suite());
        this.addTest("Graph", com.hp.hpl.jena.graph.test.TestPackage.suite());
        this.addTest(TestMemPackage.suite());
        this.addTest("Model", com.hp.hpl.jena.rdf.model.test.TestPackage.suite());
        this.addTest("N3", N3TestSuite.suite());
        this.addTest("Turtle", TurtleTestSuite.suite());
        TestSuite arqSuite = TestPackageARQ.suite();
        if (arqSuite != null) {
            this.addTest("ARQ", arqSuite);
        } else {
            System.err.println("ARQ test suite not run");
        }
        this.addTest("XML Output", com.hp.hpl.jena.xmloutput.test.TestPackage.suite());
        this.addTest("Util", com.hp.hpl.jena.util.test.TestPackage.suite());
        this.addTest(com.hp.hpl.jena.util.iterator.test.TestPackage.suite());
        this.addTest("Mega", MegaTestSuite.suite());
        this.addTest(com.hp.hpl.jena.rdf.arp.test.TestPackage.suite());
        this.addTest(TestAssemblerPackage.suite());
        this.addTest(SAX2RDFTest.suite());
        this.addTest(MoreTests.suite());
        this.addTest(TestARPStates.suite());
        this.addTest(URITests.suite());
        this.addTest(TaintingTests.suite());
        this.addTest("Vocabularies", TestVocabularies.suite());
        this.addTest(TestSharedPackage.suite());
        this.addTest("Reasoners", com.hp.hpl.jena.reasoner.test.TestPackage.suite());
        this.addTest("Composed graphs", com.hp.hpl.jena.graph.compose.test.TestPackage.suite());
        this.addTest("Ontology", com.hp.hpl.jena.ontology.impl.test.TestPackage.suite());
        this.addTest("cmd line utils", jena.test.TestPackage.suite());
    }

    private void addTest(String name, TestSuite tc) {
        tc.setName(name);
        this.addTest(tc);
    }
}

