/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternOptimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.GraphStatisticsHeuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.ProbabilisticFramework;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCounting;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityDataModel;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConfig
extends TestCase {
    private static long size;
    private static Model graphM;
    private static Set exProperty;
    private static final Property firstnameP;
    private static final Property lastnameP;
    private static final Property workplaceP;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestConfig(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        size = graphM.size();
        exProperty.add(firstnameP);
        exProperty.add(lastnameP);
        exProperty.add(workplaceP);
        exProperty.add(RDF.type);
        exProperty.add(RDF.first);
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testIndexLevel() {
        ProbabilityIndexModel probability = null;
        ProbabilityIndex index = null;
        Config config = new Config();
        config.setIndexLevel(1);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(graphM, config);
        index = probability.getIndex();
        TestConfig.assertTrue(index.getLevel() == 1);
        TestConfig.assertTrue(index.allowsJoinedProbability());
        Model indexM = ProbabilityFactory.createIndex(graphM, new Config(0));
        probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, config);
        index = probability.getIndex();
        TestConfig.assertTrue(index.getLevel() == 0);
        TestConfig.assertTrue(!index.allowsJoinedProbability());
    }

    public void testBasicPatternHeuristic() {
        BasicPatternOptimizer optimizer = null;
        HeuristicBasicPattern heuristic = null;
        Config config = new Config();
        config.setBasicPatternHeuristic("BGP_GRAPH_STATISTICS_HANDLER");
        optimizer = new BasicPatternOptimizer(ARQ.getContext(), graphM.getGraph(), null, config);
        heuristic = optimizer.getHeuristicBasicPattern();
        TestConfig.assertTrue(heuristic instanceof GraphStatisticsHeuristic);
        optimizer = new BasicPatternOptimizer(ARQ.getContext(), graphM.getGraph(), null, new Config("BGP_PROBABILISTIC_FRAMEWORK"));
        heuristic = optimizer.getHeuristicBasicPattern();
        TestConfig.assertTrue(heuristic instanceof ProbabilisticFramework);
        optimizer = new BasicPatternOptimizer(ARQ.getContext(), graphM.getGraph(), null, new Config("BGP_VARIABLE_COUNTING"));
        heuristic = optimizer.getHeuristicBasicPattern();
        TestConfig.assertTrue(heuristic instanceof VariableCounting);
    }

    public void testExProperty() {
        ProbabilityIndexModel probability = null;
        ProbabilityIndex index = null;
        Set exclude = null;
        Config config = new Config();
        config.setExProperty(exProperty);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(graphM, config);
        index = probability.getIndex();
        exclude = index.getExProperty();
        TestConfig.assertTrue(exclude.containsAll(exProperty));
        TestConfig.assertFalse(exclude.contains(RDF.Bag));
        Model indexM = ProbabilityFactory.createIndex(graphM, new Config(exProperty));
        probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, config);
        index = probability.getIndex();
        exclude = index.getExProperty();
        TestConfig.assertTrue(exclude.containsAll(exProperty));
        TestConfig.assertFalse(exclude.contains(RDF.Bag));
    }

    public void testLimitMinProbability1() {
        ProbabilityIndexModel probability = null;
        Config config = new Config();
        config.setLimitMinProbability(false);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(graphM, config);
        TestConfig.assertTrue(probability.getMinProbability() == Double.MIN_VALUE);
        TestConfig.assertTrue(probability.getMinJoinedProbability() == Double.MIN_VALUE);
        Model indexM = ProbabilityFactory.createIndex(graphM);
        probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, new Config(true));
        TestConfig.assertTrue(probability.getMinProbability() == 1.0 / (double)size);
        TestConfig.assertTrue(probability.getMinJoinedProbability() == 1.0 / (double)(size * size));
    }

    public void testLimitMinProbability2() {
        ProbabilityDataModel probability = null;
        probability = (ProbabilityDataModel)ProbabilityFactory.loadDataModel(graphM, new Config(false));
        TestConfig.assertTrue(probability.getMinProbability() == Double.MIN_VALUE);
        probability = (ProbabilityDataModel)ProbabilityFactory.loadDataModel(graphM, new Config(true));
        TestConfig.assertTrue(probability.getMinProbability() == 1.0 / (double)size);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestConfig");
        ts.addTest(new TestConfig("testIndexLevel"));
        ts.addTest(new TestConfig("testBasicPatternHeuristic"));
        ts.addTest(new TestConfig("testExProperty"));
        ts.addTest(new TestConfig("testLimitMinProbability1"));
        ts.addTest(new TestConfig("testLimitMinProbability2"));
        TestSetup wrapper = new TestSetup(ts){

            protected void setUp() {
                TestConfig.oneTimeSetUp();
            }

            protected void tearDown() {
                TestConfig.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    static {
        graphM = null;
        exProperty = new HashSet();
        firstnameP = ResourceFactory.createProperty("http://example.org#firstname");
        lastnameP = ResourceFactory.createProperty("http://example.org#lastname");
        workplaceP = ResourceFactory.createProperty("http://example.org#workplace");
    }
}

