/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.optimizer.Optimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAPI
extends TestCase {
    private static Model graphM = null;
    private static Model indexM = null;
    private static ProbabilityIndex index = null;
    private static ProbabilityIndexModel probability = null;
    private static Query query = null;
    private static Set exProperty = new HashSet();
    private static final Property firstnameP = ResourceFactory.createProperty("http://example.org#firstname");
    private static final Property lastnameP = ResourceFactory.createProperty("http://example.org#lastname");
    private static final Property workplaceP = ResourceFactory.createProperty("http://example.org#workplace");
    private static final Property msnP = ResourceFactory.createProperty("http://example.org#msn");
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestAPI(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(Util.readModel(testDataFileName));
        index = probability.getIndex();
        indexM = index.getModel();
        ElementTriplesBlock el = new ElementTriplesBlock();
        el.addTriple(new Triple(Var.alloc("x"), Var.alloc("y"), Var.alloc("z")));
        query = QueryFactory.make();
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        query.setQueryPattern(el);
        exProperty.add(firstnameP);
        exProperty.add(lastnameP);
        exProperty.add(workplaceP);
        exProperty.add(RDF.type);
        exProperty.add(RDF.first);
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testOptimizerEnable() {
        Optimizer.enable();
        Optimizer.enable(null);
        Optimizer.enable(new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.enable(ARQ.getContext(), new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.enable(graphM, indexM);
        Optimizer.enable(graphM, indexM, null);
        Optimizer.enable(graphM, indexM, new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.enable(ARQ.getContext(), graphM, indexM, null);
        Optimizer.enable(ARQ.getContext(), graphM, indexM, new Config("BGP_VARIABLE_COUNTING"));
    }

    public void testOptimizerDisable() {
        Optimizer.disable();
        Optimizer.disable(ARQ.getContext());
    }

    public void testExplain() {
        Optimizer.explain(graphM, query);
        Optimizer.explain(graphM, query, null);
        Optimizer.explain(graphM, query, new Config("BGP_VARIABLE_COUNTING"));
        Optimizer.explain(ARQ.getContext(), graphM, query, null);
        Optimizer.explain(ARQ.getContext(), graphM, query, new Config("BGP_VARIABLE_COUNTING"));
    }

    public void testIndex() {
        Optimizer.index(graphM);
        Optimizer.index(graphM, new Config(0));
        Optimizer.index(graphM, new Config(1));
        Optimizer.index(graphM, new Config(exProperty));
        Model indexM = Optimizer.index(graphM, new Config(0, exProperty));
        ProbabilityIndexModel probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, null);
        ProbabilityIndex index = probability.getIndex();
        Map properties = index.getProperties();
        Map histograms = index.getHistograms();
        TestAPI.assertTrue(!index.allowsJoinedProbability());
        TestAPI.assertTrue(properties.containsKey(msnP));
        TestAPI.assertTrue(!properties.containsKey(firstnameP));
        TestAPI.assertTrue(!properties.containsKey(lastnameP));
        TestAPI.assertTrue(histograms.containsKey(msnP));
        TestAPI.assertTrue(!histograms.containsKey(firstnameP));
        TestAPI.assertTrue(!histograms.containsKey(lastnameP));
    }

    public void testProbability1() {
        ProbabilityFactory.createDefaultModel(graphM, null);
        ProbabilityFactory.createDefaultModel(graphM.getGraph(), null);
        ProbabilityFactory.createIndex(graphM);
        ProbabilityFactory.createIndex(graphM.getGraph());
        ProbabilityFactory.createIndex(graphM, new Config(exProperty));
        ProbabilityFactory.createIndex(graphM, new Config(1, exProperty));
        ProbabilityFactory.createIndexModel(graphM, new Config(1, exProperty));
        ProbabilityFactory.loadDataModel(graphM, null);
        ProbabilityFactory.loadDataModel(graphM.getGraph(), null);
        ProbabilityFactory.loadDefaultModel(graphM, indexM, null);
        ProbabilityFactory.loadDefaultModel(graphM.getGraph(), indexM, null);
        ProbabilityFactory.loadIndexModel(graphM, indexM, null);
    }

    public void testProbability2() {
        ProbabilityFactory.createDefaultModel(graphM, new Config());
        ProbabilityFactory.createDefaultModel(graphM.getGraph(), new Config());
        ProbabilityFactory.createIndex(graphM);
        ProbabilityFactory.createIndex(graphM.getGraph());
        ProbabilityFactory.createIndex(graphM, new Config(exProperty));
        ProbabilityFactory.createIndex(graphM, new Config(1, exProperty));
        ProbabilityFactory.createIndexModel(graphM, new Config(1, exProperty));
        ProbabilityFactory.loadDataModel(graphM, new Config());
        ProbabilityFactory.loadDataModel(graphM.getGraph(), new Config());
        ProbabilityFactory.loadDefaultModel(graphM, indexM, new Config());
        ProbabilityFactory.loadDefaultModel(graphM.getGraph(), indexM, new Config());
        ProbabilityFactory.loadIndexModel(graphM, indexM, new Config());
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestAPI");
        ts.addTest(new TestAPI("testOptimizerDisable"));
        ts.addTest(new TestAPI("testOptimizerEnable"));
        ts.addTest(new TestAPI("testExplain"));
        ts.addTest(new TestAPI("testIndex"));
        ts.addTest(new TestAPI("testProbability1"));
        ts.addTest(new TestAPI("testProbability2"));
        TestSetup wrapper = new TestSetup(ts){

            protected void setUp() {
                TestAPI.oneTimeSetUp();
            }

            protected void tearDown() {
                TestAPI.oneTimeTearDown();
            }
        };
        return wrapper;
    }
}

