/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.AlreadyExists;
import com.hp.hpl.jena.sparql.DoesNotExist;
import com.hp.hpl.jena.sparql.modify.op.GraphMgt;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateDrop;
import com.hp.hpl.jena.sparql.suites.TestUpdateBase;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;

public class TestUpdateGraphMgt
extends TestUpdateBase {
    static final Node graphIRI = Node.createURI("http://example/graph");

    public void testCreateDrop1() {
        GraphStore gStore = GraphStoreFactory.create();
        GraphMgt u = new UpdateCreate(graphIRI);
        ((Update)u).exec(gStore);
        TestUpdateGraphMgt.assertTrue(gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue(TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        try {
            ((Update)u).exec(gStore);
            TestUpdateGraphMgt.fail();
        }
        catch (AlreadyExists ex) {
            // empty catch block
        }
        u = new UpdateDrop(graphIRI);
        ((Update)u).exec(gStore);
        TestUpdateGraphMgt.assertFalse(gStore.containsGraph(graphIRI));
        try {
            ((Update)u).exec(gStore);
            TestUpdateGraphMgt.fail();
        }
        catch (DoesNotExist doesNotExist) {
            // empty catch block
        }
    }

    public void testCreateDrop2() {
        GraphStore gStore = GraphStoreFactory.create();
        GraphMgt u = new UpdateCreate(graphIRI);
        ((Update)u).exec(gStore);
        u = new UpdateCreate(graphIRI, true);
        ((Update)u).exec(gStore);
        TestUpdateGraphMgt.assertTrue(gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue(TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        u = new UpdateDrop(graphIRI);
        ((Update)u).exec(gStore);
        TestUpdateGraphMgt.assertFalse(gStore.containsGraph(graphIRI));
        u = new UpdateDrop(graphIRI, true);
        ((Update)u).exec(gStore);
    }

    public void testCreateDrop3() {
        GraphStore gStore = GraphStoreFactory.create();
        TestUpdateGraphMgt.script(gStore, "create-1.rup");
        TestUpdateGraphMgt.assertTrue(gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue(TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
    }

    public void testCreateDrop4() {
        GraphStore gStore = GraphStoreFactory.create();
        gStore.addGraph(graphIRI, GraphUtils.makeDefaultGraph());
        TestUpdateGraphMgt.script(gStore, "drop-1.rup");
        TestUpdateGraphMgt.assertFalse(gStore.containsGraph(graphIRI));
    }
}

