/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSSE_Basic
extends TestCase {
    static Node int1 = Node.createLiteral("1", null, XSDDatatype.XSDinteger);
    static Node int2 = Node.createLiteral("2", null, XSDDatatype.XSDinteger);
    static Node int3 = Node.createLiteral("3", null, XSDDatatype.XSDinteger);
    static Node strLangEN = Node.createLiteral("xyz", "en", null);
    static Node typeLit1 = NodeFactory.createLiteralNode("123", null, "http://example/type");
    static Item int1i = Item.createNode(int1);
    static Item int2i = Item.createNode(int2);
    static Item int3i = Item.createNode(int3);

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSSE_Basic.class);
        ts.setName("SSE Basic");
        return ts;
    }

    public void testParseTerm_01() {
        this.parse("'xyz'");
    }

    public void testParseTerm_02() {
        this.parse("'xyz'@en");
    }

    public void testParseTerm_03() {
        this.parseBad("'xyz' @en");
    }

    public void testParseSymbol_01() {
        this.parse("a");
    }

    public void testParseSymbol_02() {
        this.parseBad("'a");
    }

    public void testParseSymbol_04() {
        this.parse("a@");
    }

    public void testParseList_01() {
        this.parse("()");
    }

    public void testParseList_02() {
        this.parse("(a)");
    }

    public void testParseList_03() {
        this.parse(" (a)");
    }

    public void testParseList_04() {
        this.parse("( a)");
    }

    public void testParseList_05() {
        this.parse("(a )");
    }

    public void testParseList_06() {
        this.parse("(a) ");
    }

    public void testParseList_07() {
        this.parse("('a') ");
    }

    public void testParseList_08() {
        this.parse("(<a>) ");
    }

    public void testParse_10() {
        this.parseBad("'foo' @en");
    }

    public void testLit_01() {
        this.testNode("'foo'");
    }

    public void testLit_02() {
        this.testNode("\"foo\"");
    }

    public void testLit_03() {
        this.testNode("''");
    }

    public void testLit_04() {
        this.testNode("\"\"");
    }

    public void testLit_05() {
        this.testNode("'foo'@en");
    }

    public void testLit_06() {
        this.parseBad("'foo' @en");
    }

    public void testLit_07() {
        this.parseBad("'");
    }

    public void testLit_08() {
        this.parseBad("'\"");
    }

    public void testLit_09() {
        this.parseBad("'''");
    }

    public void testLit_10() {
        this.parseBad("''@");
    }

    public void testLit_11() {
        this.testNode("'''abc\\ndef'''");
    }

    public void testLit_12() {
        Node n = Node.createLiteral("A\tB");
        this.testNode("'''A\\tB'''", n);
    }

    public void testNum_1() {
        this.testNode("1");
    }

    public void testNum_2() {
        this.testNode("1.1");
    }

    public void testNum_3() {
        this.testNode("1.0e6");
    }

    public void testNum_4() {
        this.parseBadNode("1 ");
    }

    public void testNum_5() {
        this.parseBadNode("1 1");
    }

    public void testURI_1() {
        this.testNode("<http://example/base>");
    }

    public void testURI_2() {
        this.parseBadNode("http://example/baseNoDelimiters");
    }

    public void testURI_3() {
        this.parseBadNode("<http://example/ space>");
    }

    public void testVar_01() {
        this.testVar("?x");
    }

    public void testVar_02() {
        this.testVar("?");
    }

    public void testVar_03() {
        this.testVar("?0");
    }

    public void testVar_04() {
        this.testVar("??x");
    }

    public void testVar_05() {
        this.testVar("??");
    }

    public void testVar_06() {
        this.testVar("??0");
    }

    public void testVar_07() {
        this.testVar("?.0");
    }

    public void testVar_08() {
        this.testVar("?.");
    }

    public void testVar_09() {
        Node v = SSE.parseNode("?");
        TestSSE_Basic.assertTrue(v instanceof Var);
        String vn = ((Var)v).getVarName();
        TestSSE_Basic.assertFalse(vn.equals(""));
    }

    public void testVar_10() {
        Node v = SSE.parseNode("??");
        TestSSE_Basic.assertTrue(v instanceof Var);
        String vn = ((Var)v).getVarName();
        TestSSE_Basic.assertFalse(vn.equals("?"));
    }

    public void testVar_11() {
        Node v = SSE.parseNode("?.");
        TestSSE_Basic.assertTrue(v instanceof Var);
        String vn = ((Var)v).getVarName();
        TestSSE_Basic.assertFalse(vn.equals("."));
    }

    public void testWS_1() {
        this.parseBadNode("?x ");
    }

    public void testWS_2() {
        this.parseBadNode(" ?x");
    }

    public void testNode_1() {
        this.testNode("3", int3);
    }

    public void testNode_2() {
        this.testNode("<http://example/node1>", Node.createURI("http://example/node1"));
    }

    public void testTypedLit_1() {
        this.testNode("\"123\"^^<http://example/type>", typeLit1);
    }

    public void testTypedLit_2() {
        this.testNode("'123'^^<http://example/type>", typeLit1);
    }

    public void testTypedLit_3() {
        this.testNode("'3'^^<" + XSDDatatype.XSDinteger.getURI() + ">", int3);
    }

    public void testSymbol_1() {
        this.testSymbol("word");
    }

    public void testSymbol_2() {
        this.testSymbol("+");
    }

    public void testNil_1() {
        this.testItem("nil", Item.nil);
    }

    public void testNil_2() {
        this.testNotItem("null", Item.nil);
    }

    public void testNil_3() {
        this.testNotItem("()", Item.nil);
    }

    public void testNil_4() {
        Item x = Item.createList();
        x.getList().add(Item.nil);
        this.testItem("(nil)", x);
    }

    public void testList_1() {
        Item item = this.parse("()");
        TestSSE_Basic.assertTrue(item.isList());
        TestSSE_Basic.assertEquals(item.getList().size(), 0);
    }

    public void testList_2() {
        this.testList("(1)", int1i);
    }

    public void testList_3() {
        this.testList("(1 2)", int1i, int2i);
    }

    public void testList_4() {
        this.testList("(1 a)", int1i, Item.createSymbol("a"));
    }

    public void testList_5() {
        Item list = Item.createList();
        list.getList().add(int1i);
        this.testList("((1) a)", list, Item.createSymbol("a"));
    }

    public void testList_6() {
        this.testList("(+ 1)", Item.createSymbol("+"), int1i);
    }

    public void testList_7() {
        this.testList("[+ 1]", Item.createSymbol("+"), int1i);
    }

    public void testMisc_01() {
        this.testEquals("()");
    }

    public void testMisc_02() {
        this.testEquals("(a)");
    }

    public void testMisc_10() {
        this.testNotEquals("(a)", "a");
    }

    public void testMisc_11() {
        this.testNotEquals("(a)", "()");
    }

    public void testMisc_12() {
        this.testNotEquals("(a)", "(<a>)");
    }

    private void testEquals(String x) {
        Item item1 = this.parse(x);
        Item item2 = this.parse(x);
        TestSSE_Basic.assertTrue(item1.equals(item2));
        TestSSE_Basic.assertTrue(item2.equals(item1));
    }

    private void testNotEquals(String x1, String x2) {
        Item item1 = this.parse(x1);
        Item item2 = this.parse(x2);
        TestSSE_Basic.assertFalse(item1.equals(item2));
        TestSSE_Basic.assertFalse(item2.equals(item1));
    }

    private Item parse(String str2) {
        Item item = SSE.parse(str2);
        return item;
    }

    private void testSymbol(String str2) {
        Item item = this.parse(str2);
        TestSSE_Basic.assertTrue(item.isSymbol());
        TestSSE_Basic.assertEquals(item.getSymbol(), str2);
    }

    private void testList(String str2, Item item1) {
        Item item = this.parse(str2);
        TestSSE_Basic.assertTrue(item.isList());
        Item i = item.getList().get(0);
        TestSSE_Basic.assertEquals(1, item.getList().size());
        TestSSE_Basic.assertEquals(item.getList().get(0), item1);
    }

    private void testList(String str2, Item item1, Item item2) {
        Item item = this.parse(str2);
        TestSSE_Basic.assertTrue(item.isList());
        TestSSE_Basic.assertEquals(2, item.getList().size());
        TestSSE_Basic.assertEquals(item.getList().get(0), item1);
        TestSSE_Basic.assertEquals(item.getList().get(1), item2);
    }

    private void testList(String str2, Item item1, Item item2, Item item3) {
        Item item = this.parse(str2);
        TestSSE_Basic.assertTrue(item.isList());
        TestSSE_Basic.assertEquals(3, item.getList().size());
        TestSSE_Basic.assertEquals(item.getList().get(0), item1);
        TestSSE_Basic.assertEquals(item.getList().get(1), item2);
        TestSSE_Basic.assertEquals(item.getList().get(2), item3);
    }

    private void testItem(String str2, Item result) {
        Item item = this.parse(str2);
        TestSSE_Basic.assertEquals(result, item);
    }

    private void testNotItem(String str2, Item result) {
        Item item = this.parse(str2);
        TestSSE_Basic.assertFalse(result.equals(item));
    }

    private void testNode(String str2) {
        Node node = SSE.parseNode(str2);
    }

    private void testVar(String str2) {
        Node node = SSE.parseNode(str2);
        TestSSE_Basic.assertTrue(node instanceof Var);
    }

    private void testNode(String str2, Node result) {
        Node node = SSE.parseNode(str2, null);
        TestSSE_Basic.assertEquals(result, node);
    }

    private void parseBad(String str2) {
        try {
            Item item = SSE.parse(str2);
            TestSSE_Basic.fail("Did not get a parse failure");
        }
        catch (SSEParseException ex) {
        }
        catch (ARQException aRQException) {
            // empty catch block
        }
    }

    private void parseBadNode(String str2) {
        try {
            Node node = SSE.parseNode(str2);
            TestSSE_Basic.fail("Did not get a parse failure");
        }
        catch (SSEParseException ex) {
        }
        catch (ARQException aRQException) {
            // empty catch block
        }
    }
}

