/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAPI
extends TestCase {
    private static final String ns = "http://example/ns#";
    Model m = null;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestAPI.class);
        ts.setName("TestMisc");
        return ts;
    }

    public void setUp() {
        this.m = GraphUtils.makeJenaDefaultModel();
        Resource r1 = this.m.createResource();
        Property p1 = this.m.createProperty("http://example/ns#p1");
        Property p2 = this.m.createProperty("http://example/ns#p1");
        Property p3 = this.m.createProperty("http://example/ns#p1");
        this.m.add(r1, p1, "x1");
        this.m.add(r1, p2, "X2");
        this.m.add(r1, p3, "y1");
    }

    public void tearDown() {
    }

    public void testInitialBindingsConstruct() {
        QueryExecution qExec = this.makeQExec("CONSTRUCT {?s ?p ?z} {?s ?p 'x1'}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", this.m.createLiteral("zzz"));
        qExec.setInitialBinding(init);
        Model r = qExec.execConstruct();
        TestAPI.assertTrue("Empty model", r.size() > 0L);
        Property p1 = this.m.createProperty("http://example/ns#p1");
        TestAPI.assertTrue("Empty model", r.contains(null, p1, init.get("z")));
        qExec.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_API1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        try {
            ResultSet rs = qExec.execSelect();
            TestAPI.assertTrue("No results", rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            TestAPI.assertSame("Not the same model as queried", qr.getModel(), this.m);
        }
        finally {
            qExec.close();
        }
    }

    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("o", this.m.createLiteral("y1"));
        qExec.setInitialBinding(init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals("Initial binding didn't restrict query properly", 1, count);
    }

    public void testInitialBindings2() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", this.m.createLiteral("zzz"));
        qExec.setInitialBinding(init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals("Initial binding restricted query improperly", 3, count);
    }

    public void testInitialBindings3() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p 'x1'}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", this.m.createLiteral("zzz"));
        qExec.setInitialBinding(init);
        ResultSet rs = qExec.execSelect();
        QuerySolution qs = rs.nextSolution();
        TestAPI.assertTrue("Initial setting not set correctly now", qs.getLiteral("z").getLexicalForm().equals("zzz"));
        qExec.close();
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, this.m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume(rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }
}

