/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternJoin;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Histogram;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Pattern;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityBase;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProbabilityIndexModel
extends ProbabilityBase {
    private long indexedSize = -1L;
    private long squaredIndexedSize = -1L;
    private double minJoinedProbability = 0.0;
    private long indexedNumRes = 0L;
    private ProbabilityIndex index = new ProbabilityIndex();
    private Map histograms = new HashMap();
    private Map patterns = new HashMap();
    private long indexedSSSize = -1L;
    private long indexedSOSize = -1L;
    private long indexedOSSize = -1L;
    private long indexedOOSize = -1L;
    private static Log log = LogFactory.getLog(ProbabilityIndexModel.class);

    public void create(Model dataModel, Config config) {
        super.create(dataModel);
        this.index.create(dataModel, config);
        this.init(config);
    }

    public void load(Model dataModel, Model indexModel, Config config) {
        super.load(dataModel);
        this.index.load(indexModel);
        this.init(config);
    }

    public Model index(Model dataModel, Config config) {
        this.create(dataModel, config);
        return this.index.getModel();
    }

    public double getProbability(Triple triple) {
        double sp = this.getSubjectProbability(triple);
        double pp = this.getPredicateProbability(triple);
        double op = this.getObjectProbability(triple);
        double p = -1.0;
        p = sp == 0.0 || pp == 0.0 || op == 0.0 ? 0.0 : this.check(this.getProbability(sp, pp, op));
        log.debug("Probability: " + sp + " [" + triple.getSubject() + "]");
        log.debug("Probability: " + pp + " [" + triple.getPredicate() + "]");
        log.debug("Probability: " + op + " [" + triple.getObject() + "]");
        log.debug("Probability: " + p + " [" + triple + "]");
        return p;
    }

    public double getSelectivity(Triple triple) {
        double s = new Long(this.selectivity.calculate(triple)).doubleValue() / (double)this.indexedSize;
        log.debug("Selectivity: " + s + " [" + triple + "]");
        return s;
    }

    public double getProbability(Triple triple1, Triple triple2) {
        if (triple2 == null) {
            return this.getProbability(triple1);
        }
        if (!this.index.allowsJoinedProbability()) {
            log.debug("The index does not support joined probability estimation (return 1.0");
            return 1.0;
        }
        double p = 1.0;
        Node predicate1 = triple1.getPredicate();
        Node predicate2 = triple2.getPredicate();
        String genericJoinType = BasicPatternJoin.genericType(triple1, triple2);
        String specificJoinType = BasicPatternJoin.specificType(triple1, triple2);
        if (!BasicPatternJoin.isJoined(triple1, triple2)) {
            if (BasicPatternJoin.varsOnly(triple1, triple2)) {
                log.debug("Triple pattens are not joined and contain variables only (return 1.0): [" + triple1 + ", " + triple2 + "]");
                return 1.0;
            }
            long st1 = new Double(this.getProbability(triple1) * (double)this.indexedSize).longValue();
            long st2 = new Double(this.getProbability(triple2) * (double)this.indexedSize).longValue();
            long ts = st1 * st2;
            p = this.checkJoined(new Double(ts) / (double)this.squaredIndexedSize);
            log.debug("Triple patterns are not joined (return " + p + "): [" + triple1 + ", " + triple2 + "]");
            return p;
        }
        if (predicate1.isURI() && predicate2.isURI()) {
            Pattern pattern = this.getPattern(triple1, triple2);
            if (this.patterns.containsKey(pattern)) {
                double correction = 1.0;
                double indexProbability = ((Long)this.patterns.get(pattern)).doubleValue() / (double)this.squaredIndexedSize;
                correction = specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bSS") ? this.getSubjectProbability(triple1) * this.getObjectProbability(triple1) * this.getObjectProbability(triple2) : (specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bSO") ? this.getSubjectProbability(triple1) * this.getObjectProbability(triple1) * this.getSubjectProbability(triple2) : (specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bOS") ? this.getObjectProbability(triple1) * this.getSubjectProbability(triple1) * this.getObjectProbability(triple2) : (specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bOO") ? this.getObjectProbability(triple1) * this.getSubjectProbability(triple1) * this.getSubjectProbability(triple2) : this.getSubjectProbability(triple1) * this.getObjectProbability(triple1) * this.getSubjectProbability(triple2) * this.getObjectProbability(triple2))));
                double correctedProbability = indexProbability * correction;
                p = correctedProbability == 0.0 ? correctedProbability : this.checkJoined(correctedProbability);
                log.debug("Index probability: " + indexProbability);
                log.debug("Pattern: " + pattern);
                log.debug("Correction: " + correction);
                log.debug("Corrected probability: " + correctedProbability);
                log.debug("Checked probability: " + p + " [" + triple1 + ", " + triple2 + "]");
                return p;
            }
            log.debug("Pattern not found in index: " + pattern);
        }
        double correction = 1.0;
        if (genericJoinType.equals("http://jena.hpl.hp.com/ARQo/join#SS")) {
            correction = new Long(this.indexedSSSize).doubleValue() / (double)this.squaredIndexedSize;
        } else if (genericJoinType.equals("http://jena.hpl.hp.com/ARQo/join#SO")) {
            correction = new Long(this.indexedSOSize).doubleValue() / (double)this.squaredIndexedSize;
        } else if (genericJoinType.equals("http://jena.hpl.hp.com/ARQo/join#OS")) {
            correction = new Long(this.indexedOSSize).doubleValue() / (double)this.squaredIndexedSize;
        } else if (genericJoinType.equals("http://jena.hpl.hp.com/ARQo/join#OO")) {
            correction = new Long(this.indexedOOSize).doubleValue() / (double)this.squaredIndexedSize;
        }
        if (specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bSS") || specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bSO")) {
            correction *= this.getSubjectProbability(triple1);
        } else if (specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bOS") || specificJoinType.equals("http://jena.hpl.hp.com/ARQo/join#bOO")) {
            correction *= this.getObjectProbability(triple1);
        }
        p = correction == 0.0 ? correction : this.checkJoined(this.getProbability(triple1) * this.getProbability(triple2) * correction);
        log.debug("Correction: " + correction);
        log.debug("Corrected probability: " + p + " [" + triple1 + ", " + triple2 + "]");
        return p;
    }

    public double getSelectivity(Triple triple1, Triple triple2) {
        if (triple2 == null) {
            return this.getSelectivity(triple1);
        }
        double s = new Double(this.selectivity.calculate(triple1, triple2)) / (double)this.squaredIndexedSize;
        log.debug("Selectivity: " + s + " [" + triple1 + ", " + triple2 + "]");
        return s;
    }

    public double getMinJoinedProbability() {
        return this.minJoinedProbability;
    }

    public long getIndexedSize() {
        return this.indexedSize;
    }

    public long getSquaredIndexedSize() {
        return this.squaredIndexedSize;
    }

    public ProbabilityIndex getIndex() {
        return this.index;
    }

    private double getSubjectProbability(Triple triple) {
        double s = 1.0;
        if (this.indexedNumRes > 0L) {
            s = new Long(this.getSubjectSize(triple)).doubleValue() / (double)this.indexedNumRes;
        }
        return s;
    }

    private long getSubjectSize(Triple triple) {
        if (triple.getSubject().isConcrete()) {
            return 1L;
        }
        return this.indexedNumRes;
    }

    private double getPredicateProbability(Triple triple) {
        double s = 1.0;
        if (this.indexedSize > 0L) {
            s = new Long(this.getPredicateSize(triple)).doubleValue() / (double)this.indexedSize;
        }
        return s;
    }

    private long getPredicateSize(Triple triple) {
        Node predicate = triple.getPredicate();
        if (!predicate.isConcrete()) {
            return this.indexedSize;
        }
        return this.index.lookup(ResourceFactory.createProperty(predicate.getURI()));
    }

    private double getObjectProbability(Triple triple) {
        double s = 1.0;
        if (this.indexedSize > 0L) {
            s = new Long(this.getObjectSize(triple)).doubleValue() / (double)this.indexedSize;
        }
        return s;
    }

    private long getObjectSize(Triple triple) {
        Node object = triple.getObject();
        if (!object.isConcrete()) {
            return this.indexedSize;
        }
        long size = 0L;
        Node predicate = triple.getPredicate();
        if (predicate.isURI()) {
            Property property = ResourceFactory.createProperty(predicate.getURI());
            if (this.histograms.containsKey(property)) {
                Histogram histogram = (Histogram)this.histograms.get(property);
                return histogram.getClassFrequency(object);
            }
            log.debug("The predicate has no corresponding histogram, is it in exclusion list? (return " + size + "): " + predicate);
            return size;
        }
        Iterator iter = this.histograms.keySet().iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            Histogram histogram = (Histogram)this.histograms.get(property);
            size += histogram.getClassFrequency(object);
        }
        return size;
    }

    protected double checkJoined(double p) {
        if (p < this.minJoinedProbability) {
            return this.minJoinedProbability;
        }
        if (p > 1.0) {
            return 1.0;
        }
        return p;
    }

    private Pattern getPattern(Triple triple1, Triple triple2) {
        String genericJoinType = BasicPatternJoin.genericTypeIgnorePP(triple1, triple2);
        Property joiningProperty = ResourceFactory.createProperty(triple1.getPredicate().getURI());
        Property joinedProperty = ResourceFactory.createProperty(triple2.getPredicate().getURI());
        Resource joinType = ResourceFactory.createResource(genericJoinType);
        return new Pattern(joiningProperty, joinedProperty, joinType);
    }

    private void init(Config config) {
        this.indexedSize = this.index.getIndexedSize();
        this.indexedNumRes = this.index.getIndexedNumRes();
        this.histograms = this.index.getHistograms();
        this.patterns = this.index.getPatterns();
        this.indexedSSSize = this.index.getIndexedSSSize();
        this.indexedSOSize = this.index.getIndexedSOSize();
        this.indexedOSSize = this.index.getIndexedOSSize();
        this.indexedOOSize = this.index.getIndexedOOSize();
        this.squaredIndexedSize = this.indexedSize * this.indexedSize;
        this.minProbability = 1.0 / (double)this.indexedSize;
        this.minJoinedProbability = 1.0 / (double)this.squaredIndexedSize;
        if (config != null && !config.limitMinProbability()) {
            this.minProbability = Double.MIN_VALUE;
            this.minJoinedProbability = Double.MIN_VALUE;
        }
        this.isLoaded = true;
    }
}

