/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRacer
extends TestCase {
    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testRacerName() {
        DIGAdapter r = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        TestRacer.assertEquals("Name should be racer", "Racer", r.getDigIdentifier().getName());
    }

    public void testRacerVersion() {
        DIGAdapter r = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        TestRacer.assertNotNull("Version should be non-null", r.getDigIdentifier().getVersion());
    }

    public void testRacerMessage() {
        DIGAdapter r = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        TestRacer.assertNotNull("Message should be non-null", r.getDigIdentifier().getMessage());
    }

    public void testRacerSupportsLanguage() {
        DIGAdapter r = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        this.iteratorTest(r.getDigIdentifier().supportsLanguage(), new Object[]{"top", "bottom", "catom", "ratom", "and", "or", "not", "some", "all", "atmost", "atleast", "inverse", "feature", "attribute", "intmin", "intmax", "intrange", "intequals", "defined", "stringequals"});
    }

    public void testRacerSupportsTell() {
        DIGAdapter r = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        this.iteratorTest(r.getDigIdentifier().supportsTell(), new Object[]{"defconcept", "defrole", "deffeature", "defattribute", "defindividual", "impliesc", "equalc", "disjoint", "impliesr", "domain", "range", "rangeint", "transitive", "functional", "instanceof", "related", "value", "equalr", "rangestring"});
    }

    public void testRacerSupportsAsk() {
        DIGAdapter r = new DIGAdapter(OntModelSpec.OWL_DL_MEM, ModelFactory.createOntologyModel().getGraph());
        this.iteratorTest(r.getDigIdentifier().supportsAsk(), new Object[]{"allConceptNames", "allRoleNames", "allIndividuals", "satisfiable", "subsumes", "disjoint", "parents", "children", "descendants", "ancestors", "equivalents", "rparents", "rchildren", "rancestors", "rdescendants", "instances", "types", "instance", "roleFillers", "relatedIndividuals", "toldValues"});
    }

    protected void iteratorTest(Iterator i, Object[] expected) {
        TestRacer.assertNotNull("Iterator should not be null", i);
        Log logger = LogFactory.getLog(this.getClass());
        ArrayList<Object> expList = new ArrayList<Object>();
        for (int j = 0; j < expected.length; ++j) {
            expList.add(expected[j]);
        }
        while (i.hasNext()) {
            Object next = i.next();
            if (!expList.contains(next)) {
                logger.debug(this.getName() + " - Unexpected iterator result: " + next);
            }
            TestRacer.assertTrue("Value " + next + " was not expected as a result from this iterator ", expList.contains(next));
            TestRacer.assertTrue("Value " + next + " was not removed from the list ", expList.remove(next));
        }
        if (expList.size() != 0) {
            logger.debug(this.getName() + "Expected iterator results not found");
            Iterator j = expList.iterator();
            while (j.hasNext()) {
                logger.debug(this.getName() + " - missing: " + j.next());
            }
        }
        TestRacer.assertEquals("There were expected elements from the iterator that were not found", 0, expList.size());
    }
}

