/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;
import junit.framework.TestSuite;

public class TestSimpleListStatements
extends ModelTestBase {
    Model model = null;
    static boolean booleanValue = true;
    static char charValue = (char)99;
    static long longValue = 456L;
    static float floatValue = 5.67f;
    static double doubleValue = 6.78;
    static String stringValue = "stringValue";
    static String langValue = "en";

    public TestSimpleListStatements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestSimpleListStatements.class);
    }

    protected void setUp() throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.createResource("http://example.org/boolean").addLiteral(RDF.value, booleanValue);
        this.model.createResource("http://example.org/char").addLiteral(RDF.value, charValue);
        this.model.createResource("http://example.org/long").addLiteral(RDF.value, longValue);
        this.model.createResource("http://example.org/float").addLiteral(RDF.value, floatValue);
        this.model.createResource("http://example.org/double").addLiteral(RDF.value, doubleValue);
        this.model.createResource("http://example.org/string").addProperty(RDF.value, stringValue);
        this.model.createResource("http://example.org/langString").addProperty(RDF.value, stringValue, langValue);
    }

    protected void tearDown() throws Exception {
        this.model.close();
        this.model = null;
    }

    public void testBoolean() {
        List got = this.model.listLiteralStatements(null, null, booleanValue).toList();
        TestSimpleListStatements.assertEquals(1, got.size());
        Statement it = (Statement)got.get(0);
        TestSimpleListStatements.assertEquals(TestSimpleListStatements.resource("http://example.org/boolean"), it.getSubject());
        TestSimpleListStatements.assertEquals(this.model.createTypedLiteral(booleanValue), it.getObject());
    }

    public void testChar() {
        List got = this.model.listLiteralStatements((Resource)null, (Property)null, charValue).toList();
        TestSimpleListStatements.assertEquals(1, got.size());
        Statement it = (Statement)got.get(0);
        TestSimpleListStatements.assertEquals(TestSimpleListStatements.resource("http://example.org/char"), it.getSubject());
        TestSimpleListStatements.assertEquals(this.model.createTypedLiteral(charValue), it.getObject());
    }

    public void testLong() {
        List got = this.model.listLiteralStatements((Resource)null, (Property)null, longValue).toList();
        TestSimpleListStatements.assertEquals(1, got.size());
        Statement it = (Statement)got.get(0);
        TestSimpleListStatements.assertEquals(TestSimpleListStatements.resource("http://example.org/long"), it.getSubject());
        TestSimpleListStatements.assertEquals(this.model.createTypedLiteral(longValue), it.getObject());
    }

    public void testFloat() {
        List got = this.model.listlLiteralStatements(null, null, floatValue).toList();
        TestSimpleListStatements.assertEquals(1, got.size());
        Statement it = (Statement)got.get(0);
        TestSimpleListStatements.assertEquals(TestSimpleListStatements.resource("http://example.org/float"), it.getSubject());
        TestSimpleListStatements.assertEquals(this.model.createTypedLiteral(floatValue), it.getObject());
    }

    public void testDouble() {
        List got = this.model.listLiteralStatements(null, null, doubleValue).toList();
        TestSimpleListStatements.assertEquals(1, got.size());
        Statement it = (Statement)got.get(0);
        TestSimpleListStatements.assertEquals(TestSimpleListStatements.resource("http://example.org/double"), it.getSubject());
        TestSimpleListStatements.assertEquals(this.model.createTypedLiteral(doubleValue), it.getObject());
    }

    public void testString() {
        StmtIterator iter = this.model.listStatements(null, null, stringValue);
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            TestSimpleListStatements.assertEquals(iter.nextStatement().getSubject().getURI(), "http://example.org/string");
        }
        TestSimpleListStatements.assertEquals(1, i);
    }

    public void testLangString() {
        StmtIterator iter = this.model.listStatements(null, null, stringValue, langValue);
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            TestSimpleListStatements.assertEquals(iter.nextStatement().getSubject().getURI(), "http://example.org/langString");
        }
        TestSimpleListStatements.assertEquals(1, i);
    }

    public void testAll() {
        StmtIterator iter = this.model.listStatements(null, null, (RDFNode)null);
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            iter.next();
        }
        TestSimpleListStatements.assertEquals(7, i);
    }

    public void testAllString() {
        StmtIterator iter = this.model.listStatements(null, null, (String)null);
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            iter.next();
        }
        TestSimpleListStatements.assertEquals(7, i);
    }

    public Model modelWithStatements(StmtIterator it) {
        Model m = ModelFactory.createDefaultModel();
        while (it.hasNext()) {
            m.add(it.nextStatement());
        }
        return m;
    }

    public void checkReturns(String things, StmtIterator it) {
        Model got;
        Model wanted = TestSimpleListStatements.modelWithStatements(things);
        if (!wanted.isIsomorphicWith(got = this.modelWithStatements(it))) {
            TestSimpleListStatements.fail("wanted " + wanted + " got " + got);
        }
    }

    public void testListStatementsSPO() {
        Model m = ModelFactory.createDefaultModel();
        Resource A = TestSimpleListStatements.resource(m, "A");
        Resource X = TestSimpleListStatements.resource(m, "X");
        Property P = TestSimpleListStatements.property(m, "P");
        Property P1 = TestSimpleListStatements.property(m, "P1");
        Resource O = TestSimpleListStatements.resource(m, "O");
        Resource Y = TestSimpleListStatements.resource(m, "Y");
        String S1 = "S P O; S1 P O; S2 P O";
        String S2 = "A P1 B; A P1 B; A P1 C";
        String S3 = "X P1 Y; X P2 Y; X P3 Y";
        TestSimpleListStatements.modelAdd(m, S1);
        TestSimpleListStatements.modelAdd(m, S2);
        TestSimpleListStatements.modelAdd(m, S3);
        this.checkReturns(S1, m.listStatements(null, P, O));
        this.checkReturns(S2, m.listStatements(A, P1, (RDFNode)null));
        this.checkReturns(S3, m.listStatements(X, null, Y));
        m.close();
    }

    public void testListStatementsClever() {
        Model m = ModelFactory.createDefaultModel();
        TestSimpleListStatements.modelAdd(m, "S P O; S P O2; S P2 O; S2 P O");
        SimpleSelector sel = new SimpleSelector(null, null, (RDFNode)null){

            public boolean test(Statement st) {
                return ((Object)st.getSubject()).toString().length() + st.getPredicate().toString().length() + ((Object)st.getObject()).toString().length() == 15;
            }

            public boolean isSimple() {
                return false;
            }
        };
        this.checkReturns("S P O", m.listStatements(sel));
    }
}

