/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.TestSuite;

public class TestFasterGraphMem
extends AbstractTestGraph {
    public TestFasterGraphMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFasterGraphMem.class);
    }

    public Graph getGraph() {
        return new GraphMemFaster();
    }

    public void testRemoveAllDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestFasterGraphMem.graphAdd(g, "x P y; a Q b");
        g.getBulkUpdateHandler().removeAll();
        TestFasterGraphMem.assertEquals(0, g.size());
    }

    public void testSizeAfterRemove() {
        Graph g = this.getGraphWith("x p y");
        ExtendedIterator it = g.find(TestFasterGraphMem.triple("x ?? ??"));
        it.removeNext();
        TestFasterGraphMem.assertEquals(0, g.size());
    }

    public void testContainsConcreteDoesntUseFind() {
        GraphMemWithoutFind g = new GraphMemWithoutFind();
        TestFasterGraphMem.graphAdd(g, "x P y; a Q b");
        TestFasterGraphMem.assertTrue(g.contains(TestFasterGraphMem.triple("x P y")));
        TestFasterGraphMem.assertTrue(g.contains(TestFasterGraphMem.triple("a Q b")));
        TestFasterGraphMem.assertFalse(g.contains(TestFasterGraphMem.triple("a P y")));
        TestFasterGraphMem.assertFalse(g.contains(TestFasterGraphMem.triple("y R b")));
    }

    public void testSingletonStatisticsWithSingleTriple() {
        Graph g = this.getGraphWith("a P b");
        GraphStatisticsHandler h = g.getStatisticsHandler();
        TestFasterGraphMem.assertNotNull(h);
        TestFasterGraphMem.assertEquals(1L, h.getStatistic(TestFasterGraphMem.node("a"), Node.ANY, Node.ANY));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(TestFasterGraphMem.node("x"), Node.ANY, Node.ANY));
        TestFasterGraphMem.assertEquals(1L, h.getStatistic(Node.ANY, TestFasterGraphMem.node("P"), Node.ANY));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(Node.ANY, TestFasterGraphMem.node("Q"), Node.ANY));
        TestFasterGraphMem.assertEquals(1L, h.getStatistic(Node.ANY, Node.ANY, TestFasterGraphMem.node("b")));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(Node.ANY, Node.ANY, TestFasterGraphMem.node("y")));
    }

    public void testSingletonStatisticsWithSeveralTriples() {
        Graph g = this.getGraphWith("a P b; a P c; a Q b; x S y");
        GraphStatisticsHandler h = g.getStatisticsHandler();
        TestFasterGraphMem.assertNotNull(h);
        TestFasterGraphMem.assertEquals(3L, h.getStatistic(TestFasterGraphMem.node("a"), Node.ANY, Node.ANY));
        TestFasterGraphMem.assertEquals(1L, h.getStatistic(TestFasterGraphMem.node("x"), Node.ANY, Node.ANY));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(TestFasterGraphMem.node("y"), Node.ANY, Node.ANY));
        TestFasterGraphMem.assertEquals(2L, h.getStatistic(Node.ANY, TestFasterGraphMem.node("P"), Node.ANY));
        TestFasterGraphMem.assertEquals(1L, h.getStatistic(Node.ANY, TestFasterGraphMem.node("Q"), Node.ANY));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(Node.ANY, TestFasterGraphMem.node("R"), Node.ANY));
        TestFasterGraphMem.assertEquals(2L, h.getStatistic(Node.ANY, Node.ANY, TestFasterGraphMem.node("b")));
        TestFasterGraphMem.assertEquals(1L, h.getStatistic(Node.ANY, Node.ANY, TestFasterGraphMem.node("c")));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(Node.ANY, Node.ANY, TestFasterGraphMem.node("d")));
    }

    public void testDoubletonStatisticsWithTriples() {
        Graph g = this.getGraphWith("a P b; a P c; a Q b; x S y");
        GraphStatisticsHandler h = g.getStatisticsHandler();
        TestFasterGraphMem.assertNotNull(h);
        TestFasterGraphMem.assertEquals(-1L, h.getStatistic(TestFasterGraphMem.node("a"), TestFasterGraphMem.node("P"), Node.ANY));
        TestFasterGraphMem.assertEquals(-1L, h.getStatistic(Node.ANY, TestFasterGraphMem.node("P"), TestFasterGraphMem.node("b")));
        TestFasterGraphMem.assertEquals(-1L, h.getStatistic(TestFasterGraphMem.node("a"), Node.ANY, TestFasterGraphMem.node("b")));
        TestFasterGraphMem.assertEquals(0L, h.getStatistic(TestFasterGraphMem.node("no"), TestFasterGraphMem.node("P"), Node.ANY));
    }

    public void testStatisticsWithOnlyVariables() {
        this.testStatsWithAllVariables("");
        this.testStatsWithAllVariables("a P b");
        this.testStatsWithAllVariables("a P b; a P c");
        this.testStatsWithAllVariables("a P b; a P c; a Q b; x S y");
    }

    private void testStatsWithAllVariables(String triples) {
        Graph g = this.getGraphWith(triples);
        GraphStatisticsHandler h = g.getStatisticsHandler();
        TestFasterGraphMem.assertEquals((long)g.size(), h.getStatistic(Node.ANY, Node.ANY, Node.ANY));
    }

    public void testStatsWithConcreteTriple() {
        this.testStatsWithConcreteTriple(0, "x P y", "");
    }

    public void testStatsWithreification() {
        ReificationStyle style = ReificationStyle.Standard;
        GraphMemFaster g = new GraphMemFaster(style);
        GraphStatisticsHandler h = g.getStatisticsHandler();
        TestFasterGraphMem.graphAdd(g, "x rdf:subject A");
        TestFasterGraphMem.assertEquals(-1L, h.getStatistic(TestFasterGraphMem.node("x"), Node.ANY, Node.ANY));
    }

    private void testStatsWithConcreteTriple(int expect, String triple, String graph) {
        Graph g = this.getGraphWith(graph);
        GraphStatisticsHandler h = g.getStatisticsHandler();
        Triple t = TestFasterGraphMem.triple(triple);
        TestFasterGraphMem.assertEquals((long)expect, h.getStatistic(t.getSubject(), t.getPredicate(), t.getObject()));
    }

    protected final class GraphMemWithoutFind
    extends GraphMemFaster {
        protected GraphMemWithoutFind() {
        }

        public ExtendedIterator graphBaseFind(TripleMatch t) {
            throw new JenaException("find is Not Allowed");
        }
    }
}

