/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleCache;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestTripleCache
extends GraphTestBase {
    protected static Triple[] someTriples = TestTripleCache.makeTriples();

    public TestTripleCache(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTripleCache.class);
    }

    protected static Triple[] makeTriples() {
        Node[] S = new Node[]{TestTripleCache.node("x"), TestTripleCache.node("gooseberry"), TestTripleCache.node("_who")};
        Node[] P = new Node[]{TestTripleCache.node("p"), TestTripleCache.node("ramshackle"), TestTripleCache.node("_what")};
        Node[] O = new Node[]{TestTripleCache.node("o"), TestTripleCache.node("42"), TestTripleCache.node("'alpha'greek"), TestTripleCache.node("_o")};
        int here = 0;
        Triple[] result = new Triple[S.length * P.length * O.length];
        for (int i = 0; i < S.length; ++i) {
            for (int j = 0; j < P.length; ++j) {
                for (int k = 0; k < O.length; ++k) {
                    result[here++] = new Triple(S[i], P[j], O[k]);
                }
            }
        }
        return result;
    }

    public void testEmptyTripleCache() {
        TripleCache tc = new TripleCache();
        for (int i = 0; i < someTriples.length; ++i) {
            Triple t = someTriples[i];
            TestTripleCache.assertEquals(null, tc.get(t.getSubject(), t.getPredicate(), t.getObject()));
        }
    }

    public void testPutReturnsTriple() {
        TripleCache tc = new TripleCache();
        for (int i = 0; i < someTriples.length; ++i) {
            TestTripleCache.assertSame(someTriples[i], tc.put(someTriples[i]));
        }
    }

    public void testPutinTripleCache() {
        TripleCache tc = new TripleCache();
        for (int i = 0; i < someTriples.length; ++i) {
            Triple t = someTriples[i];
            tc.put(t);
            TestTripleCache.assertEquals(t, tc.get(t.getSubject(), t.getPredicate(), t.getObject()));
        }
    }

    public void testCacheClash() {
        TripleCache tc = new TripleCache();
        Triple A = new Triple(TestTripleCache.node("eg:Yx"), TestTripleCache.node("p"), TestTripleCache.node("o"));
        Triple B = new Triple(TestTripleCache.node("eg:ZY"), TestTripleCache.node("p"), TestTripleCache.node("o"));
        TestTripleCache.assertEquals(A.hashCode(), B.hashCode());
        tc.put(A);
        TestTripleCache.assertEquals(null, tc.get(B.getSubject(), B.getPredicate(), B.getObject()));
    }
}

