/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.SlotValuator;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.List;

public abstract class QueryTestBase
extends GraphTestBase {
    protected static Map1 getFirst = new Map1(){

        public Object map1(Object x) {
            return ((List)x).get(0);
        }
    };
    protected static final IndexValues noIVs = new IndexValues(){

        public Object get(int i) {
            return null;
        }
    };
    protected static final Mapping emptyMapping = new Mapping(new Node[0]);
    protected VariableIndexes noVariables = new VariableIndexes(){

        public int indexOf(String name) {
            return -1;
        }
    };
    protected static final Node X = Query.X;
    protected static final Node Y = Query.Y;
    protected static final Node Z = Query.Z;
    protected static final Node ANY = Node.ANY;
    protected final Node[] justX = new Node[]{X};

    public QueryTestBase(String name) {
        super(name);
    }

    protected Expression notEqual(Node x, Node y) {
        return new Dyadic(QueryTestBase.asExpression(x), "http://jena.hpl.hp.com/constraints/NE", QueryTestBase.asExpression(y)){

            public boolean evalBool(Object x, Object y) {
                return !x.equals(y);
            }
        };
    }

    protected Expression areEqual(Node x, Node y) {
        return new Dyadic(QueryTestBase.asExpression(x), "http://jena.hpl.hp.com/constraints/EQ", QueryTestBase.asExpression(y)){

            public boolean evalBool(Object x, Object y) {
                return x.equals(y);
            }
        };
    }

    protected Expression matches(Node x, Node y) {
        return new Dyadic(QueryTestBase.asExpression(x), "http://jena.hpl.hp.com/constraints/MATCHES", QueryTestBase.asExpression(y)){

            public boolean evalBool(Object L, Object R) {
                Node l = (Node)L;
                Node r = (Node)R;
                return l.toString(false).indexOf(r.toString(false)) > -1;
            }
        };
    }

    protected Map1 select(final int index) {
        return new Map1(){

            public Object map1(Object o) {
                return ((List)o).get(index);
            }
        };
    }

    public static Expression asExpression(final Node x) {
        if (x.isVariable()) {
            return new Expression.Variable(){

                public String getName() {
                    return x.getName();
                }

                public Valuator prepare(VariableIndexes vi) {
                    return new SlotValuator(vi.indexOf(x.getName()));
                }
            };
        }
        return new Expression.Fixed(x);
    }
}

