/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.DBPropPrefix;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.Map;

public class DBPrefixMappingImpl
extends PrefixMappingImpl {
    protected DBPropGraph m_graphProperties = null;

    public DBPrefixMappingImpl(DBPropGraph graphProperties) {
        this.m_graphProperties = graphProperties;
        boolean commit = this.m_graphProperties.begin();
        ExtendedIterator it = this.m_graphProperties.getAllPrefixes();
        while (it.hasNext()) {
            DBPropPrefix prefix = (DBPropPrefix)it.next();
            super.setNsPrefix(prefix.getValue(), prefix.getURI());
        }
        this.m_graphProperties.conditionalCommit(commit);
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        super.removeNsPrefix(prefix);
        this.m_graphProperties.removePrefix(prefix);
        return this;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        super.setNsPrefix(prefix, uri);
        this.m_graphProperties.addPrefix(prefix, uri);
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map other) {
        this.checkUnlocked();
        Iterator it = other.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            this.setNsPrefix((String)e2.getKey(), (String)e2.getValue());
        }
        return this;
    }
}

