/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.util.AddressUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.logging.Level;

public class SocketConnector
implements Runnable {
    private final ConnectionManager connectionManager;
    private final Address address;
    private final ILogger logger;
    private final boolean silent;

    public SocketConnector(ConnectionManager connectionManager, Address address, boolean silent) {
        this.connectionManager = connectionManager;
        this.address = address;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
        this.silent = silent;
    }

    public void run() {
        if (!this.connectionManager.isLive()) {
            String message = "ConnectionManager is not live, connection attempt to " + this.address + " is cancelled!";
            this.log(Level.FINEST, message);
            return;
        }
        try {
            this.connectionManager.ioService.onIOThreadStart();
            this.log(Level.FINEST, "Starting to connect to " + this.address);
            Address thisAddress = this.connectionManager.ioService.getThisAddress();
            if (this.address.isIPv4()) {
                this.tryToConnect(this.address.getInetSocketAddress(), 0);
            } else if (thisAddress.isIPv6() && thisAddress.getScopeId() != null) {
                Inet6Address inetAddress = AddressUtil.getInetAddressFor((Inet6Address)this.address.getInetAddress(), thisAddress.getScopeId());
                this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), 0);
            } else {
                Collection<Inet6Address> possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)this.address.getInetAddress());
                Level level = this.silent ? Level.FINEST : Level.INFO;
                this.log(level, "Trying to connect possible IPv6 addresses: " + possibleInetAddresses);
                boolean connected = false;
                Exception error = null;
                for (Inet6Address inetAddress : possibleInetAddresses) {
                    try {
                        this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), 3000);
                        connected = true;
                        break;
                    }
                    catch (Exception e2) {
                        error = e2;
                    }
                }
                if (!connected) {
                    throw error;
                }
            }
        }
        catch (Throwable e3) {
            this.logger.log(Level.FINEST, e3.getMessage(), e3);
            this.connectionManager.failedConnection(this.address, e3, this.silent);
        }
    }

    private void tryToConnect(InetSocketAddress socketAddress, int timeout) throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        this.connectionManager.initSocket(socketChannel.socket());
        this.bindSocket(socketChannel);
        String message = "Connecting to " + socketAddress + ", timeout: " + timeout + ", bind-any: " + this.connectionManager.ioService.isSocketBindAny();
        this.log(Level.FINEST, message);
        try {
            socketChannel.configureBlocking(true);
            if (timeout > 0) {
                socketChannel.socket().connect(socketAddress, timeout);
            } else {
                socketChannel.connect(socketAddress);
            }
            this.log(Level.FINEST, "Successfully connected to: " + this.address + " using socket " + socketChannel.socket());
            MemberSocketInterceptor memberSocketInterceptor = this.connectionManager.getMemberSocketInterceptor();
            if (memberSocketInterceptor != null) {
                this.log(Level.FINEST, "Calling member socket interceptor: " + memberSocketInterceptor + " for " + socketChannel);
                memberSocketInterceptor.onConnect(socketChannel.socket());
            }
            socketChannel.configureBlocking(false);
            SocketChannelWrapper socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, true);
            Connection connection = this.connectionManager.assignSocketChannel(socketChannelWrapper);
            this.connectionManager.sendBindRequest(connection, this.address, true);
        }
        catch (Exception e2) {
            this.closeSocket(socketChannel);
            Level level = this.silent ? Level.FINEST : Level.INFO;
            this.log(level, "Could not connect to: " + socketAddress + ". Reason: " + e2.getClass().getSimpleName() + "[" + e2.getMessage() + "]");
            throw e2;
        }
    }

    private void bindSocket(SocketChannel socketChannel) throws IOException {
        InetAddress inetAddress;
        if (this.connectionManager.ioService.isSocketBindAny()) {
            inetAddress = null;
        } else {
            Address thisAddress = this.connectionManager.ioService.getThisAddress();
            inetAddress = thisAddress.getInetAddress();
        }
        Socket socket = socketChannel.socket();
        if (!this.connectionManager.useAnyOutboundPort()) {
            IOException ex = null;
            int retryCount = this.connectionManager.getOutboundPortCount() * 2;
            for (int i = 0; i < retryCount; ++i) {
                int port = this.connectionManager.acquireOutboundPort();
                InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
                try {
                    socket.bind(socketAddress);
                    return;
                }
                catch (IOException e2) {
                    ex = e2;
                    this.log(Level.FINEST, "Could not bind port[ " + port + "]: " + e2.getMessage());
                    continue;
                }
            }
            throw ex;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, 0);
        socket.bind(socketAddress);
    }

    private void closeSocket(SocketChannel socketChannel) {
        if (socketChannel != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void log(Level level, String message) {
        this.logger.log(level, message);
        this.connectionManager.ioService.getSystemLogService().logConnection(message);
    }
}

