/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class TopicManager
extends BaseManager {
    private final boolean FLOW_CONTROL_ENABLED;
    final Map<String, TopicInstance> mapTopics = new HashMap<String, TopicInstance>();

    TopicManager(Node node) {
        super(node);
        this.FLOW_CONTROL_ENABLED = node.getGroupProperties().TOPIC_FLOW_CONTROL_ENABLED.getBoolean();
    }

    public TopicInstance getTopicInstance(String name) {
        TopicInstance ti = this.mapTopics.get(name);
        if (ti == null) {
            ti = new TopicInstance(this, name);
            this.mapTopics.put(name, ti);
        }
        return ti;
    }

    public void syncForDead(Address deadAddress) {
        Collection<TopicInstance> instances = this.mapTopics.values();
        for (TopicInstance instance : instances) {
            instance.removeListener(deadAddress);
        }
    }

    public void syncForAdd() {
    }

    void registerListener(boolean add, String name, Data key, Address address, boolean includeValue) {
        TopicInstance instance = this.getTopicInstance(name);
        if (add) {
            instance.addListener(address, includeValue);
        } else {
            instance.removeListener(address);
        }
    }

    void destroy(String name) {
        TopicInstance instance = this.mapTopics.remove(name);
        if (instance != null) {
            instance.mapListeners.clear();
            this.node.listenerManager.removeAllRegisteredListeners(name);
        }
    }

    void doPublish(String name, Object msg) {
        Data dataMsg = null;
        try {
            dataMsg = IOUtil.toData(msg);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
        this.enqueueAndReturn(new TopicPublishProcess(name, dataMsg));
    }

    public final class TopicInstance {
        private final TopicManager topicManager;
        private final String name;
        private final TopicConfig topicConfig;
        private final Map<Address, Boolean> mapListeners = new HashMap<Address, Boolean>();

        public TopicInstance(TopicManager topicManager2, String name) {
            if (topicManager2 == null) {
                throw new NullPointerException("topic manager cannot be null");
            }
            if (name == null) {
                throw new NullPointerException("topic name cannot be null");
            }
            this.topicManager = topicManager2;
            this.name = name;
            String shortName = name.substring("t:".length());
            this.topicConfig = TopicManager.this.node.config.findMatchingTopicConfig(shortName);
            this.initializeListeners();
        }

        private void initializeListeners() {
            for (ListenerConfig lc : this.topicConfig.getMessageListenerConfigs()) {
                try {
                    TopicManager.this.node.listenerManager.createAndAddListenerItem(this.name, lc, Instance.InstanceType.TOPIC);
                    for (MemberImpl member : TopicManager.this.node.clusterManager.getMembers()) {
                        this.addListener(member.getAddress(), true);
                    }
                }
                catch (Exception e2) {
                    TopicManager.this.logger.log(Level.SEVERE, e2.getMessage(), e2);
                }
            }
        }

        public void addListener(Address address, boolean includeValue) {
            this.mapListeners.put(address, includeValue);
        }

        public void removeListener(Address address) {
            this.mapListeners.remove(address);
        }

        public void publish(Data msg) {
            this.topicManager.fireEvent(this.mapListeners, this.name, EntryEvent.TYPE_ADDED, msg, TopicManager.this.thisAddress, !TopicManager.this.FLOW_CONTROL_ENABLED);
        }

        public LocalTopicStatsImpl getTopicStats() {
            return new LocalTopicStatsImpl();
        }
    }

    class TopicPublishProcess
    implements Processable {
        final Data dataMsg;
        final String name;

        public TopicPublishProcess(String name, Data dataMsg) {
            this.dataMsg = dataMsg;
            this.name = name;
        }

        public void process() {
            TopicManager.this.getTopicInstance(this.name).publish(this.dataMsg);
        }
    }
}

