/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.core.Member;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.MulticastJoiner;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMulticastListener
implements MulticastListener {
    final Node node;
    final Set<String> trustedInterfaces;

    public NodeMulticastListener(Node node) {
        this.node = node;
        this.trustedInterfaces = node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().getTrustedInterfaces();
    }

    @Override
    public void onMessage(Object msg) {
        if (msg != null && msg instanceof JoinInfo) {
            JoinInfo joinInfo = (JoinInfo)msg;
            if (this.node.address != null && !this.node.address.equals(joinInfo.address)) {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.validateJoinRequest(joinInfo);
                }
                catch (Exception e2) {
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    Joiner joiner;
                    if (this.node.isActive() && this.node.joined()) {
                        if (joinInfo.isRequest()) {
                            if (this.node.isMaster()) {
                                this.node.multicastService.send(joinInfo.copy(false, this.node.address, this.node.getClusterImpl().getMembers().size()));
                            } else if (this.isMasterNode(joinInfo.address) && !this.checkMasterUuid(joinInfo.getUuid())) {
                                this.node.getLogger("NodeMulticastListener").log(Level.WARNING, "New join request has been received from current master. Removing " + this.node.getMasterAddress());
                                AddOrRemoveConnection removeConnection = new AddOrRemoveConnection(this.node.getMasterAddress(), false);
                                removeConnection.setNode(this.node);
                                this.node.clusterManager.enqueueAndReturn(removeConnection);
                            }
                        }
                    } else if (!this.node.joined() && !joinInfo.isRequest()) {
                        if (this.node.masterAddress == null) {
                            String masterHost = joinInfo.address.getHost();
                            if (this.trustedInterfaces.isEmpty() || AddressUtil.matchAnyInterface(masterHost, this.trustedInterfaces)) {
                                this.node.masterAddress = new Address(joinInfo.address);
                            }
                        }
                    } else if (joinInfo.isRequest() && (joiner = this.node.getJoiner()) instanceof MulticastJoiner) {
                        MulticastJoiner mjoiner = (MulticastJoiner)joiner;
                        mjoiner.onReceivedJoinInfo(joinInfo);
                    }
                }
            }
        }
    }

    private boolean isMasterNode(Address address) {
        return address.equals(this.node.getMasterAddress());
    }

    private boolean checkMasterUuid(String uuid) {
        Member masterMember = this.getMasterMember(this.node.getClusterImpl().getMembers());
        return masterMember == null || masterMember.getUuid().equals(uuid);
    }

    private Member getMasterMember(Set<Member> members) {
        if (members == null || members.isEmpty()) {
            return null;
        }
        return members.iterator().next();
    }
}

