/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.WriterBase;
import java.io.IOException;
import java.io.Writer;

public class SingleByteTextWriter
extends WriterBase {
    private final char mHighChar;
    private boolean mJustWroteBracket = false;

    public SingleByteTextWriter(Writer out, String enc, int charsetSize) {
        super(out);
        this.mHighChar = (char)charsetSize;
    }

    public void write(int c) throws IOException {
        if (c <= 62) {
            if (c == 60) {
                this.out.write("&lt;");
            } else if (c == 38) {
                this.out.write("&amp;");
            } else if (c == 62) {
                if (this.mJustWroteBracket) {
                    this.out.write("&gt;");
                } else {
                    this.out.write(c);
                }
            } else {
                this.out.write(c);
            }
            this.mJustWroteBracket = false;
        } else if (c >= this.mHighChar) {
            this.writeAsEntity(c);
        } else {
            this.out.write(c);
            this.mJustWroteBracket = c == 93;
        }
    }

    public void write(char[] cbuf, int offset, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(cbuf[offset]);
            }
            return;
        }
        len += offset;
        if (this.mJustWroteBracket && cbuf[offset] == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        char c = '\u0000';
        do {
            int outLen;
            int start = offset;
            String ent = null;
            while (offset < len) {
                c = cbuf[offset];
                if (c <= '>') {
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '>' && offset > start && cbuf[offset - 1] == ']') {
                        ent = "&gt;";
                        break;
                    }
                    if (c == '\u0000') {
                        this.throwNullChar();
                    }
                } else if (c >= this.mHighChar) break;
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (ent != null) {
                this.out.write(ent);
                ent = null;
                continue;
            }
            if (offset >= len) continue;
            this.writeAsEntity(c);
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }

    public void write(String str2, int offset, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(str2.charAt(offset));
            }
            return;
        }
        len += offset;
        if (this.mJustWroteBracket && str2.charAt(offset) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        char c = '\u0000';
        do {
            int outLen;
            int start = offset;
            String ent = null;
            while (offset < len) {
                c = str2.charAt(offset);
                if (c <= '>') {
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '>' && offset > start && str2.charAt(offset - 1) == ']') {
                        ent = "&gt;";
                        break;
                    }
                } else if (c >= this.mHighChar) break;
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(str2, start, outLen);
            }
            if (ent != null) {
                this.out.write(ent);
                ent = null;
                continue;
            }
            if (offset >= len) continue;
            this.writeAsEntity(c);
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }
}

