/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Logger;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.cn.replication.MNReplicationTask;
import org.dataone.service.exceptions.BaseException;

public class RejectedReplicationTaskHandler
implements RejectedExecutionHandler {
    public static Logger log = Logger.getLogger(RejectedReplicationTaskHandler.class);
    private CNode cn;

    @Override
    public void rejectedExecution(Runnable replicationTask, ThreadPoolExecutor executor) {
        block2: {
            boolean deleted = false;
            MNReplicationTask task = (MNReplicationTask)((Object)replicationTask);
            String msg = "Replication task id " + task.getTaskid() + " for identifier " + task.getPid().getValue() + " was rejected.";
            log.warn(msg);
            try {
                this.cn = D1Client.getCN();
                long serialVersion = this.cn.getSystemMetadata(null, task.getPid()).getSerialVersion().longValue();
                deleted = this.cn.deleteReplicationMetadata(null, task.getPid(), task.getTargetNode(), serialVersion);
                log.info("Deleted replica entry for" + task.getTargetNode().getValue() + " and identifier " + task.getPid().getValue() + " from the replica list.");
            }
            catch (BaseException e2) {
                log.error("Unable to delete the replica entry for identifier " + task.getPid().getValue() + ": " + e2.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e2.printStackTrace();
            }
        }
    }
}

