/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

public final class PolynomialRingGF2 {
    private PolynomialRingGF2() {
    }

    public static int add(int n, int n2) {
        return n ^ n2;
    }

    public static long multiply(int n, int n2) {
        long l = 0L;
        if (n2 != 0) {
            long l2 = (long)n2 & 0xFFFFFFFFL;
            while (n != 0) {
                byte by = (byte)(n & 1);
                if (by == 1) {
                    l ^= l2;
                }
                n >>>= 1;
                l2 <<= 1;
            }
        }
        return l;
    }

    public static int modMultiply(int n, int n2, int n4) {
        int n5 = 0;
        int n6 = PolynomialRingGF2.remainder(n, n4);
        int n7 = PolynomialRingGF2.remainder(n2, n4);
        if (n7 != 0) {
            int n8 = 1 << PolynomialRingGF2.degree(n4);
            while (n6 != 0) {
                byte by = (byte)(n6 & 1);
                if (by == 1) {
                    n5 ^= n7;
                }
                n6 >>>= 1;
                if ((n7 <<= 1) < n8) continue;
                n7 ^= n4;
            }
        }
        return n5;
    }

    public static int degree(int n) {
        int n2 = -1;
        while (n != 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    public static int degree(long l) {
        int n = 0;
        while (l != 0L) {
            ++n;
            l >>>= 1;
        }
        return n - 1;
    }

    public static int remainder(int n, int n2) {
        int n4 = n;
        if (n2 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        while (PolynomialRingGF2.degree(n4) >= PolynomialRingGF2.degree(n2)) {
            n4 ^= n2 << PolynomialRingGF2.degree(n4) - PolynomialRingGF2.degree(n2);
        }
        return n4;
    }

    public static int rest(long l, int n) {
        long l2 = l;
        if (n == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        long l3 = (long)n & 0xFFFFFFFFL;
        while (l2 >>> 32 != 0L) {
            l2 ^= l3 << PolynomialRingGF2.degree(l2) - PolynomialRingGF2.degree(l3);
        }
        int n2 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        while (PolynomialRingGF2.degree(n2) >= PolynomialRingGF2.degree(n)) {
            n2 ^= n << PolynomialRingGF2.degree(n2) - PolynomialRingGF2.degree(n);
        }
        return n2;
    }

    public static int gcd(int n, int n2) {
        int n4 = n;
        int n5 = n2;
        while (n5 != 0) {
            int n6 = PolynomialRingGF2.remainder(n4, n5);
            n4 = n5;
            n5 = n6;
        }
        return n4;
    }

    public static boolean isIrreducible(int n) {
        if (n == 0) {
            return false;
        }
        int n2 = PolynomialRingGF2.degree(n) >>> 1;
        int n4 = 2;
        for (int i = 0; i < n2; ++i) {
            if (PolynomialRingGF2.gcd((n4 = PolynomialRingGF2.modMultiply(n4, n4, n)) ^ 2, n) == 1) continue;
            return false;
        }
        return true;
    }

    public static int getIrreduciblePolynomial(int n) {
        if (n < 0) {
            System.err.println("The Degree is negative");
            return 0;
        }
        if (n > 31) {
            System.err.println("The Degree is more then 31");
            return 0;
        }
        if (n == 0) {
            return 1;
        }
        int n2 = 1 << n;
        int n4 = 1 << n + 1;
        for (int i = ++n2; i < n4; i += 2) {
            if (!PolynomialRingGF2.isIrreducible(i)) continue;
            return i;
        }
        return 0;
    }
}

