/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.lang.rdql.ExprBoolean;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNumeric;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLEvalFailureException;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import java.io.ByteArrayInputStream;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TS_ExprRDQL
extends TestSuite {
    static final String testSetName = "RDQL - Expressions";

    public static TestSuite suite() {
        return new TS_ExprRDQL(testSetName);
    }

    private TS_ExprRDQL(String name) {
        super(name);
        boolean FAILURE_OK = true;
        boolean NO_FAILURE = false;
        String xsd = "http://www.w3.org/2001/XMLSchema#";
        this.addTest(new TestNumeric("7", 7L));
        this.addTest(new TestNumeric("-3", -3L));
        this.addTest(new TestNumeric("3+4+5", 12L));
        this.addTest(new TestNumeric("(3+4)+5", 12L));
        this.addTest(new TestNumeric("3+(4+5)", 12L));
        this.addTest(new TestNumeric("3*4+5", 17L));
        this.addTest(new TestNumeric("3*(4+5)", 27L));
        this.addTest(new TestNumeric("10-3-5", 2L));
        this.addTest(new TestNumeric("(10-3)-5", 2L));
        this.addTest(new TestNumeric("10-(3-5)", 12L));
        this.addTest(new TestNumeric("10-3+5", 12L));
        this.addTest(new TestNumeric("10-(3+5)", 2L));
        this.addTest(new TestNumeric("1<<2", 4L));
        this.addTest(new TestNumeric("1<<2<<2", 16L));
        this.addTest(new TestNumeric("10000>>2", 2500L));
        this.addTest(new TestNumeric("1.5 + 2.5", 4.0));
        this.addTest(new TestNumeric("1.5 + 2", 3.5));
        this.addTest(new TestNumeric("4111222333444", 4111222333444L));
        this.addTest(new TestNumeric("1234 + 4111222333444", 4111222334678L));
        this.addTest(new TestBoolean("true", false, true));
        this.addTest(new TestBoolean("false", false, false));
        this.addTest(new TestBoolean("false || true", false, true));
        this.addTest(new TestBoolean("false && true", false, false));
        this.addTest(new TestBoolean("2 < 3", false, true));
        this.addTest(new TestBoolean("2 > 3", false, false));
        this.addTest(new TestBoolean("(2 < 3) && (3<4)", false, true));
        this.addTest(new TestBoolean("(2 < 3) && (3>=4)", false, false));
        this.addTest(new TestBoolean("(2 < 3) || (3>=4)", false, true));
        this.addTest(new TestBoolean("2 == 3", false, false));
        this.addTest(new TestBoolean("2 < '3'", false, true));
        this.addTest(new TestBoolean("\"fred\" ne \"joe\"", false, true));
        this.addTest(new TestBoolean("\"fred\" eq \"joe\"", false, false));
        this.addTest(new TestBoolean("\"fred\" eq \"fred\"", false, true));
        this.addTest(new TestBoolean("\"fred\" eq 'fred'", false, true));
        this.addTest(new TestBoolean("\"fred\" eq 'fr\\ed'", false, true));
        this.addTest(new TestBoolean("\"fred\" ne \"fred\"", false, false));
        this.addTest(new TestBoolean("'fred'^^<type1> eq 'fred'^^<type1>", false, true));
        this.addTest(new TestBoolean("'fred'^^<type1> ne 'joe'^^<type1>", false, true));
        this.addTest(new TestBoolean("'fred'^^<type1> eq 'fred'^^<type2>", false, false));
        this.addTest(new TestBoolean("'fred'^^<type1> ne 'fred'^^<type2>", false, true));
        this.addTest(new TestBoolean("'fred'^^<" + xsd + "string> eq 'fred'", false, true));
        this.addTest(new TestBoolean("'fred'^^<type1> eq 'fred'", false, false));
        this.addTest(new TestBoolean("'fred'^^<type1> ne 'fred'", false, true));
        this.addTest(new TestBoolean("'21'^^<int> == '21'", false, true));
        this.addTest(new TestBoolean("\"fred\\1\" eq 'fred1'", false, true));
        this.addTest(new TestBoolean("\"fred2\" eq 'fred\\2'", false, true));
        this.addTest(new TestBoolean("'fred\\\\3' ne \"fred3\"", false, true));
        this.addTest(new TestBoolean("\"urn:fred\" eq <urn:fred>", false, true));
        this.addTest(new TestBoolean("\"urn:fred\" ne <urn:fred>", false, false));
        this.addTest(new TestBoolean("\"urn:fred/1.5\" ne <urn:fred/1.5>", false, false));
        this.addTest(new TestBoolean("\"aabbcc\" =~ /abbc/", false, true));
        this.addTest(new TestBoolean("\"aabbcc\" =~ /a..c/", false, true));
        this.addTest(new TestBoolean("\"aabbcc\" =~ /^aabb/", false, true));
        this.addTest(new TestBoolean("\"aabbcc\" =~ /cc$/", false, true));
        this.addTest(new TestBoolean("\"aabbcc\" !~ /abbc/", false, false));
        this.addTest(new TestBoolean("\"aab*bcc\" =~ /ab\\*bc/", false, true));
        this.addTest(new TestBoolean("\"aabbcc\" ~~ /ab\\\\*bc/", false, true));
        this.addTest(new TestBoolean("'aabbcc' =~ /B.*B/i", false, true));
        this.addTest(new TestBoolean("1.5 < 2", false, true));
        this.addTest(new TestBoolean("1.5 > 2", false, false));
        this.addTest(new TestBoolean("1.5 < 2.3", false, true));
        this.addTest(new TestBoolean("1.5 > 2.3", false, false));
        this.addTest(new TestBoolean("4111222333444 > 1234", false, true));
        this.addTest(new TestBoolean("4111222333444 < 1234", false, false));
        this.addTest(new TestBoolean("2 < \"fred\"", true, false));
        this.addTest(new TestBoolean("2 || true", true, false));
    }

    public static class TestBoolean
    extends TestCase {
        String s;
        boolean failureCorrect;
        boolean rightAnswer;

        public TestBoolean(String _s, boolean _failureCorrect, boolean _rightAnswer) {
            super("Boolean test : " + _s + " ");
            this.s = _s;
            this.failureCorrect = _failureCorrect;
            this.rightAnswer = _rightAnswer;
        }

        protected void runTest() throws Throwable {
            ByteArrayInputStream in = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser parser = new RDQLParser(in);
            try {
                parser.Expression();
            }
            catch (Error e2) {
                TestBoolean.fail("Error throw in parse: " + this.s);
            }
            parser.top().postParse2(null);
            ExprRDQL e3 = (ExprRDQL)((Object)parser.top());
            TestBoolean.assertTrue("Expression is not ExprBoolean: " + e3.getClass().getName(), e3 instanceof ExprBoolean);
            ExprBoolean n = (ExprBoolean)e3;
            RDQL_NodeValue v = null;
            boolean result = false;
            try {
                v = n.evalRDQL(null, null);
                result = v.getBoolean();
            }
            catch (RDQLEvalFailureException evalEx) {
                if (!this.failureCorrect) {
                    throw evalEx;
                }
                result = false;
            }
            TestBoolean.assertEquals(this.s + " => " + result + " [" + this.rightAnswer + "]", result, this.rightAnswer);
        }
    }

    public static class TestNumeric
    extends TestCase {
        String s;
        boolean isDouble = false;
        long rightAnswer;
        double rightAnswerDouble;

        public TestNumeric(String _s, long _rightAnswer) {
            super("Numeric test : " + _s + " ");
            this.s = _s;
            this.rightAnswer = _rightAnswer;
            this.isDouble = false;
        }

        public TestNumeric(String _s, double _rightAnswer) {
            super("Numeric test : " + _s + " ");
            this.s = _s;
            this.rightAnswerDouble = _rightAnswer;
            this.isDouble = true;
        }

        protected void runTest() throws Throwable {
            ByteArrayInputStream in = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser parser = new RDQLParser(in);
            try {
                parser.Expression();
            }
            catch (Error e2) {
                TestNumeric.fail("Error thrown in parse: " + e2);
            }
            parser.top().postParse2(null);
            ExprRDQL e3 = (ExprRDQL)((Object)parser.top());
            TestNumeric.assertTrue("Expression is not ExprNumeric: " + e3.getClass().getName(), e3 instanceof ExprNumeric);
            ExprNumeric n = (ExprNumeric)e3;
            RDQL_NodeValue v = n.evalRDQL(null, null);
            if (!this.isDouble) {
                TestNumeric.assertEquals(this.s + " => " + v.getInt() + " [" + this.rightAnswer + "]", v.getInt(), this.rightAnswer);
            } else {
                TestNumeric.assertEquals(this.s + " => " + v.getDouble() + " [" + this.rightAnswerDouble + "]", v.getDouble(), this.rightAnswerDouble, 1.0E-4);
            }
        }
    }
}

