/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.test.ARPTests;
import com.hp.hpl.jena.rdf.arp.test.InFactoryX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.shared.wg.TestInputStreamFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.SAXException;

class WGTestSuite
extends TestSuite
implements ARPErrorNumbers {
    private static Resource jena2;
    private static Model testResults;
    private static boolean logging;
    private static String BASE_RESULTS_URI;
    public static boolean checkMessages;
    private static boolean inDevelopment;
    static String testNS;
    static String jjcNS;
    private static Property status;
    private static Property input;
    private static Property output;
    private static Property warning;
    private static Property errorCodes;
    private static Resource rdfxml;
    private static Resource ntriple;
    private IRI testDir;
    private Act noop = new Act(){

        public void act(Resource r) {
        }
    };
    private Act semTest = new Act(){

        public void act(Resource r) {
            if (WGTestSuite.doSemanticTests()) {
                // empty if block
            }
        }
    };
    TestInputStreamFactory factory;
    private static Collection misc;
    private Map behaviours = new HashMap();
    String createMe;
    private Map parts;
    static final String[] errorLevelName;
    private WGReasonerTester wgReasoner;

    private static void initResults() {
        logging = true;
        testResults = ModelFactory.createDefaultModel();
        jena2 = testResults.createResource(BASE_RESULTS_URI + "#jena2");
        jena2.addProperty(RDFS.comment, testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> is a Semantic Web framework in Java available from <a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://www.sourceforce.net/projects/jena\">sourceforge</a> CVS.", true));
        jena2.addProperty(RDFS.label, "Jena2");
        testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    static void logResult(Resource test, int type) {
    }

    private static boolean doSemanticTests() {
        return ARPTests.internet;
    }

    Model loadRDF(InFactoryX in, RDFErrorHandler eh, String base) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        JenaReader jr = new JenaReader();
        if (eh != null) {
            jr.setErrorHandler(eh);
        }
        jr.setProperty("error-mode", "strict");
        if (base.indexOf("/xmlns/") != -1 || base.indexOf("/comments/") != -1) {
            jr.setProperty("embedding", "true");
        }
        InputStream inx = in.open();
        jr.read(model, inx, base);
        inx.close();
        return model;
    }

    static Model loadNT(InputStream in, String base) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        model.read(in, base, "N-TRIPLE");
        in.close();
        return model;
    }

    private Model loadRDF(final TestInputStreamFactory fact, final String file) {
        Model m;
        block5: {
            m = null;
            String base = fact.getBase().toString();
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            try {
                InputStream in = fact.fullyOpen(file);
                if (in == null) {
                    return null;
                }
                in.close();
                m = this.loadRDF(new InFactoryX(){

                    public InputStream open() throws IOException {
                        return fact.fullyOpen(file);
                    }
                }, null, base + file);
            }
            catch (JenaException e2) {
                throw e2;
            }
            catch (Exception e3) {
                if (!file.equals("Manifest.rdf")) break block5;
                System.err.println("Failed to open Manifest.rdf");
                e3.printStackTrace();
            }
        }
        return m;
    }

    WGTestSuite(TestInputStreamFactory fact, String name, boolean dynamic) {
        super(name);
        this.behaviours.put(new ResourceImpl(testNS + "PositiveParserTest"), new Act(){

            public void act(Resource r) {
                if (r.hasProperty(warning)) {
                    WGTestSuite.this.addTest(r, new WarningTest(r));
                } else {
                    WGTestSuite.this.addTest(r, new PositiveTest(r));
                }
            }
        });
        this.behaviours.put(new ResourceImpl(testNS + "NegativeParserTest"), new Act(){

            public void act(Resource r) {
                WGTestSuite.this.addTest(r, new NegativeTest(r));
            }
        });
        this.behaviours.put(new ResourceImpl(testNS + "False-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "RDF-XML-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "NT-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "PositiveEntailmentTest"), this.semTest);
        this.behaviours.put(new ResourceImpl(testNS + "NegativeEntailmentTest"), this.semTest);
        this.behaviours.put(new ResourceImpl(testNS + "MiscellaneousTest"), new Act(){

            public void act(Resource r) {
                String uri = r.getURI();
                if (!misc.contains(uri)) {
                    System.err.println("MiscellaneousTest: " + uri + " - ignored!");
                }
            }
        });
        this.parts = new HashMap();
        this.factory = fact;
        this.testDir = fact.getBase();
        if (dynamic) {
            try {
                System.err.println(this.testDir + ", " + fact.getMapBase());
                this.wgReasoner = new WGReasonerTester("Manifest.rdf", "testing/wg/");
                this.createMe = "new " + this.getClass().getName() + "(" + fact.getCreationJava() + ", \"" + name + "\", false )";
                Model m = this.loadRDF(fact, "Manifest.rdf");
                Model extra = this.loadRDF(fact, "Manifest-extra.rdf");
                Model wrong = this.loadRDF(fact, "Manifest-wrong.rdf");
                if (extra != null) {
                    m = m.add(extra);
                }
                if (wrong != null) {
                    m = m.difference(wrong);
                }
                StmtIterator si = m.listStatements(null, RDF.type, (RDFNode)null);
                while (si.hasNext()) {
                    Statement st = si.nextStatement();
                    Act action = (Act)this.behaviours.get(st.getObject());
                    if (action == null) {
                        System.err.println("Unknown test class: " + ((Resource)st.getObject()).getURI());
                        continue;
                    }
                    action.act(st.getSubject());
                }
                if (ARPTests.internet) {
                    WGTestSuite.initResults();
                    this.addTest(new DummyTest());
                }
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                throw re;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new JenaException(e2);
            }
        }
    }

    static TestSuite suite(IRI testDir, String d, String nm) {
        return new WGTestSuite(new TestInputStreamFactory(testDir, d), nm, true);
    }

    static TestSuite suite(IRI testDir, IRI d, String nm) {
        return new WGTestSuite(new TestInputStreamFactory(testDir, d), nm, true);
    }

    private void addTest(Resource key, TestCase test) {
        String keyName = key.hasProperty(status) ? key.getRequiredProperty(status).getString() : "no status";
        TestSuite sub = (TestSuite)this.parts.get(keyName);
        if (sub == null) {
            if (keyName.equals("OBSOLETED")) {
                return;
            }
            if (keyName.equals("OBSOLETE")) {
                return;
            }
            if (keyName.equals("NOT_APPROVED")) {
                return;
            }
            sub = new TestSuite();
            sub.setName(keyName);
            this.parts.put(keyName, sub);
            this.addTest(sub);
        }
        sub.addTest(test);
    }

    TestCase createPositiveTest(String uri, String in, boolean intype, String out, boolean outtype) {
        return new PositiveTest2(uri, in, intype, out, outtype);
    }

    TestCase createWarningTest(String uri, String in, boolean intype, String out, boolean outtype, int[] e2) {
        return new WarningTest2(uri, in, intype, out, outtype, e2);
    }

    TestCase createNegativeTest(String uri, String in, boolean intype, int[] e2) {
        return new NegativeTest2(uri, in, intype, e2);
    }

    static {
        logging = false;
        BASE_RESULTS_URI = "http://jena.sourceforge.net/data/rdf-results.rdf";
        checkMessages = false;
        inDevelopment = false;
        testNS = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
        jjcNS = "http://jcarroll.hpl.hp.com/testSchema#";
        status = new PropertyImpl(testNS, "status");
        input = new PropertyImpl(testNS, "inputDocument");
        output = new PropertyImpl(testNS, "outputDocument");
        warning = new PropertyImpl(testNS, "warning");
        errorCodes = new PropertyImpl(jjcNS, "error");
        rdfxml = new ResourceImpl(testNS, "RDF-XML-Document");
        ntriple = new ResourceImpl(testNS, "NT-Document");
        misc = Arrays.asList("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdfms-uri-substructure/error001");
        errorLevelName = new String[]{"warning", "error", "fatal error"};
    }

    class NegativeTest2
    extends Test2 {
        Model m1;
        Set expected;
        int expectedLevel;
        String in;
        boolean intype;
        private Set found;
        private int[] errorCnt;

        NegativeTest2(String uri, String in, boolean intype, int[] errs) {
            super(uri);
            this.expectedLevel = 1;
            this.found = new HashSet();
            this.errorCnt = new int[]{0, 0, 0};
            this.in = in;
            this.intype = intype;
            this.initExpected(errs);
        }

        void initExpected(int[] errs) {
            if (errs == null) {
                return;
            }
            if (errs.length != 0) {
                this.expected = new HashSet();
            }
            for (int i = 0; i < errs.length; ++i) {
                this.expected.add(new Integer(errs[i]));
            }
        }

        protected void runTest() {
            int j;
            HashSet ex2;
            try {
                this.m1 = this.read(this.in, this.intype);
            }
            catch (JenaException re) {
                if (!(re.getCause() instanceof SAXException)) {
                    NegativeTest2.fail(re.getMessage());
                }
            }
            catch (IOException ioe) {
                NegativeTest2.fail(ioe.getMessage());
            }
            HashSet hashSet = ex2 = this.expected == null ? null : new HashSet(this.expected);
            if (this.expected == null) {
                for (j = 2; j >= 0; --j) {
                    if (j == this.expectedLevel || this.errorCnt[j] == 0) continue;
                    ex2 = new HashSet();
                }
            }
            if (ex2 != null && !ex2.equals(this.found)) {
                HashSet dup = new HashSet();
                dup.addAll(this.found);
                dup.removeAll(ex2);
                ex2.removeAll(this.found);
                if (this.expected != null) {
                    this.expected.removeAll(this.found);
                }
                Iterator it = ex2.iterator();
                while (it.hasNext()) {
                    int eCode = (Integer)it.next();
                    String msg = "Expected error  " + ParseException.errorCodeName(eCode) + ", was not detected.";
                    if (this.errorCnt[2] == 0) {
                        NegativeTest2.fail(msg);
                        continue;
                    }
                    System.err.println("Test: " + this.getName());
                    System.err.println(msg);
                }
                it = dup.iterator();
                while (it.hasNext()) {
                    NegativeTest2.fail("Detected error  " + ParseException.errorCodeName((Integer)it.next()) + ", was not expected.");
                }
            }
            for (j = 2; j >= 0; --j) {
                if (j == this.expectedLevel) {
                    if (this.errorCnt[j] != 0 || j == 1 && this.errorCnt[2] != 0) continue;
                    NegativeTest2.fail("No " + errorLevelName[this.expectedLevel] + " in input file of class " + this.getClass().getName());
                    continue;
                }
                if (this.expected != null || this.errorCnt[j] == 0) continue;
                NegativeTest2.fail("Inappropriate " + errorLevelName[j] + " in input file of class " + this.getClass().getName());
            }
        }

        void onError(int level, int id) {
            Integer err = new Integer(id);
            this.found.add(err);
            int n = level;
            this.errorCnt[n] = this.errorCnt[n] + 1;
            if (this.expected != null && !this.expected.contains(err)) {
                super.onError(level, id);
            }
        }
    }

    class WarningTest2
    extends PositiveTest2 {
        WarningTest2(String uri, String in, boolean intype, String out, boolean outtype, int[] errs) {
            super(uri, in, intype, out, outtype, errs);
            this.expectedLevel = 0;
        }
    }

    class PositiveTest2
    extends NegativeTest2 {
        String out;
        boolean outtype;

        PositiveTest2(String uri, String in, boolean intype, String out, boolean outtype) {
            this(uri, in, intype, out, outtype, new int[0]);
        }

        PositiveTest2(String uri, String in, boolean intype, String out, boolean outtype, int[] errs) {
            super(uri, in, intype, errs);
            this.expectedLevel = -1;
            this.out = out;
            this.outtype = outtype;
        }

        protected void runTest() {
            try {
                Model m2 = this.read(this.out, this.outtype);
                super.runTest();
                if (!this.m1.isIsomorphicWith(m2)) {
                    System.err.println("=====");
                    this.m1.write(System.err, "N-TRIPLE");
                    System.err.println("=====");
                    m2.write(System.err, "N-TRIPLE");
                    System.err.println("=====");
                    PositiveTest2.fail("Models were not equal.");
                }
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                PositiveTest2.fail(e3.getMessage());
            }
        }

        void initExpected() {
            this.expected = new HashSet();
        }
    }

    class Test2
    extends TestCase
    implements RDFErrorHandler {
        Test2(String r) {
            super(WGTestSuite.this.testDir.relativize(r, 8).toString());
        }

        Model read(String file, boolean type) throws IOException {
            if (!type) {
                return WGTestSuite.loadNT(WGTestSuite.this.factory.open(file), file);
            }
            final String uri = file;
            return WGTestSuite.this.loadRDF(new InFactoryX(){

                public InputStream open() throws IOException {
                    return ((Test2)Test2.this).WGTestSuite.this.factory.open(uri);
                }
            }, this, uri);
        }

        public void warning(Exception e2) {
            this.error(0, e2);
        }

        public void error(Exception e2) {
            this.error(1, e2);
        }

        public void fatalError(Exception e2) {
            this.error(2, e2);
        }

        private void error(int level, Exception e2) {
            if (e2 instanceof ParseException) {
                String msg;
                int eCode = ((ParseException)e2).getErrorNumber();
                if (eCode == 201 && ((msg = e2.getMessage()).indexOf("Unusual") != -1 || msg.indexOf("Internal") != -1)) {
                    System.err.println(this.getName());
                    System.err.println(msg);
                    Test2.fail(msg);
                }
                this.onError(level, eCode);
            } else if (e2 instanceof SAXException) {
                Test2.fail("Not expecting a SAXException: " + e2.getMessage());
            } else {
                Test2.fail("Not expecting an Exception: " + e2.getMessage());
            }
        }

        private void println(String m) {
            System.err.println(m);
        }

        void onError(int level, int num) {
            String msg = "Parser reports unexpected " + errorLevelName[level] + ": " + ParseException.errorCodeName(num);
            this.println(msg);
            Test2.fail(msg);
        }
    }

    class NegativeTest
    extends Test {
        Model m1;
        Set expected;
        int expectedLevel;
        private Set found;
        private int[] errorCnt;

        String createExpected() {
            String rslt = "new int[]{";
            if (this.expected == null) {
                return "null";
            }
            Iterator it = this.expected.iterator();
            while (it.hasNext()) {
                rslt = rslt + it.next() + ", ";
            }
            return rslt + "}";
        }

        String createMe() {
            return this.createURI() + "," + this.create(input) + "," + this.createExpected();
        }

        NegativeTest(Resource nm) {
            super(nm);
            this.expectedLevel = 1;
            this.found = new HashSet();
            this.errorCnt = new int[]{0, 0, 0};
            this.initExpected();
        }

        void save(Property p) {
            if (WGTestSuite.this.factory.savable()) {
                String uri = this.testID.getRequiredProperty(p).getResource().getURI();
                int suffix = uri.lastIndexOf(46);
                String saveUri = uri.substring(0, suffix) + ".ntx";
                try {
                    OutputStream w = WGTestSuite.this.factory.openOutput(saveUri);
                    this.m1.write(w, "N-TRIPLE");
                    w.close();
                }
                catch (IOException e2) {
                    throw new JenaException(e2);
                }
            }
        }

        void initExpectedFromModel() {
            StmtIterator si = this.testID.listProperties(errorCodes);
            if (si.hasNext()) {
                this.expected = new HashSet();
                while (si.hasNext()) {
                    String uri = si.nextStatement().getResource().getURI();
                    String fieldName = uri.substring(uri.lastIndexOf(35) + 1);
                    this.expected.add(new Integer(ParseException.errorCode(fieldName)));
                }
            }
        }

        void initExpected() {
            this.initExpectedFromModel();
        }

        protected void reallyRunTest() {
            try {
                this.m1 = this.read(input);
                if (this.expectedLevel == 1 && this.expected == null && this.errorCnt[2] == 0 && this.errorCnt[1] == 0) {
                    this.save(input);
                }
            }
            catch (JenaException re) {
                if (!(re.getCause() instanceof SAXException)) {
                    NegativeTest.fail(re.getMessage());
                }
            }
            catch (IOException ioe) {
                NegativeTest.fail(ioe.getMessage());
            }
            if (this.expected != null && !((Object)this.expected).equals(this.found)) {
                HashSet dup = new HashSet();
                dup.addAll(this.found);
                dup.removeAll(this.expected);
                this.expected.removeAll(this.found);
                Iterator it = this.expected.iterator();
                while (it.hasNext()) {
                    int eCode = (Integer)it.next();
                    String msg = "Expected error  " + ParseException.errorCodeName(eCode) + ", was not detected.";
                    if (this.errorCnt[2] == 0) {
                        NegativeTest.fail(msg);
                        continue;
                    }
                    if (eCode == 201 && this.getName().startsWith("rdf-nnn/67_") && "1234".indexOf(this.getName().charAt("rdf-nnn/67_".length())) != -1) continue;
                    System.err.println("Test: " + this.getName());
                    System.err.println(msg);
                }
                it = dup.iterator();
                while (it.hasNext()) {
                    NegativeTest.fail("Detected error  " + ParseException.errorCodeName((Integer)it.next()) + ", was not expected.");
                }
            }
            for (int j = 2; j >= 0; --j) {
                if (j == this.expectedLevel) {
                    if (this.errorCnt[j] != 0 || j == 1 && this.errorCnt[2] != 0) continue;
                    NegativeTest.fail("No " + errorLevelName[this.expectedLevel] + " in input file of class " + this.getClass().getName());
                    continue;
                }
                if (this.expected != null || this.errorCnt[j] == 0) continue;
                NegativeTest.fail("Inappropriate " + errorLevelName[j] + " in input file of class " + this.getClass().getName());
            }
        }

        void onError(int level, int id) {
            Integer err = new Integer(id);
            this.found.add(err);
            int n = level;
            this.errorCnt[n] = this.errorCnt[n] + 1;
            if (this.expected != null) {
                if (!this.expected.contains(err)) {
                    super.onError(level, id);
                }
            } else if (inDevelopment) {
                System.err.println("<rdf:Description rdf:about='" + this.testID.getURI() + "'>\n" + "<jjc:error rdf:resource='" + jjcNS + ParseException.errorCodeName(id) + "'/>\n</rdf:Description>");
            }
        }
    }

    class WarningTest
    extends PositiveTest {
        String createMe() {
            return this.createURI() + "," + this.create(input) + "," + this.create(output) + "," + this.createExpected();
        }

        WarningTest(Resource nm) {
            super(nm);
            this.expectedLevel = 0;
        }

        void initExpected() {
            this.initExpectedFromModel();
        }
    }

    class PositiveTest
    extends NegativeTest {
        String createMe() {
            return this.createURI() + "," + this.create(input) + "," + this.create(output);
        }

        PositiveTest(Resource nm) {
            super(nm);
            this.expectedLevel = -1;
        }

        protected void reallyRunTest() {
            try {
                Model m2 = this.read(output);
                super.reallyRunTest();
                if (!((Object)this.m1).equals(m2)) {
                    this.save(output);
                    PositiveTest.assertTrue(this.m1.isIsomorphicWith(m2));
                }
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                PositiveTest.fail(e3.getMessage());
            }
        }

        void initExpected() {
            this.expected = new HashSet();
        }
    }

    abstract class Test
    extends TestCase
    implements RDFErrorHandler {
        Resource testID;

        String createURI() {
            return "\"" + this.testID.getURI() + "\"";
        }

        abstract String createMe();

        Test(Resource r) {
            super(WGTestSuite.this.testDir.relativize(IRIFactory.iriImplementation().create(r.getURI()), 8).toString());
            this.testID = r;
        }

        String create(Property p) {
            Resource file = this.testID.getRequiredProperty(p).getResource();
            Resource t = file.getRequiredProperty(RDF.type).getResource();
            if (((Object)ntriple).equals(t)) {
                return "\"" + file.getURI() + "\",false";
            }
            if (((Object)rdfxml).equals(t)) {
                return "\"" + file.getURI() + "\",true";
            }
            return "Unrecognized file type: " + t;
        }

        Model read(Property p) throws IOException {
            Resource file = this.testID.getRequiredProperty(p).getResource();
            Resource t = file.getRequiredProperty(RDF.type).getResource();
            final String uri = file.getURI();
            if (((Object)ntriple).equals(t)) {
                return WGTestSuite.loadNT(WGTestSuite.this.factory.open(uri), uri);
            }
            if (((Object)rdfxml).equals(t)) {
                return WGTestSuite.this.loadRDF(new InFactoryX(){

                    public InputStream open() throws IOException {
                        return ((Test)Test.this).WGTestSuite.this.factory.open(uri);
                    }
                }, this, uri);
            }
            Test.fail("Unrecognized file type: " + t);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws IOException {
            int rslt = -1;
            try {
                this.reallyRunTest();
                rslt = 2;
            }
            finally {
                WGTestSuite.logResult(this.testID, rslt);
            }
        }

        abstract void reallyRunTest();

        public void warning(Exception e2) {
            this.error(0, e2);
        }

        public void error(Exception e2) {
            this.error(1, e2);
        }

        public void fatalError(Exception e2) {
            this.error(2, e2);
        }

        private void error(int level, Exception e2) {
            if (e2 instanceof ParseException) {
                int eCode = ((ParseException)e2).getErrorNumber();
                if (eCode == 201) {
                    String msg = e2.getMessage();
                    if (msg.indexOf("Unusual") != -1 || msg.indexOf("Internal") != -1) {
                        System.err.println(this.testID.getURI());
                        System.err.println(msg);
                        Test.fail(msg);
                    }
                    if (checkMessages) {
                        System.err.println(this.testID.getURI());
                        System.err.println(msg);
                    }
                }
                this.onError(level, eCode);
            } else if (e2 instanceof SAXException) {
                Test.fail("Not expecting a SAXException: " + e2.getMessage());
            } else {
                Test.fail("Not expecting an Exception: " + e2.getMessage());
            }
        }

        private void println(String m) {
            System.err.println(m);
        }

        void onError(int level, int num) {
            String msg = "Parser reports unexpected " + errorLevelName[level] + ": " + ParseException.errorCodeName(num);
            this.println(msg);
            Test.fail(msg);
        }
    }

    class ReasoningTest
    extends Test {
        ReasoningTest(Resource r) {
            super(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws IOException {
            int rslt = -1;
            try {
                JenaParameters.enableWhitespaceCheckingOfTypedLiterals = true;
                Resource config = ModelFactory.createDefaultModel().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "full");
                rslt = WGTestSuite.this.wgReasoner.runTestDetailedResponse(this.testID.getURI(), RDFSRuleReasonerFactory.theInstance(), this, config);
            }
            finally {
                WGTestSuite.logResult(this.testID, rslt);
            }
        }

        String createMe() {
            throw new UnsupportedOperationException();
        }

        void reallyRunTest() {
            throw new BrokenException("");
        }
    }

    static interface Act {
        public void act(Resource var1);
    }

    private static class DummyTest
    extends TestCase {
        DummyTest() {
            super("save results");
        }

        public void runTest() throws IOException {
            if (logging) {
                OutputStream out;
                RDFWriter w = testResults.getWriter("RDF/XML-ABBREV");
                w.setProperty("xmlbase", BASE_RESULTS_URI);
                try {
                    out = new FileOutputStream("/tmp/rdf-results.rdf");
                }
                catch (Exception e2) {
                    out = System.out;
                }
                w.write(testResults, out, BASE_RESULTS_URI);
                out.close();
            }
        }
    }
}

