/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ConsoleCommandHandler;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConsoleCommandRequest
implements ConsoleRequest {
    private String command;

    public ConsoleCommandRequest() {
    }

    public ConsoleCommandRequest(String command) {
        this.command = command;
    }

    public int getType() {
        return 5;
    }

    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        ConsoleCommandHandler handler = mcs.getCommandHandler();
        try {
            String output = handler.handleCommand(this.command);
            IOUtil.writeLongString(dos, output);
        }
        catch (Throwable e2) {
            IOUtil.writeLongString(dos, "Error: " + e2.getClass().getSimpleName() + "[" + e2.getMessage() + "]");
        }
    }

    public Object readResponse(DataInput in) throws IOException {
        return IOUtil.readLongString(in);
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.command);
    }

    public void readData(DataInput in) throws IOException {
        this.command = in.readUTF();
    }
}

