/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientBinder;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.Credentials;
import java.io.IOException;
import java.util.logging.Level;

public class DefaultClientBinder
implements ClientBinder {
    private HazelcastClient client;
    private final ILogger logger = Logger.getLogger(this.getClass().getName());

    public DefaultClientBinder(HazelcastClient client) {
        this.client = client;
    }

    public void bind(Connection connection, Credentials credentials) throws IOException {
        this.logger.log(Level.FINEST, connection + " -> " + connection.getAddress().getHostName() + ":" + connection.getSocket().getLocalPort());
        this.auth(connection, credentials);
    }

    void auth(Connection connection, Credentials credentials) throws IOException {
        Packet auth = new Packet();
        auth.set("", ClusterOperation.CLIENT_AUTHENTICATE, new byte[0], IOUtil.toByte(credentials));
        Packet packet = this.writeAndRead(connection, auth);
        Object response = IOUtil.toObject(packet.getValue());
        this.logger.log(Level.FINEST, "auth response:" + response);
        if (response instanceof Exception) {
            throw new RuntimeException((Exception)response);
        }
        if (!Boolean.TRUE.equals(response)) {
            throw new AuthenticationException("Client [" + connection + "] has failed authentication");
        }
    }

    Packet writeAndRead(Connection connection, Packet packet) throws IOException {
        this.write(connection, packet);
        return this.client.getInRunnable().reader.readPacket(connection);
    }

    void write(Connection connection, Packet packet) throws IOException {
        this.client.getOutRunnable().write(connection, packet);
    }
}

