/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.CurrentDateTimeProvider;
import org.springframework.data.auditing.DateTimeProvider;
import org.springframework.data.domain.AuditorAware;
import org.springframework.util.Assert;

public class AuditingHandler<T>
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditingHandler.class);
    private final AuditableBeanWrapperFactory factory = new AuditableBeanWrapperFactory();
    private DateTimeProvider dateTimeProvider = CurrentDateTimeProvider.INSTANCE;
    private AuditorAware<T> auditorAware;
    private boolean dateTimeForNow = true;
    private boolean modifyOnCreation = true;

    public void setAuditorAware(AuditorAware<T> auditorAware) {
        Assert.notNull(auditorAware);
        this.auditorAware = auditorAware;
    }

    public void setDateTimeForNow(boolean dateTimeForNow) {
        this.dateTimeForNow = dateTimeForNow;
    }

    public void setModifyOnCreation(boolean modifyOnCreation) {
        this.modifyOnCreation = modifyOnCreation;
    }

    public void setDateTimeProvider(DateTimeProvider dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider == null ? CurrentDateTimeProvider.INSTANCE : dateTimeProvider;
    }

    public void markCreated(Object source) {
        this.touch(source, true);
    }

    public void markModified(Object source) {
        this.touch(source, false);
    }

    private void touch(Object target, boolean isNew) {
        AuditableBeanWrapper wrapper = this.factory.getBeanWrapperFor(target);
        if (wrapper == null) {
            return;
        }
        T auditor = this.touchAuditor(wrapper, isNew);
        DateTime now2 = this.dateTimeForNow ? this.touchDate(wrapper, isNew) : null;
        Object defaultedNow = now2 == null ? "not set" : now2;
        String defaultedAuditor = auditor == null ? "unknown" : auditor;
        LOGGER.debug("Touched {} - Last modification at {} by {}", target, defaultedNow, defaultedAuditor);
    }

    private T touchAuditor(AuditableBeanWrapper wrapper, boolean isNew) {
        if (null == this.auditorAware) {
            return null;
        }
        T auditor = this.auditorAware.getCurrentAuditor();
        if (isNew) {
            wrapper.setCreatedBy(auditor);
            if (!this.modifyOnCreation) {
                return auditor;
            }
        }
        wrapper.setLastModifiedBy(auditor);
        return auditor;
    }

    private DateTime touchDate(AuditableBeanWrapper wrapper, boolean isNew) {
        DateTime now2 = this.dateTimeProvider.getDateTime();
        if (isNew) {
            wrapper.setCreatedDate(now2);
            if (!this.modifyOnCreation) {
                return now2;
            }
        }
        wrapper.setLastModifiedDate(now2);
        return now2;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.auditorAware == null) {
            LOGGER.debug("No AuditorAware set! Auditing will not be applied!");
        }
    }
}

