/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.controller;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.service.cn.replication.auditor.v1.controller.AbstractReplicationAuditor;
import org.dataone.service.cn.replication.auditor.v1.task.MemberNodeReplicaAuditTask;
import org.dataone.service.types.v1.Identifier;

public class ManualMemberNodeReplicaAuditor
extends AbstractReplicationAuditor {
    private static final int pageSize = 100;
    private static final int pidsPerTaskSize = 10;
    private static final int taskPoolSize = 5;
    private static final int maxPages = 100000;
    private static final long executionWaitSeconds = 60L;
    private static final String MANUAL_AUDIT_LOCK_NAME = "manualMemberNodeReplicationAuditLock";
    private Date auditDate = null;

    public ManualMemberNodeReplicaAuditor(Date auditDate) {
        this.auditDate = auditDate;
    }

    @Override
    protected Date calculateAuditDate() {
        return this.auditDate;
    }

    @Override
    protected List<Identifier> getPidsToAudit(Date auditDate, int pageNumber, int pageSize) throws DataAccessException {
        return this.replicationDao.getCompletedMemberNodeReplicasByDate(auditDate, pageNumber, pageSize);
    }

    @Override
    protected Callable<String> newAuditTask(List<Identifier> pids, Date auditDate) {
        return new MemberNodeReplicaAuditTask(pids, auditDate);
    }

    @Override
    protected boolean tryLock(Lock lock) {
        return true;
    }

    @Override
    protected void releaseLock(Lock lock) {
    }

    @Override
    protected Lock getProcessingLock() {
        return null;
    }

    @Override
    protected String getLockName() {
        return MANUAL_AUDIT_LOCK_NAME;
    }

    @Override
    protected int getMaxPages() {
        return 100000;
    }

    @Override
    protected int getTaskPoolSize() {
        return 5;
    }

    @Override
    protected int getPageSize() {
        return 100;
    }

    @Override
    protected int getPidsPerTaskSize() {
        return 10;
    }

    @Override
    protected boolean shouldRunAudit() {
        return true;
    }

    @Override
    protected long getFutureExecutionWaitTimeSeconds() {
        return 60L;
    }
}

