/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.cn.replication.auditor.v1.controller.CoordinatingNodeReplicationAuditor;
import org.dataone.service.cn.replication.auditor.v1.controller.InvalidMemberNodeReplicationAuditor;
import org.dataone.service.cn.replication.auditor.v1.controller.MemberNodeReplicationAuditor;

public class ScheduledReplicationAuditController {
    private static Log logger = LogFactory.getLog(ScheduledReplicationAuditController.class.getName());
    private static ScheduledExecutorService staleRequestedReplicaAuditScheduler;
    private static ScheduledExecutorService staleQueuedReplicaAuditScheduler;
    private static ScheduledExecutorService mnReplicaAuditScheduler;
    private static ScheduledExecutorService invalidMnReplicaAuditScheduler;
    private static ScheduledExecutorService cnReplicaAuditScheduler;

    public void startup() {
        logger.info("starting scheduled replication auditing...");
        this.startMnReplicaAuditing();
        this.startCnReplicaAuditing();
        logger.info("scheduled replication auditing started.");
    }

    public void shutdown() {
        logger.info("stopping scheduled replication auditing....");
        if (staleRequestedReplicaAuditScheduler != null) {
            staleRequestedReplicaAuditScheduler.shutdown();
        }
        if (staleQueuedReplicaAuditScheduler != null) {
            staleQueuedReplicaAuditScheduler.shutdown();
        }
        if (mnReplicaAuditScheduler != null) {
            mnReplicaAuditScheduler.shutdown();
        }
        if (invalidMnReplicaAuditScheduler != null) {
            invalidMnReplicaAuditScheduler.shutdown();
        }
        if (cnReplicaAuditScheduler != null) {
            cnReplicaAuditScheduler.shutdown();
        }
        logger.info("scheduled replication auditing stopped.");
    }

    private void startMnReplicaAuditing() {
        if (mnReplicaAuditScheduler == null || mnReplicaAuditScheduler.isShutdown()) {
            mnReplicaAuditScheduler = Executors.newSingleThreadScheduledExecutor();
            mnReplicaAuditScheduler.scheduleAtFixedRate(new MemberNodeReplicationAuditor(), 0L, 1L, TimeUnit.HOURS);
        }
        if (invalidMnReplicaAuditScheduler == null || invalidMnReplicaAuditScheduler.isShutdown()) {
            invalidMnReplicaAuditScheduler = Executors.newSingleThreadScheduledExecutor();
            invalidMnReplicaAuditScheduler.scheduleAtFixedRate(new InvalidMemberNodeReplicationAuditor(), 0L, 1L, TimeUnit.HOURS);
        }
    }

    private void startCnReplicaAuditing() {
        if (cnReplicaAuditScheduler == null || cnReplicaAuditScheduler.isShutdown()) {
            cnReplicaAuditScheduler = Executors.newSingleThreadScheduledExecutor();
            cnReplicaAuditScheduler.scheduleAtFixedRate(new CoordinatingNodeReplicationAuditor(), 0L, 1L, TimeUnit.HOURS);
        }
    }
}

