/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;

public abstract class StreamBlockCipher
implements BlockCipher,
StreamCipher {
    private final BlockCipher cipher;

    protected StreamBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public final byte returnByte(byte by) {
        return this.calculateByte(by);
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n4) throws DataLengthException {
        if (n4 + n2 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        int n5 = n;
        int n6 = n + n2;
        int n7 = n4;
        while (n5 < n6) {
            byArray2[n7++] = this.calculateByte(byArray[n5++]);
        }
        return n2;
    }

    protected abstract byte calculateByte(byte var1);
}

