/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.MultiComp;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;

public class StreamFactory
implements Serializable {
    private transient HashMap<String, String> collectionZkHosts = new HashMap();
    private transient HashMap<String, Class> streamFunctions = new HashMap();

    public StreamFactory withCollectionZkHost(String collectionName, String zkHost) {
        this.collectionZkHosts.put(collectionName, zkHost);
        return this;
    }

    public String getCollectionZkHost(String collectionName) {
        if (this.collectionZkHosts.containsKey(collectionName)) {
            return this.collectionZkHosts.get(collectionName);
        }
        return null;
    }

    public Map<String, Class> getStreamFunctions() {
        return this.streamFunctions;
    }

    public StreamFactory withStreamFunction(String streamFunction, Class clazz) {
        this.streamFunctions.put(streamFunction, clazz);
        return this;
    }

    public StreamExpressionParameter getOperand(StreamExpression expression, int parameterIndex) {
        if (null == expression.getParameters() || parameterIndex >= expression.getParameters().size()) {
            return null;
        }
        return expression.getParameters().get(parameterIndex);
    }

    public String getValueOperand(StreamExpression expression, int parameterIndex) {
        StreamExpressionParameter parameter = this.getOperand(expression, parameterIndex);
        if (null != parameter && parameter instanceof StreamExpressionValue) {
            return ((StreamExpressionValue)parameter).getValue();
        }
        return null;
    }

    public List<StreamExpressionNamedParameter> getNamedOperands(StreamExpression expression) {
        ArrayList<StreamExpressionNamedParameter> namedParameters = new ArrayList<StreamExpressionNamedParameter>();
        for (StreamExpressionParameter parameter : this.getOperandsOfType(expression, StreamExpressionNamedParameter.class)) {
            namedParameters.add((StreamExpressionNamedParameter)parameter);
        }
        return namedParameters;
    }

    public StreamExpressionNamedParameter getNamedOperand(StreamExpression expression, String name) {
        List<StreamExpressionNamedParameter> namedParameters = this.getNamedOperands(expression);
        for (StreamExpressionNamedParameter param : namedParameters) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public List<StreamExpression> getExpressionOperands(StreamExpression expression) {
        ArrayList<StreamExpression> namedParameters = new ArrayList<StreamExpression>();
        for (StreamExpressionParameter parameter : this.getOperandsOfType(expression, StreamExpression.class)) {
            namedParameters.add((StreamExpression)parameter);
        }
        return namedParameters;
    }

    public List<StreamExpression> getExpressionOperands(StreamExpression expression, String functionName) {
        ArrayList<StreamExpression> namedParameters = new ArrayList<StreamExpression>();
        for (StreamExpressionParameter parameter : this.getOperandsOfType(expression, StreamExpression.class)) {
            StreamExpression expressionOperand = (StreamExpression)parameter;
            if (!expressionOperand.getFunctionName().equals(functionName)) continue;
            namedParameters.add(expressionOperand);
        }
        return namedParameters;
    }

    public List<StreamExpressionParameter> getOperandsOfType(StreamExpression expression, Class ... clazzes) {
        ArrayList<StreamExpressionParameter> parameters = new ArrayList<StreamExpressionParameter>();
        block0: for (StreamExpressionParameter parameter : expression.getParameters()) {
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom(parameter.getClass())) continue block0;
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    public List<StreamExpression> getExpressionOperandsRepresentingTypes(StreamExpression expression, Class ... clazzes) {
        ArrayList<StreamExpression> matchingStreamExpressions = new ArrayList<StreamExpression>();
        List<StreamExpression> allStreamExpressions = this.getExpressionOperands(expression);
        block0: for (StreamExpression streamExpression : allStreamExpressions) {
            if (!this.streamFunctions.containsKey(streamExpression.getFunctionName())) continue;
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom(this.streamFunctions.get(streamExpression.getFunctionName()))) continue block0;
            }
            matchingStreamExpressions.add(streamExpression);
        }
        return matchingStreamExpressions;
    }

    public TupleStream constructStream(String expressionClause) throws IOException {
        return this.constructStream(StreamExpressionParser.parse(expressionClause));
    }

    public TupleStream constructStream(StreamExpression expression) throws IOException {
        Class clazz;
        String function = expression.getFunctionName();
        if (this.streamFunctions.containsKey(function) && ExpressibleStream.class.isAssignableFrom(clazz = this.streamFunctions.get(function)) && TupleStream.class.isAssignableFrom(clazz)) {
            TupleStream stream = (TupleStream)this.createInstance(this.streamFunctions.get(function), new Class[]{StreamExpression.class, StreamFactory.class}, new Object[]{expression, this});
            return stream;
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid stream expression %s - function '%s' is unknown (not mapped to a valid TupleStream)", expression, expression.getFunctionName()));
    }

    public Comparator<Tuple> constructComparator(String comparatorString, Class comparatorType) throws IOException {
        if (comparatorString.contains(",")) {
            String[] parts = comparatorString.split(",");
            Comparator[] comps = new Comparator[parts.length];
            for (int idx = 0; idx < parts.length; ++idx) {
                comps[idx] = this.constructComparator(parts[idx].trim(), comparatorType);
            }
            return new MultiComp(comps);
        }
        String[] parts = comparatorString.split(" ");
        if (2 != parts.length) {
            throw new IOException(String.format(Locale.ROOT, "Invalid comparator expression %s - expecting fieldName and order", comparatorString));
        }
        String fieldName = parts[0].trim();
        String order = parts[1].trim();
        return (Comparator)this.createInstance(comparatorType, new Class[]{String.class, ComparatorOrder.class}, new Object[]{fieldName, ComparatorOrder.fromString(order)});
    }

    public <T> T createInstance(Class<T> clazz, Class<?>[] paramTypes, Object[] params) throws IOException {
        try {
            Constructor<T> ctor = clazz.getConstructor(paramTypes);
            return ctor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
            throw new IOException(String.format(Locale.ROOT, "Unable to construct instance of %s", clazz.getName()), e2);
        }
    }

    public String getFunctionName(Class clazz) throws IOException {
        for (Map.Entry<String, Class> entry : this.streamFunctions.entrySet()) {
            if (entry.getValue() != clazz) continue;
            return entry.getKey();
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to find function name for class '%s'", clazz.getName()));
    }
}

