/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    public static final int FORMAT = 0;
    public static final int STANDALONE = 1;
    public static final int DT_CONTEXT_COUNT = 2;
    public static final int ABBREVIATED = 0;
    public static final int WIDE = 1;
    public static final int NARROW = 2;
    public static final int DT_WIDTH_COUNT = 3;
    String[] eras = null;
    String[] eraNames = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] narrowMonths = null;
    String[] standaloneMonths = null;
    String[] standaloneShortMonths = null;
    String[] standaloneNarrowMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] narrowWeekdays = null;
    String[] standaloneWeekdays = null;
    String[] standaloneShortWeekdays = null;
    String[] standaloneNarrowWeekdays = null;
    String[] ampms = null;
    private String[][] zoneStrings = null;
    static final String patternChars = "GyMdkHmsSEDFwWahKzYeugAZvcL";
    String localPatternChars = null;
    private static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private ArrayList zoneStringsKeyList;
    private HashMap zoneStringsHash;
    private ULocale requestedLocale;
    private static final String SHORT_GENERIC = "sg";
    private static final String SHORT_STANDARD = "ss";
    private static final String SHORT_DAYLIGHT = "sd";
    private static final String LONG_GENERIC = "lg";
    private static final String LONG_STANDARD = "ls";
    private static final String LONG_DAYLIGHT = "ld";
    private static final String EXEMPLAR_CITY = "ec";
    static final int TIMEZONE_SHORT_GENERIC = 0;
    static final int TIMEZONE_SHORT_STANDARD = 1;
    static final int TIMEZONE_SHORT_DAYLIGHT = 2;
    static final int TIMEZONE_LONG_GENERIC = 3;
    static final int TIMEZONE_LONG_STANDARD = 4;
    static final int TIMEZONE_LONG_DAYLIGHT = 5;
    static final int TIMEZONE_EXEMPLAR_CITY = 6;
    static final int TIMEZONE_COUNT = 7;
    private ULocale validLocale;
    private ULocale actualLocale;
    static /* synthetic */ Class class$com$ibm$icu$util$GregorianCalendar;

    public DateFormatSymbols() {
        this.initializeData(ULocale.getDefault(), "");
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(ULocale.forLocale(locale), "");
    }

    public DateFormatSymbols(ULocale locale) {
        this.initializeData(locale, "");
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    public String[] getEraNames() {
        return this.duplicate(this.eraNames);
    }

    public void setEraNames(String[] newEraNames) {
        this.eraNames = this.duplicate(newEraNames);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public String[] getMonths(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.months;
                        break;
                    }
                    case 0: {
                        returnValue = this.shortMonths;
                        break;
                    }
                    case 2: {
                        returnValue = this.narrowMonths;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneMonths;
                        break block0;
                    }
                    case 0: {
                        returnValue = this.standaloneShortMonths;
                        break block0;
                    }
                    case 2: {
                        returnValue = this.standaloneNarrowMonths;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    public void setMonths(String[] newMonths, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.months = this.duplicate(newMonths);
                        break;
                    }
                    case 0: {
                        this.shortMonths = this.duplicate(newMonths);
                        break;
                    }
                    case 2: {
                        this.narrowMonths = this.duplicate(newMonths);
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 2: {
                        this.standaloneNarrowMonths = this.duplicate(newMonths);
                    }
                }
            }
        }
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public String[] getWeekdays(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.weekdays;
                        break;
                    }
                    case 0: {
                        returnValue = this.shortWeekdays;
                        break;
                    }
                    case 2: {
                        returnValue = this.narrowWeekdays;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneWeekdays;
                        break block0;
                    }
                    case 0: {
                        returnValue = this.standaloneShortWeekdays;
                        break block0;
                    }
                    case 2: {
                        returnValue = this.standaloneNarrowWeekdays;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setWeekdays(String[] newWeekdays, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.weekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 0: {
                        this.shortWeekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 2: {
                        this.narrowWeekdays = this.duplicate(newWeekdays);
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 2: {
                        this.standaloneNarrowWeekdays = this.duplicate(newWeekdays);
                    }
                }
            }
        }
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = this.duplicate(newShortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    public String[][] getZoneStrings() {
        if (this.zoneStrings == null) {
            this.initZoneStrings();
        }
        return this.duplicate(this.zoneStrings);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        this.zoneStrings = this.duplicate(newZoneStrings);
        if (this.zoneStringsHash == null) {
            this.zoneStringsHash = new HashMap();
        }
        this.initZoneStrings(newZoneStrings);
        this.zoneStrings = null;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars;
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode ^= this.requestedLocale.toString().hashCode();
        if (this.zoneStringsHash != null) {
            Iterator iter = this.zoneStringsHash.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String[] strings = (String[])this.zoneStringsHash.get(key);
                hashcode ^= key.hashCode();
                for (int i = 0; i < strings.length; ++i) {
                    if (strings[i] == null) continue;
                    hashcode ^= strings[i].hashCode();
                }
            }
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Utility.arrayEquals(this.eras, (Object)that.eras) && Utility.arrayEquals(this.eraNames, (Object)that.eraNames) && Utility.arrayEquals(this.months, (Object)that.months) && Utility.arrayEquals(this.shortMonths, (Object)that.shortMonths) && Utility.arrayEquals(this.narrowMonths, (Object)that.narrowMonths) && Utility.arrayEquals(this.standaloneMonths, (Object)that.standaloneMonths) && Utility.arrayEquals(this.standaloneShortMonths, (Object)that.standaloneShortMonths) && Utility.arrayEquals(this.standaloneNarrowMonths, (Object)that.standaloneNarrowMonths) && Utility.arrayEquals(this.weekdays, (Object)that.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)that.shortWeekdays) && Utility.arrayEquals(this.narrowWeekdays, (Object)that.narrowWeekdays) && Utility.arrayEquals(this.standaloneWeekdays, (Object)that.standaloneWeekdays) && Utility.arrayEquals(this.standaloneShortWeekdays, (Object)that.standaloneShortWeekdays) && Utility.arrayEquals(this.standaloneNarrowWeekdays, (Object)that.standaloneNarrowWeekdays) && Utility.arrayEquals(this.ampms, (Object)that.ampms) && DateFormatSymbols.hashEquals(this.zoneStringsHash, that.zoneStringsHash) && this.requestedLocale.getDisplayName().equals(that.requestedLocale.getDisplayName()) && Utility.arrayEquals(this.localPatternChars, (Object)that.localPatternChars);
    }

    protected void initializeData(ULocale desiredLocale, String type) {
        CalendarData calData = new CalendarData(desiredLocale, type);
        this.initializeData(desiredLocale, calData);
    }

    protected void initializeData(ULocale desiredLocale, CalendarData calData) {
        this.eras = calData.getEras("abbreviated");
        try {
            this.eraNames = calData.getEras("wide");
        }
        catch (MissingResourceException e2) {
            this.eraNames = calData.getEras("abbreviated");
        }
        this.months = calData.getStringArray("monthNames", "wide");
        this.shortMonths = calData.getStringArray("monthNames", "abbreviated");
        try {
            this.narrowMonths = calData.getStringArray("monthNames", "narrow");
        }
        catch (MissingResourceException e3) {
            this.narrowMonths = calData.getStringArray("monthNames", "abbreviated");
        }
        try {
            this.standaloneMonths = calData.getStringArray("monthNames", "stand-alone", "wide");
        }
        catch (MissingResourceException e4) {
            this.standaloneMonths = calData.getStringArray("monthNames", "format", "wide");
        }
        try {
            this.standaloneShortMonths = calData.getStringArray("monthNames", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e5) {
            this.standaloneShortMonths = calData.getStringArray("monthNames", "format", "abbreviated");
        }
        try {
            this.standaloneNarrowMonths = calData.getStringArray("monthNames", "stand-alone", "narrow");
        }
        catch (MissingResourceException e6) {
            try {
                this.standaloneNarrowMonths = calData.getStringArray("monthNames", "format", "narrow");
            }
            catch (MissingResourceException e1) {
                this.standaloneNarrowMonths = calData.getStringArray("monthNames", "format", "abbreviated");
            }
        }
        String[] lWeekdays = calData.getStringArray("dayNames", "wide");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        System.arraycopy(lWeekdays, 0, this.weekdays, 1, lWeekdays.length);
        String[] sWeekdays = calData.getStringArray("dayNames", "abbreviated");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        System.arraycopy(sWeekdays, 0, this.shortWeekdays, 1, sWeekdays.length);
        String[] nWeekdays = null;
        try {
            nWeekdays = calData.getStringArray("dayNames", "narrow");
        }
        catch (MissingResourceException e7) {
            nWeekdays = calData.getStringArray("dayNames", "abbreviated");
        }
        this.narrowWeekdays = new String[8];
        this.narrowWeekdays[0] = "";
        System.arraycopy(nWeekdays, 0, this.narrowWeekdays, 1, nWeekdays.length);
        String[] saWeekdays = null;
        try {
            saWeekdays = calData.getStringArray("dayNames", "stand-alone", "wide");
        }
        catch (MissingResourceException e8) {
            saWeekdays = calData.getStringArray("dayNames", "format", "wide");
        }
        this.standaloneWeekdays = new String[8];
        this.standaloneWeekdays[0] = "";
        System.arraycopy(saWeekdays, 0, this.standaloneWeekdays, 1, saWeekdays.length);
        String[] ssWeekdays = null;
        try {
            ssWeekdays = calData.getStringArray("dayNames", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e9) {
            ssWeekdays = calData.getStringArray("dayNames", "format", "abbreviated");
        }
        this.standaloneShortWeekdays = new String[8];
        this.standaloneShortWeekdays[0] = "";
        System.arraycopy(ssWeekdays, 0, this.standaloneShortWeekdays, 1, ssWeekdays.length);
        String[] snWeekdays = null;
        try {
            snWeekdays = calData.getStringArray("dayNames", "stand-alone", "narrow");
        }
        catch (MissingResourceException e10) {
            try {
                snWeekdays = calData.getStringArray("dayNames", "format", "narrow");
            }
            catch (MissingResourceException e1) {
                snWeekdays = calData.getStringArray("dayNames", "format", "abbreviated");
            }
        }
        this.standaloneNarrowWeekdays = new String[8];
        this.standaloneNarrowWeekdays[0] = "";
        System.arraycopy(snWeekdays, 0, this.standaloneNarrowWeekdays, 1, snWeekdays.length);
        this.ampms = calData.getStringArray("AmPmMarkers");
        this.requestedLocale = desiredLocale;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", desiredLocale);
        this.localPatternChars = rb.getString("localPatternChars");
        ULocale uloc = rb.getULocale();
        this.setLocale(uloc, uloc);
    }

    private static final boolean hashEquals(HashMap h1, HashMap h2) {
        if (h1 == h2) {
            return true;
        }
        if (h1 == null || h2 == null) {
            return false;
        }
        if (h1.size() != h2.size()) {
            return false;
        }
        Iterator i1 = h1.keySet().iterator();
        Iterator i2 = h2.keySet().iterator();
        while (i1.hasNext()) {
            String[] s2;
            String key = (String)i1.next();
            Object[] s1 = (String[])h1.get(key);
            if (Utility.arrayEquals(s1, (Object)(s2 = (String[])h2.get(key)))) continue;
            return false;
        }
        return true;
    }

    private void initZoneStrings() {
        if (this.zoneStringsHash == null) {
            this.initZoneStringsHash();
        }
        this.zoneStrings = new String[this.zoneStringsHash.size()][8];
        int i = 0;
        Iterator it = this.zoneStringsKeyList.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] strings = (String[])this.zoneStringsHash.get(key);
            this.zoneStrings[i][0] = key;
            this.zoneStrings[i][1] = strings[4];
            this.zoneStrings[i][2] = strings[1];
            this.zoneStrings[i][3] = strings[5];
            this.zoneStrings[i][4] = strings[2];
            this.zoneStrings[i][5] = strings[6];
            if (this.zoneStrings[i][5] == null) {
                this.zoneStrings[i][5] = strings[3];
            } else {
                this.zoneStrings[i][6] = strings[3];
            }
            if (this.zoneStrings[i][6] == null) {
                this.zoneStrings[i][6] = strings[0];
            } else {
                this.zoneStrings[i][7] = strings[0];
            }
            ++i;
        }
    }

    private void initZoneStringsHash() {
        this.zoneStringsHash = new HashMap();
        this.zoneStringsKeyList = new ArrayList();
        for (ULocale tempLocale = this.requestedLocale; tempLocale != null; tempLocale = tempLocale.getFallback()) {
            ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", tempLocale);
            ICUResourceBundle zoneStringsBundle = bundle.getWithFallback("zoneStrings");
            for (int i = 0; i < zoneStringsBundle.getSize(); ++i) {
                ICUResourceBundle zoneTable = zoneStringsBundle.get(i);
                String key = Utility.replaceAll(zoneTable.getKey(), ":", "/");
                if (key.length() == 0 || zoneTable.getType() != 2) continue;
                String[] strings = new String[7];
                try {
                    strings[0] = zoneTable.getStringWithFallback(SHORT_GENERIC);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[1] = zoneTable.getStringWithFallback(SHORT_STANDARD);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[2] = zoneTable.getStringWithFallback(SHORT_DAYLIGHT);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[3] = zoneTable.getStringWithFallback(LONG_GENERIC);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[4] = zoneTable.getStringWithFallback(LONG_STANDARD);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[5] = zoneTable.getStringWithFallback(LONG_DAYLIGHT);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                try {
                    strings[6] = zoneTable.getStringWithFallback(EXEMPLAR_CITY);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                if (this.zoneStringsHash.containsKey(key)) continue;
                this.zoneStringsHash.put(key, strings);
                this.zoneStringsKeyList.add(key);
            }
        }
    }

    private void initZoneStrings(String[][] newZoneStrings) {
        if (newZoneStrings == null) {
            return;
        }
        this.zoneStringsKeyList = new ArrayList();
        for (int row = 0; row < newZoneStrings.length; ++row) {
            String key = newZoneStrings[row][0];
            String[] strings = (String[])this.zoneStringsHash.get(key);
            if (strings == null) {
                strings = new String[7];
            }
            int colCount = this.zoneStrings[row].length;
            block10: for (int col = 1; col < colCount; ++col) {
                switch (col) {
                    case 1: {
                        strings[4] = newZoneStrings[row][col];
                        continue block10;
                    }
                    case 2: {
                        strings[1] = newZoneStrings[row][col];
                        continue block10;
                    }
                    case 3: {
                        strings[5] = newZoneStrings[row][col];
                        continue block10;
                    }
                    case 4: {
                        strings[2] = newZoneStrings[row][col];
                        continue block10;
                    }
                    case 5: {
                        if (colCount == 6 || colCount == 8) {
                            strings[6] = newZoneStrings[row][col];
                            continue block10;
                        }
                        strings[3] = newZoneStrings[row][col];
                        continue block10;
                    }
                    case 6: {
                        if (colCount == 8) {
                            strings[3] = newZoneStrings[row][col];
                            continue block10;
                        }
                        strings[0] = newZoneStrings[row][col];
                        continue block10;
                    }
                    case 7: {
                        strings[0] = newZoneStrings[row][col];
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.zoneStringsHash.put(key, strings);
            this.zoneStringsKeyList.add(key);
        }
    }

    Iterator getZoneStringIDs() {
        return this.zoneStringsHash.keySet().iterator();
    }

    String getZoneString(String zid, int type) {
        String[] stringsArray;
        if (this.zoneStringsHash == null) {
            this.initZoneStringsHash();
        }
        if ((stringsArray = (String[])this.zoneStringsHash.get(zid)) != null) {
            return stringsArray[type];
        }
        return null;
    }

    String getZoneID(String zid) {
        String[] strings;
        if (this.zoneStringsHash == null) {
            this.initZoneStringsHash();
        }
        if ((strings = (String[])this.zoneStringsHash.get(zid)) != null) {
            return zid;
        }
        try {
            int n = TimeZone.countEquivalentIDs(zid);
            if (n > 1) {
                for (int i = 0; i < n; ++i) {
                    String equivID = TimeZone.getEquivalentID(zid, i);
                    if (equivID == zid || (strings = (String[])this.zoneStringsHash.get(equivID)) == null) continue;
                    return equivID;
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    ZoneItem getZoneItem(String zid, String text, int start) {
        if (this.zoneStringsHash == null) {
            this.initZoneStringsHash();
        }
        ZoneItem item = new ZoneItem();
        String[] strings = (String[])this.zoneStringsHash.get(zid);
        if (strings != null) {
            for (int j = 0; j < 7; ++j) {
                if (strings[j] == null || !text.regionMatches(true, start, strings[j], 0, strings[j].length())) continue;
                item.type = j;
                item.value = strings[j];
                item.zid = zid;
                return item;
            }
        }
        return null;
    }

    ZoneItem findZoneIDTypeValue(String text, int start) {
        if (this.zoneStringsHash == null) {
            this.initZoneStringsHash();
        }
        ZoneItem item = new ZoneItem();
        Iterator it = this.zoneStringsHash.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] strings = (String[])this.zoneStringsHash.get(key);
            if (strings == null) continue;
            for (int j = 0; j < 7; ++j) {
                if (strings[j] == null || !text.regionMatches(true, start, strings[j], 0, strings[j].length())) continue;
                item.type = j;
                item.value = strings[j];
                item.zid = key;
                return item;
            }
        }
        return null;
    }

    final int getZoneIndex(String ID) {
        int result = this._getZoneIndex(ID);
        if (result >= 0) {
            return result;
        }
        int n = ZoneMeta.countEquivalentIDs(ID);
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                int equivResult;
                String equivID = ZoneMeta.getEquivalentID(ID, i);
                if (equivID.equals(ID) || (equivResult = this._getZoneIndex(equivID)) < 0) continue;
                return equivResult;
            }
        }
        return -1;
    }

    private int _getZoneIndex(String ID) {
        for (int index = 0; index < this.zoneStrings.length; ++index) {
            if (!ID.equalsIgnoreCase(this.zoneStrings[index][0])) continue;
            return index;
        }
        return -1;
    }

    private final String[] duplicate(String[] srcArray) {
        return (String[])srcArray.clone();
    }

    private final String[][] duplicate(String[][] srcArray) {
        String[][] aCopy = new String[srcArray.length][];
        for (int i = 0; i < srcArray.length; ++i) {
            aCopy[i] = this.duplicate(srcArray[i]);
        }
        return aCopy;
    }

    private final void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = this.duplicate(src.eras);
        dst.eraNames = this.duplicate(src.eraNames);
        dst.months = this.duplicate(src.months);
        dst.shortMonths = this.duplicate(src.shortMonths);
        dst.narrowMonths = this.duplicate(src.narrowMonths);
        dst.standaloneMonths = this.duplicate(src.standaloneMonths);
        dst.standaloneShortMonths = this.duplicate(src.standaloneShortMonths);
        dst.standaloneNarrowMonths = this.duplicate(src.standaloneNarrowMonths);
        dst.weekdays = this.duplicate(src.weekdays);
        dst.shortWeekdays = this.duplicate(src.shortWeekdays);
        dst.narrowWeekdays = this.duplicate(src.narrowWeekdays);
        dst.standaloneWeekdays = this.duplicate(src.standaloneWeekdays);
        dst.standaloneShortWeekdays = this.duplicate(src.standaloneShortWeekdays);
        dst.standaloneNarrowWeekdays = this.duplicate(src.standaloneNarrowWeekdays);
        dst.ampms = this.duplicate(src.ampms);
        if (src.zoneStringsHash != null) {
            dst.zoneStringsHash = (HashMap)src.zoneStringsHash.clone();
        }
        dst.requestedLocale = new ULocale(src.requestedLocale.toString());
        dst.localPatternChars = new String(src.localPatternChars);
    }

    public DateFormatSymbols(Calendar cal, Locale locale) {
        this.initializeData(ULocale.forLocale(locale), cal.getType());
    }

    public DateFormatSymbols(Calendar cal, ULocale locale) {
        this.initializeData(locale, cal.getType());
    }

    public DateFormatSymbols(Class calendarClass, Locale locale) {
        this(calendarClass, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(Class calendarClass, ULocale locale) {
        String fullName = calendarClass.getName();
        int lastDot = fullName.lastIndexOf(46);
        String className = fullName.substring(lastDot + 1);
        String calType = Utility.replaceAll(className, "Calendar", "").toLowerCase();
        this.initializeData(locale, calType);
    }

    public DateFormatSymbols(ResourceBundle bundle, Locale locale) {
        this(bundle, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(ResourceBundle bundle, ULocale locale) {
        this.initializeData(locale, new CalendarData((ICUResourceBundle)bundle, null));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(calendarClass, ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, ULocale locale) throws MissingResourceException {
        UResourceBundle result;
        block2: {
            String fullName = calendarClass.getName();
            int lastDot = fullName.lastIndexOf(46);
            String className = fullName.substring(lastDot + 1);
            String bundleName = className + "Symbols";
            result = null;
            try {
                result = UResourceBundle.getBundleInstance(bundleName, locale);
            }
            catch (MissingResourceException e2) {
                if ((class$com$ibm$icu$util$GregorianCalendar == null ? (class$com$ibm$icu$util$GregorianCalendar = DateFormatSymbols.class$("com.ibm.icu.util.GregorianCalendar")) : class$com$ibm$icu$util$GregorianCalendar).isAssignableFrom(calendarClass)) break block2;
                throw e2;
            }
        }
        return result;
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, ULocale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), locale);
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ZoneItem {
        String value;
        int type;
        String zid;

        ZoneItem() {
        }
    }
}

