/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DataSourceGraph;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataSourceImpl
implements DataSource {
    protected DataSourceGraph dsg = null;
    private Map cache = new HashMap();

    public DataSourceImpl() {
        this.dsg = new DataSourceGraphImpl();
    }

    public DataSourceImpl(DataSourceGraph otherDSG) {
        this.dsg = otherDSG;
    }

    public DataSourceImpl(DatasetGraph dSetGraph) {
        this.dsg = new DataSourceGraphImpl(dSetGraph);
    }

    public DataSourceImpl(Model model) {
        this.addToCache(model);
        this.dsg = new DataSourceGraphImpl(model.getGraph());
    }

    public DataSourceImpl(Dataset ds) {
        this.dsg = new DataSourceGraphImpl(ds);
    }

    public Model getDefaultModel() {
        return this.graph2model(this.dsg.getDefaultGraph());
    }

    public Lock getLock() {
        return this.dsg.getLock();
    }

    public DataSourceGraph getDataSourceGraph() {
        return this.dsg;
    }

    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    public Model getNamedModel(String uri) {
        Node n = Node.createURI(uri);
        return this.graph2model(this.dsg.getGraph(n));
    }

    public void addNamedModel(String uri, Model model) throws LabelExistsException {
        this.addToCache(model);
        Node n = Node.createURI(uri);
        this.dsg.addGraph(n, model.getGraph());
    }

    public void removeNamedModel(String uri) {
        Node n = Node.createURI(uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
    }

    public void replaceNamedModel(String uri, Model model) {
        Node n = Node.createURI(uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
        this.addToCache(model);
        this.dsg.addGraph(n, model.getGraph());
    }

    public void setDefaultModel(Model model) {
        this.removeFromCache(this.dsg.getDefaultGraph());
        this.cache.put(model.getGraph(), model);
        this.dsg.setDefaultGraph(model.getGraph());
    }

    public boolean containsNamedModel(String uri) {
        Node n = Node.createURI(uri);
        return this.dsg.containsGraph(n);
    }

    public Iterator listNames() {
        ArrayList x = new ArrayList(this.dsg.size());
        MapFilter mapper = new MapFilter(){

            public Object accept(Object x) {
                Node n = (Node)x;
                return n.getURI();
            }
        };
        ExtendedIterator eIter = WrappedIterator.create(this.dsg.listGraphNodes());
        MapFilterIterator conv = new MapFilterIterator(mapper, eIter);
        return conv;
    }

    private void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove(graph);
    }

    private void addToCache(Model model) {
        this.cache.put(model.getGraph(), model);
    }

    private Model graph2model(Graph graph) {
        Model model = (Model)this.cache.get(graph);
        if (model == null) {
            model = ModelFactory.createModelForGraph(graph);
            this.cache.put(graph, model);
        }
        return model;
    }
}

