/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public class TestDyadic
extends GraphTestBase {
    public TestDyadic(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDyadic.class);
    }

    private static ExtendedIterator things(final String x) {
        return new NiceIterator(){
            private StringTokenizer tokens;
            {
                this.tokens = new StringTokenizer(x);
            }

            public boolean hasNext() {
                return this.tokens.hasMoreTokens();
            }

            public Object next() {
                return this.tokens.nextToken();
            }
        };
    }

    public void testDyadic() {
        ExtendedIterator it1 = TestDyadic.things("now is the time");
        ExtendedIterator it2 = TestDyadic.things("now is the time");
        ExtendedIterator mt1 = TestDyadic.things("");
        ExtendedIterator mt2 = TestDyadic.things("");
        TestDyadic.assertEquals("mt1.hasNext()", false, mt1.hasNext());
        TestDyadic.assertEquals("mt2.hasNext()", false, mt2.hasNext());
        TestDyadic.assertEquals("andThen(mt1,mt2).hasNext()", false, mt1.andThen(mt2).hasNext());
        TestDyadic.assertEquals("butNot(it1,it2).hasNext()", false, Dyadic.butNot(it1, it2).hasNext());
        TestDyadic.assertEquals("x y z @butNot z", true, Dyadic.butNot(TestDyadic.things("x y z"), TestDyadic.things("z")).hasNext());
        TestDyadic.assertEquals("x y z @butNot a", true, Dyadic.butNot(TestDyadic.things("x y z"), TestDyadic.things("z")).hasNext());
    }

    public void testDyadicOperands() {
        Graph g = Factory.createGraphMem();
        Graph h = Factory.createGraphMem();
        Dyadic d = new Dyadic(g, h){

            public ExtendedIterator graphBaseFind(TripleMatch m) {
                return null;
            }
        };
        TestDyadic.assertSame(g, d.getL());
        TestDyadic.assertSame(h, d.getR());
    }
}

