/**
 * This work was created by participants in the DataONE project, and is jointly copyrighted by participating
 * institutions in DataONE. For more information on DataONE, see our web site at http://dataone.org.
 *
 * Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * $Id$
 */
package gov.ornl.mercury3.web.util;

import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.services.SolrTransactionService;
import gov.ornl.mercury3.services.SolrTransactionServiceDefault;
import gov.ornl.mercury3.services.SolrTransactionServiceVersion1_1;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SolrTransactionServiceFactory {

    private static SolrTransactionService transactionService = null;
    private static String schemaVersion = "1.1";
    private static long CACHE_EXPIRATION_PERIOD = 60000 * 15; // 15 minutes
    private static long serviceCreationTimestamp = 0;

    private SolrTransactionServiceFactory() {
    }

    public static SolrTransactionService getTransactionService() {
        if (timeToConfigure()) {
            configure();
        }
        return transactionService;
    }

    private static boolean timeToConfigure() {
        if (serviceCreationTimestamp == 0 || transactionService == null) {
            return true;
        } else if (serviceCreationTimestamp + CACHE_EXPIRATION_PERIOD < System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    private static void configure() {
        setSchemaVersionFromProperties();
        if ("1".equals(schemaVersion)) {
            transactionService = new SolrTransactionServiceDefault();
        } else if ("1.1".equals(schemaVersion)) {
            transactionService = new SolrTransactionServiceVersion1_1();
        } else {
            transactionService = new SolrTransactionServiceDefault();
        }
        serviceCreationTimestamp = System.currentTimeMillis();
    }

    private static void setSchemaVersionFromProperties() {
        try {
            ApplicationContext factory = new ClassPathXmlApplicationContext(
                    "solrTxServiceFactoryProperties.xml");
            Configuration cv = (Configuration) factory.getBean("propertiesBean");
            String tempSchemaVersion = (String) cv.getProperties().get("solr_schema_version");
            if (StringUtils.isNotEmpty(tempSchemaVersion)) {
                schemaVersion = tempSchemaVersion;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
