/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.web.util;

import java.util.HashSet;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONException;

public class D1DocTransferObject {

    private String pid = "";
    private Set<String> resourceMaps = new HashSet<String>();
    private String dataUrl = "";
    boolean isPublic = false;
    private String size = "";
    private String formatId = "";
    private boolean isMetadata = false;
    private boolean isResourceMap = false;

    public D1DocTransferObject() {

    }

    public D1DocTransferObject(String pid, String dataUrl, String formatId, String size,
            String isPublic) {
        this.pid = pid;
        this.dataUrl = dataUrl;
        this.isPublic = Boolean.valueOf(isPublic).booleanValue();
        this.formatId = formatId;
        this.size = size;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getDataUrl() {
        return dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public boolean isPublic() {
        return isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getFormatId() {
        return formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public boolean isMetadata() {
        return isMetadata;
    }

    public void setMetadata(boolean isMetadata) {
        this.isMetadata = isMetadata;
    }

    public boolean getMetadata() {
        return isMetadata;
    }

    public boolean getIsResourceMap() {
        return isResourceMap;
    }

    public void setIsResourceMap(boolean isResource) {
        this.isResourceMap = isResource;
    }

    public Set<String> getResourceMaps() {
        return resourceMaps;
    }

    public void setResourceMaps(Set<String> resourceMaps) {
        this.resourceMaps = resourceMaps;
    }

    public void setResourceMap(JSONArray resourceMapsArray) {
        for (int i = 0; i < resourceMapsArray.length(); i++) {
            try {
                this.resourceMaps.add(resourceMapsArray.getString(i));
            } catch (JSONException jse) {
                System.out.println("ERROR: could not get resource map from array");
            }
        }
    }
}
