/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.web;

import gov.ornl.mercury3.beans.browseBean;
import gov.ornl.mercury3.beans.stringBean;
import gov.ornl.mercury3.commands.BriefRes;
import gov.ornl.mercury3.commands.Configuration;
import gov.ornl.mercury3.commands.EsipOpenSearchBean;
import gov.ornl.mercury3.commands.Field;
import gov.ornl.mercury3.commands.FilterCatField;
import gov.ornl.mercury3.commands.Geo;
import gov.ornl.mercury3.commands.OpenSearchBean;
import gov.ornl.mercury3.commands.Response;
import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SolrTransactionDetail;
import gov.ornl.mercury3.commands.Solr_datasource;
import gov.ornl.mercury3.commands.Terms;
import gov.ornl.mercury3.commands.Tokenz;
import gov.ornl.mercury3.email_utils.EmailGenerator;
import gov.ornl.mercury3.services.CustomRssBean;
import gov.ornl.mercury3.services.DataSourceMapBean;
import gov.ornl.mercury3.services.DataSourceMapNamesBean;
import gov.ornl.mercury3.services.GetAnchors;
import gov.ornl.mercury3.services.Mercury3_EditBoxParser;
import gov.ornl.mercury3.services.MercuryTermMapBean;
import gov.ornl.mercury3.services.Mercury_db_ServiceImpl;
import gov.ornl.mercury3.services.RssKeywords;
import gov.ornl.mercury3.services.SimpleMapBean;
import gov.ornl.mercury3.services.SolrFacets;
import gov.ornl.mercury3.services.SolrSearcher;
import gov.ornl.mercury3.services.SolrTransactionService;
import gov.ornl.mercury3.services.SourceObject;
import gov.ornl.mercury3.services.UserStatUtil_2;
import gov.ornl.mercury3.web.util.D1DocTransferObject;
import gov.ornl.mercury3.web.util.MemberNodeSourcesMapCache;
import gov.ornl.mercury3.web.util.SolrTransactionServiceFactory;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.dataone.client.D1RestClient;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.service.cn.v1.CNCore;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Session;
import org.dataone.service.util.Constants;
import org.json.JSONML;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.WebUtils;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;

/**
 * Super class for all the Mercury3 Web Application Controllers.
 */
public class SolrClientController extends MultiActionController {

    private static final boolean defaultFilterDataValue = true;
    private static final String D1_RESOLVE_URL_PREFIX = "/cn/" + CNCore.SERVICE_VERSION + "/"
            + Constants.RESOURCE_RESOLVE + "/";

    private boolean use_mn_source_cache = false;

    /** Email To address for error notifications */
    public String toEMAIL = "";

    /**
     * Email address which will show up as the
     * "from in error email notifications"
     */
    public String fromEMAIL = "";

    /** Local Properties for this Instance. Deprecated ?? */
    Properties mercuryCommonProp = new Properties();

    /** Holder for the Instance Name as configured in XML. */
    String webAppRoot = "";

    /** Hash Map for working copy of flags read in from XML configuration file. */
    HashMap<String, Object> hmProps = new HashMap<String, Object>();

    /** Reusable list object. Deprecated ?? */
    List<String> li = new ArrayList<String>();

    /** Local container for parameters defined in the mercuryTermMaps XML file. */
    MercuryTermMapBean mtmb = new MercuryTermMapBean();

    /**
     * Local container for parameters defined in the Data Source Map bean of
     * mercuryTermMaps XML file.
     */
    DataSourceMapBean dsmb = new DataSourceMapBean();

    /**
     * Local container for parameters defined in the Data Source Names bean of
     * mercuryTermMaps XML file.
     */
    DataSourceMapNamesBean dsmbName = new DataSourceMapNamesBean();

    /** Holder for map from mercury Term Maps xml */
    SimpleMapBean smb = new SimpleMapBean();

    /** Boolean flag which controls database access (must be true for db usage). */
    public boolean debug = false;

    /**
     * Boolean flag which controls fullPage display behavior (must be true for
     * transforms to be employed). First created for DataOne
     **/
    public boolean transformFullPage = true;

    /**
     * Boolean switch for returning full -vs- brief page if response size equals
     * one.
     */
    public boolean singletonFullView = false;

    /** The factory2. */
    ApplicationContext factory2 = null;

    /** Complete path to the Harvested Metadata files' */
    String metadata_path = "";

    /** Context initialized with applicationContext xml . */
    ApplicationContext ctx = null;

    /** Filename to return for the "FULL" JSP view . */
    String fullViewPage = "";

    /** Context initialized with facets xml . */
    ApplicationContext xf = null;

    /** Context initialized with Mercury_term_maps xml. */
    ApplicationContext factory3 = null;

    /** Local holder for the allowed terms and map to full names for the view. */
    public HashMap<String, String> termMap = new HashMap();// mtmb.getTermMap();

    /**
     * Local holder for the allowed datasource names and map to full names for
     * the view.
     */
    // do not use this field directly - go through the getDatasourceMap method
    private Map<String, String> datasourceMap = new HashMap();

    // dsmb.getDatasourceMap();

    /** Hash map containing the term1 attribute constraints. */
    public HashMap<String, String> term1Map = new HashMap();// smb.getTerm1Map();

    /** Hashmap of names -vs- datasources . */
    public Map<String, String> datasourceMapNames = new HashMap();// smb.dsmbName();

    /**
     * Full path to the MySQL database for this Instance as parsed from the XML.
     */
    public String solrdb = "";

    /**
     * Full URL for accessing the SOLR Index for the current mercury Instance,
     * as parsed from XML file.
     */
    public String solrSelectURL = "";

    /** Programmatic database transaction Service Implementation object. */
    Mercury_db_ServiceImpl psi = new Mercury_db_ServiceImpl();

    private SolrSearcher solrSearcher = null;

    private Map<String, String> xsltMapBean = null;

    /**
     * Instantiates a new solr client controller.
     */
    public SolrClientController() {
        try {
            ctx = new ClassPathXmlApplicationContext("applicationContext.xml");
            psi = (Mercury_db_ServiceImpl) ctx.getBean("mercury_db_Service");
            xf = new ClassPathXmlApplicationContext("gov/ornl/mercury3/services/facets.xml");
            ApplicationContext factory = new ClassPathXmlApplicationContext(
                    "Mercury3Properties.xml");//
            Configuration cv = (Configuration) factory.getBean("propertiesBean");
            hmProps = cv.getProperties();
            debug = Boolean.parseBoolean((String) (hmProps.get("debug")));

            this.xsltMapBean = (Map<String, String>) factory.getBean("xsltMapBean");

            factory2 = new ClassPathXmlApplicationContext(
                    "gov/ornl/mercury3/services/applicationContext.xml");
            metadata_path = (String) hmProps.get("metadata_path");
            fullViewPage = (String) hmProps.get("fullViewPage");
            transformFullPage = Boolean.parseBoolean((String) hmProps.get("transformFullPage"));

            try {
                toEMAIL = (String) hmProps.get("toEMAIL");
                fromEMAIL = (String) hmProps.get("fromEMAIL");
            } catch (Exception exc) {
                exc.printStackTrace();
                toEMAIL = "mercury-support@ornl.gov";
                fromEMAIL = "palanisamyg@ornl.gov";
            }

            if ((null == toEMAIL) || (toEMAIL.length() == 0)) {
                toEMAIL = "mercury-support@ornl.gov";
            }
            if ((null == fromEMAIL) || (fromEMAIL.length() == 0)) {
                fromEMAIL = "palanisamyg@ornl.gov";
            }

            factory3 = new ClassPathXmlApplicationContext(
                    "gov/ornl/mercury3/services/Mercury_term_maps.xml");
            mtmb = (MercuryTermMapBean) factory3.getBean("mercury_term_map");
            dsmb = (DataSourceMapBean) factory3.getBean("datasource_map");
            smb = (SimpleMapBean) factory3.getBean("simpleMap");

            termMap = mtmb.getTermMap();
            datasourceMap = dsmb.getDatasourceMap();

            use_mn_source_cache = Boolean
                    .parseBoolean((String) (hmProps.get("use_mn_source_cache")));

            term1Map = smb.getTerm1Map();
            singletonFullView = Boolean.parseBoolean((String) (hmProps.get("singletonFullView")));
            solrdb = (String) (hmProps.get("solrdb"));
            solrSelectURL = (String) (hmProps.get("solrSelectURL"));
            solrSearcher = new SolrSearcher(solrSelectURL);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * Solr pass through to avoid same origin policy restrictions on xhr calls
     * to solr when mercury is running on another host than the index.
     * 
     * Forwards original request to solr and returns the response.
     * 
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ModelAndView solrPass(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        // get the original request, forward to the solr search endpoint
        String result = solrSearcher
                .solrPass(request.getParameterMap(), registerD1Session(request));
        return new ModelAndView("stringView", "responseString", result);
    }

    /**
     * Gets the JSON Array for a web based tree node using a HttpServletResponse
     * writer object .
     * 
     * @param req
     *            the HttpServletRequest
     * @param resp
     *            the HttpServletResponse
     * 
     * @return JSON Array.
     * 
     * @throws Exception
     *             the exception
     */
    public void get_solr_json(HttpServletRequest req, HttpServletResponse resp) throws Exception {

        req.setAttribute("browse_tree", "true");
        HttpSession session = req.getSession(true);
        browseBean browseBean = new browseBean();
        resp.setContentType("text/javascript");

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        SolrTransactionDetail std = new SolrTransactionDetail();

        HashMap hm = new HashMap(); // start with clean map
        Terms facet = new Terms();
        int field_ndx = -1;
        JSONObject jo = new JSONObject();
        String data = req.getParameter("data");

        Response res = new Response();

        Search_Terms st = new Search_Terms();
        st = get_base_st(req, resp); // / test for no session history
        st.setCurrent_page(1);
        st.setPageSize(5000);
        st.setStart(0);

        ArrayList titles = new ArrayList();
        ArrayList sourcelist = new ArrayList();

        String objectId = "";
        objectId = req.getParameter("objectId");
        if (objectId.indexOf("&") != -1) {
            String[] requestParams = objectId.split("&");
            HashMap requestParmMap = new HashMap();
            for (int i = 0; i < requestParams.length; i++) {
                String[] reqestParam = (requestParams[i]).split(":");
                if (!(reqestParam.length == 1)) {
                    requestParmMap.put(reqestParam[0], reqestParam[1]);
                }
            }
            Iterator requestIT = requestParmMap.keySet().iterator();
            while (requestIT.hasNext()) {
                String fieldName = (String) requestIT.next();
                String fieldValue = (String) requestParmMap.get(fieldName);

                String t_fieldValue = "";
                t_fieldValue = fieldValue.toLowerCase();

                browseBean.setobjectId(objectId);

                if (fieldName.equalsIgnoreCase("path")) {
                    browseBean.setpath(fieldValue);
                }
                if (fieldName.equalsIgnoreCase("field")) {
                    browseBean.setfield(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("datasource")) {
                    browseBean.setdataSource(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet")) {
                    browseBean.setFacet(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet1")) {
                    browseBean.setFacet1(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet1attribute")) {
                    browseBean.setFacet1attribute(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet2")) {
                    browseBean.setFacet2(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet2attribute")) {
                    browseBean.setFacet2attribute(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet3")) {
                    browseBean.setFacet3(t_fieldValue);
                }
                if (fieldName.equalsIgnoreCase("facet3attribute")) {
                    browseBean.setFacet3attribute(t_fieldValue);
                }
            }
        }
        String tree_datasource = "";
        if (!(null == browseBean.getdataSource())) {
            tree_datasource = browseBean.getdataSource();
        }
        st.setBrowse_field(browseBean.getfield());
        st.setBrowse_path(browseBean.getpath());
        boolean datasource_found = false;

        if ((tree_datasource.trim().equalsIgnoreCase("daac"))
                || (tree_datasource.trim().equalsIgnoreCase("rgd"))
                || (tree_datasource.trim().equalsIgnoreCase("landval"))
                || (tree_datasource.trim().equalsIgnoreCase("safari2k"))) {
            sourcelist.add(tree_datasource);
            browseBean.setdataSource(tree_datasource);
            st.setBrowse_source(tree_datasource);
            datasource_found = true;
        }

        if (!(datasource_found) && (!(null == browseBean.getdataSource()))) {
            sourcelist.add(browseBean.getdataSource());
            st.setSource(browseBean.getdataSource());
            tree_datasource = browseBean.getdataSource();
            st.setBrowse_source(tree_datasource);
            datasource_found = true;
        }

        if (datasource_found) {
            ArrayList fac_list = new ArrayList();
            ArrayList wbt_fac_list = new ArrayList();
            if (!(null == browseBean.getpath()) && (!(null == browseBean.getfield()))) {
                try {
                    SolrFacets wbt = (SolrFacets) xf.getBean(browseBean.getpath().trim());
                    for (int i = 0; i < wbt.getFacets().size(); i++) {
                        wbt_fac_list.add(wbt.getFacets().get(i));
                        fac_list.add(wbt.getFacets().get(i));
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
                browseBean.setFacet1((String) (fac_list.get(0)));
                browseBean.setFacet2((String) (fac_list.get(1)));
                browseBean.setFacet3((String) (fac_list.get(2)));
                browseBean.setBrowse_facets(fac_list);

                field_ndx = fac_list.indexOf(browseBean.getfield());

                Terms term1 = new Terms();
                Terms term2 = new Terms();
                Terms browse = new Terms();

                term1.setAttribute((String) (fac_list.get(0)));
                term2.setAttribute((String) (fac_list.get(1)));
                browse.setAttribute((String) (fac_list.get(2)));
                term2.setOperation(" AND ");
                browse.setOperation(" AND ");

                browseBean.setField_ndx(field_ndx);

                if (field_ndx < 2) {
                    browseBean.setNext_node((String) fac_list.get(field_ndx + 1));
                } else {
                    browseBean.setNext_node("brief");
                }

                switch (field_ndx) {

                case 2:
                    browseBean.setFacetattribute(browseBean.getFacet2());
                    browseBean.setFacet2attribute(browseBean.getFacet());
                    facet.setAttribute((String) browseBean.getFacet2());
                    facet.setValue((String) browseBean.getFacet2attribute());

                    browse.setValue(browseBean.getFacet3attribute());
                    term2.setValue(browseBean.getFacet2attribute());
                    term1.setValue(browseBean.getFacet1attribute());
                    browseBean.setNext_node("brief");
                    break;
                case 1:
                    browseBean.setFacetattribute(browseBean.getFacet1());
                    facet.setAttribute((String) browseBean.getFacet1());
                    facet.setValue((String) browseBean.getFacet1attribute());
                    term1.setValue(browseBean.getFacet1attribute());
                    browseBean.setNext_node((String) fac_list.get(2));
                    term2.setValue(browseBean.getFacet2attribute());
                    break;

                case 0:
                    break;
                }
                st.setTerm1(term1);
                st.setTerm2(term2);
                st.setBrowse(browse);
            }

            st.setDatasources(sourcelist);
            st.setSource(tree_datasource);
            std = solrTransactionServices.get_browse_details(st);
            titles = std.getJ_Docs();
            res = std.getRes();
        }

        stringBean sb = new stringBean();
        PrintWriter writer = resp.getWriter();
        String sendString;

        if (datasource_found) {
            if ((!(null == titles) && titles.size() > 0)) {
                if (objectId.trim().contains("dataset")) {
                    browseBean.setfield("dataset");
                    sendString = sb.getString(res, browseBean);
                } else {
                    sendString = sb.getString(res, browseBean);
                }
                writer.print(sendString);
            } else {
                browseBean.setMetaDataError("Oh, No!!!");
                sendString = sb.getString(res, browseBean);
                writer.print(sendString);
            }
            writer.close();
            if (!debug) {
                try {
                    UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                    userStatUtil.populateUserStatDB(req, resp, std, "MercuryWBT", st, term1Map,
                            termMap, psi);
                } catch (Throwable ex) {
                    System.err.println("Initial SessionFactory creation failed." + ex);
                    throw new ExceptionInInitializerError(ex);
                }
            }
        }
    }

    /**
     * Gets the JSON Array for a TimeMap using a HttpServletResponse writer
     * object .
     * 
     * @param req
     *            the HttpServletRequest
     * @param resp
     *            the HttpServletResponse
     * 
     * @return JSON Array.
     * 
     * @throws Exception
     *             the exception
     */
    public void get_TM_json(HttpServletRequest req, HttpServletResponse resp) throws Exception {

        // request will have embedded dates which we will validate
        // possibly with the new validation api
        // as we use it in the openSearch request validation scheme
        // where and how the search goes to solr is tbd
        // where and how the solr response is transformed to json is tbd also
        String callback = req.getParameter("callback");
        resp.setContentType("text/javascript");
        PrintWriter writer = resp.getWriter();
        // read file for dummy response to data request
        StringBuilder sb = new StringBuilder();
        sb.append(callback + readFileAsString("c:\\datafiles\\progressiveData.json"));
        writer.print(sb.toString());
        writer.close();
    }

    private static String readFileAsString(String filePath) throws java.io.IOException {
        byte[] buffer = new byte[(int) new File(filePath).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(filePath));
            f.read(buffer);
        } finally {
            if (f != null)
                try {
                    f.close();
                } catch (IOException ignored) {
                }
        }
        return new String(buffer);
    }

    /**
     * Entry point for the Mercury Querying process.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView query(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        Session d1Session = registerD1Session(request);

        request.setCharacterEncoding("UTF-8");

        boolean fullPage = false;
        boolean displayFullpage = false;

        String mercury3_query_string = "";
        String nb = "";

        HttpSession session = request.getSession(true);
        synchronized (session) {
            session.removeAttribute("refererm");
        }

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();

        ServletContext servletContext = getServletContext();
        String WebAppRoot = servletContext.getInitParameter(WebUtils.WEB_APP_ROOT_KEY_PARAM)
                .replace("3.root", "");

        session.setAttribute("instance", WebAppRoot);
        session.setAttribute("sessioninstance", WebAppRoot);

        Search_Terms st = new Search_Terms();

        if (!(null == request.getParameter("display"))) {
            String dfpg = request.getParameter("display");
            displayFullpage = (dfpg.equalsIgnoreCase("full"));
        }

        st = this.get_base_st(request, response);

        if ((!(null == request.getParameter("browseattribute")))
                && (!(null == request.getParameter("browse")))) {
            if (termMap.containsKey(request.getParameter("browseattribute"))) {
                Terms browse = new Terms();
                browse.setAttribute((String) termMap.get(request.getParameter("browseattribute")));
                browse.setOperation(" AND ");
                browse.setValue(request.getParameter("browse"));

                st.setBrowse(browse);
            }
        }

        if (!(null == request.getParameter("queryString"))) {
            System.out.println("QUERY STRING: " + request.getParameter("queryString"));
            st.setGui_queryString(getRequestParameter(request.getParameter("queryString")));
            st.setFull_queryString(getRequestParameter(request.getParameter("queryString")));
        }

        SolrTransactionDetail solrTransactionDetail = solrTransactionServices
                .getSolrTransactionDetail(st, d1Session);

        st.setResponses(solrTransactionDetail.getFound());
        st.setPage_max_count(st.getPageSize());
        int num_pages;
        int pmc = st.getResponses();
        int cp = 1;
        if (st.getResponses() % st.getPageSize() > 0) {
            num_pages = (st.getResponses() / st.getPageSize()) + 1;
        } else {
            num_pages = st.getResponses() / st.getPageSize();
        }

        st.setNum_pages(num_pages);

        if ((st.getResponses() < st.getPageSize()) || (cp == num_pages)) {
            pmc = st.getResponses();
        } else if (cp < num_pages) {
            pmc = cp * st.getPageSize();
        }

        st.setCurrent_page(cp);
        st.setPage_max_count(pmc);

        if (!(null == request.getParameter("browseStatus"))) {
            String browseStatus = request.getParameter("browseStatus");
            solrTransactionDetail.setBrowseStatus(browseStatus);
            st.setBrowseStatus(browseStatus);
        }
        mercury3_query_string = build_base_request(st);

        nb = this.getPageNavBar(1, st.getPageSize(), st.getResponses(), st.getNum_pages(), "Prev",
                "Next", " brief", mercury3_query_string, st);

        solrTransactionDetail.setNb(nb);
        st.setSortattribute("default");

        solrTransactionDetail.setSortattribute("default");
        solrTransactionDetail.setPage_max_count(pmc);

        HashMap hm = new HashMap();

        if (!(null == request.getParameter("start"))) {
            st.setStart((Integer.parseInt(request.getParameter("start"))));
        }

        solrTransactionDetail.setSortattribute(st.getSortattribute());
        solrTransactionDetail.setNb(nb);

        solrTransactionDetail.setSolr_facets_map(hm);

        solrTransactionDetail.setMercury3_query_string(mercury3_query_string);
        solrTransactionDetail.setFull_queryString(st.getFull_queryString());

        String preCat = solrTransactionDetail.getGui_queryString().replaceAll("%22", "");
        solrTransactionDetail.setPlainqueryString(preCat);
        if (!debug) {
            try {
                UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                userStatUtil.populateUserStatDB(request, response, solrTransactionDetail,
                        "MercuryBrief", st, term1Map, termMap, psi);
            } catch (Throwable ex) {
                System.err.println("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }

        // setD1DataPackageInfo(solrTransactionDetail, d1Session);

        /*
         * This will allow control of the behavior when a single response is
         * found by setting a flag in the properties xml file The type checking
         * is being used to allow for backwards compatibility with changes in
         * the services layer.jmg 01/23/2009. if retrieving terms from the
         * hashmap, pay attention to the solr names specified in facets.xml and
         * note that these ARE case sensitive.
         * 
         * Changed to include possibility of a querystring parameter to force
         * the full page to display if (found=1 && (singletonFullView ||
         * displayFullpage)) where displayFullpage is ( ).
         */

        fullPage = ((solrTransactionDetail.found == 1) && (singletonFullView || displayFullpage));

        if (fullPage) {

            String fileURL = "";
            String full_datasource = "";
            String ds_id = "";

            if (solrTransactionDetail.getBriefResList().get(0) instanceof BriefRes) {
                BriefRes br = (BriefRes) (solrTransactionDetail.getBriefResList()).get(0);
                fileURL = br.getId();
                full_datasource = br.getDatasource();
                ds_id = br.getFileID();
            } else if (solrTransactionDetail.getBriefResList().get(0) instanceof HashMap) {
                HashMap br = (HashMap) (solrTransactionDetail.getBriefResList()).get(0);
                fileURL = (String) br.get("id");
                full_datasource = (String) br.get("datasource");
                ds_id = (String) br.get("fileID");
            } else {
                return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);
            }
            String gotourl = "../send/xsltText2";
            String goURL = "";

            final List<NameValuePair> j_params = new ArrayList<NameValuePair>();
            final HttpMethod j_method = new GetMethod();
            String my_query_string = "";
            j_params.add(new NameValuePair("fileURL", fileURL));
            j_params.add(new NameValuePair("full_datasource", full_datasource));
            j_params.add(new NameValuePair("full_queryString", preCat));
            j_params.add(new NameValuePair("ds_id", ds_id));
            j_method.setQueryString(EncodingUtil.formUrlEncode(
                    j_params.toArray(new NameValuePair[0]), "UTF-8"));
            my_query_string = j_method.getQueryString();

            goURL = gotourl + "?" + my_query_string;

            return new ModelAndView(new RedirectView(goURL, true));

        } else {
            setMemberNodeDescriptionField(solrTransactionDetail);
            return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);
        }

    }

    private Session registerD1Session(HttpServletRequest request) {

        Session session = null;
        try {
            session = PortalCertificateManager.getInstance()
                    .registerPortalCertificateAndPlaceOnRequest(request);
        } catch (Exception e) {
            System.out.println("ERROR: Unable to get dataone session in one-mercury.");
        }
        return session;
    }

    private void setMemberNodeDescriptionField(SolrTransactionDetail solrTransactionDetail) {
        if (use_mn_source_cache) {
            if (solrTransactionDetail != null && solrTransactionDetail.getFacets() != null) {
                for (FilterCatField fcf : solrTransactionDetail.getFacets().keySet()) {
                    if (fcf.getFilterCatCode().equals("datasource")) {
                        List<Field> stuff = solrTransactionDetail.getFacets().get(fcf);
                        for (Field field : stuff) {
                            if (getDatasourceMap().containsKey(field.getName())) {
                                field.setDescription(MemberNodeSourcesMapCache.INSTANCE
                                        .getMNSourceMap().get(field.getName()));
                            }
                        }
                    }
                }
            }
        }
    }

    private Map<String, String> getDatasourceMap() {
        if (use_mn_source_cache) {
            return MemberNodeSourcesMapCache.INSTANCE.getMNSourceMap();
        } else {
            return this.datasourceMap;
        }
    }

    /**
     * Facets querry2.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView facetsQuerry2(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        Session d1Session = registerD1Session(request);

        boolean get_back = false;
        String nb = "";
        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();

        String mercury3_query_string = "";

        Search_Terms st = new Search_Terms();

        HttpSession session = request.getSession(false);
        HashMap hm = new HashMap();

        try {
            st = get_base_st(request, response);
            hm = st.getSolr_facets_map();
            Terms facet = new Terms();
            if (!(null == request.getParameter("facet"))
                    && (!(null == request.getParameter("facetattribute")))) {

                facet.setAttribute(getRequestParameter(request.getParameter("facetattribute")));
                facet.setValue(getRequestParameter(request.getParameter("facet")));
                facet.setOperation(" AND ");
                st.setFacet(facet);
                st.setStart(0);
                SolrTransactionDetail solrTransactionDetail = solrTransactionServices
                        .getSolrTransactionDetail(st, d1Session);// new
                                                                 // moved
                st.setResponses(solrTransactionDetail.getFound());// new
                int num_pages;
                int pmc = st.getResponses();
                int cp = 1;
                if (st.getResponses() % st.getPageSize() > 0) {
                    num_pages = (st.getResponses() / st.getPageSize()) + 1;
                } else {
                    num_pages = st.getResponses() / st.getPageSize();
                }

                st.setNum_pages(num_pages);

                if ((st.getResponses() < st.getPageSize()) || (cp == num_pages)) {
                    pmc = st.getResponses();
                } else if (cp < num_pages) {
                    pmc = cp * st.getPageSize();
                }

                st.setCurrent_page(1);
                st.setPage_max_count(pmc);
                int ps = st.getPageSize();
                int res = st.getResponses();

                st.setHideDS(solrTransactionDetail.getHideDS());
                st.setResponses(solrTransactionDetail.getFound());
                if (st.getResponses() % st.getPageSize() > 0) {
                    num_pages = (st.getResponses() / st.getPageSize()) + 1;
                } else {
                    num_pages = st.getResponses() / st.getPageSize();
                }

                st.setNum_pages(num_pages);

                mercury3_query_string = build_base_request(st);
                st.setResponses(solrTransactionDetail.getFound());
                if (st.getResponses() % st.getPageSize() > 0) {
                    num_pages = (st.getResponses() / st.getPageSize()) + 1;
                } else {
                    num_pages = st.getResponses() / st.getPageSize();
                }

                st.setNum_pages(num_pages);

                nb = this.getPageNavBar(1, st.getPageSize(), st.getResponses(), st.getNum_pages(),
                        "Prev", "Next", " brief", mercury3_query_string, st);

                solrTransactionDetail.setNb(nb);

                solrTransactionDetail.setSortattribute(st.getSortattribute());
                solrTransactionDetail.setSolr_facets_map(hm);
                solrTransactionDetail.setPage_max_count(pmc);
                st.setMercury3_query_string(mercury3_query_string);
                solrTransactionDetail.setMercury3_query_string(mercury3_query_string);

                String full_queryString = solrTransactionDetail.getQueryString();
                solrTransactionDetail.setFull_queryString(full_queryString.replace('"', ' '));

                String preCat = solrTransactionDetail.getGui_queryString().replaceAll("%22", "");
                solrTransactionDetail.setPlainqueryString(preCat);
                if (!debug) {
                    try {
                        UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                        userStatUtil.populateUserStatDB(request, response, solrTransactionDetail,
                                "MercuryFacets", st, term1Map, termMap, psi);
                    } catch (Throwable ex) {
                        System.err.println("Initial SessionFactory creation failed." + ex);
                        throw new ExceptionInInitializerError(ex);
                    }
                }
                setMemberNodeDescriptionField(solrTransactionDetail);
                // setD1DataPackageInfo(solrTransactionDetail, d1Session);
                return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);
            }

            if (!(null == st.getSolr_facets_map())) {
                hm = st.getSolr_facets_map();
            }
            if (hm.size() > 0) {

                if (!(null == request.getParameter("del_facet"))) {
                    if (hm.containsKey(request.getParameter("del_facet"))) {
                        hm.remove(request.getParameter("del_facet"));
                    }

                    try {
                        st.setSolr_facets_map(hm);
                    } catch (Exception e) {
                        System.out.println("Trouble with the setSolr_facets_map "
                                + e.getLocalizedMessage());
                        e.printStackTrace();
                    }

                    SolrTransactionDetail solrTransactionDetail = solrTransactionServices
                            .getSolrTransactionDetail(st, d1Session);
                    if ((request.getParameter("del_facet")).equalsIgnoreCase("datasource")) {
                        st.setHideDS("false");

                    }

                    int num_pages;
                    int pmc = st.getResponses();
                    int cp = 1;
                    if (st.getResponses() % st.getPageSize() > 0) {
                        num_pages = (st.getResponses() / st.getPageSize()) + 1;
                    } else {
                        num_pages = st.getResponses() / st.getPageSize();
                    }

                    st.setNum_pages(num_pages);

                    if ((st.getResponses() < st.getPageSize()) || (cp == num_pages)) {
                        pmc = st.getResponses();
                    } else if (cp < num_pages) {
                        pmc = cp * st.getPageSize();
                    }

                    st.setCurrent_page(1);
                    st.setPage_max_count(pmc);
                    st.setNum_pages(num_pages);

                    mercury3_query_string = build_base_request(st);

                    nb = this.getPageNavBar(1, st.getPageSize(), st.getResponses(),
                            st.getNum_pages(), "Prev", "Next", " brief", mercury3_query_string, st);

                    session.setAttribute("st", st);

                    solrTransactionDetail.setPage_max_count(st.getPage_max_count());
                    solrTransactionDetail.setNb(nb);

                    solrTransactionDetail.setSortattribute(st.getSortattribute());
                    solrTransactionDetail.setSolr_facets_map(hm);

                    st.setMercury3_query_string(mercury3_query_string);
                    solrTransactionDetail.setMercury3_query_string(mercury3_query_string);
                    solrTransactionDetail.setFull_queryString(solrTransactionDetail
                            .getQueryString().replace('"', ' '));
                    // setD1DataPackageInfo(solrTransactionDetail, d1Session);
                    setMemberNodeDescriptionField(solrTransactionDetail);
                    return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(" Trouble with the facetsQuerry method" + e.getMessage());
        }

        if (null == session) {
            String message = "Null session in FacetsQuery2. ";
            mail(message);
            return new ModelAndView("myview");

        }

        Terms simple = new Terms();
        simple.setAttribute("text");

        mercury3_query_string = build_base_request(st);// jmg

        if (!(null == request.getParameter("start"))) {
            st.setStart((Integer.parseInt(request.getParameter("start"))));
        }

        SolrTransactionDetail solrTransactionDetail = solrTransactionServices
                .getSolrTransactionDetail(st, d1Session);
        solrTransactionDetail.setSortattribute(st.getSortattribute());
        solrTransactionDetail.setNb(nb);

        solrTransactionDetail.setSolr_facets_map(hm);

        solrTransactionDetail.setMercury3_query_string(mercury3_query_string);

        solrTransactionDetail.setFull_queryString(solrTransactionDetail.getQueryString().replace(
                '"', ' '));

        String preCat = solrTransactionDetail.getGui_queryString().replaceAll("%22", "");
        solrTransactionDetail.setPlainqueryString(preCat);
        if (!debug) {
            try {

                UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                userStatUtil.populateUserStatDB(request, response, solrTransactionDetail,
                        "MercuryFacets", st, term1Map, termMap, psi);
            } catch (Throwable ex) {
                System.err.println("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }
        // setD1DataPackageInfo(solrTransactionDetail, d1Session);
        setMemberNodeDescriptionField(solrTransactionDetail);
        return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);

    }

    /**
     * Results_navigation2.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView results_navigation2(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        Session d1Session = registerD1Session(request);

        String nb = "";
        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();

        Search_Terms st = new Search_Terms();

        st = get_base_st(request, response);

        HttpSession session = request.getSession(false);

        String mercury3_query_string = "";

        if (null == session) {
            String message = "Null session in results_navigation2. ";
            mail(message);
            return new ModelAndView("myview");

        }

        if (!(null == request.getParameter("browseStatus"))) {
            String browseStatus = request.getParameter("browseStatus");

            st.setBrowseStatus(browseStatus);
        }

        Terms simple = new Terms();

        simple.setAttribute("text");
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();

        solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, d1Session);// call
        // shouldn't
        // be
        // here

        st.setHideDS(solrTransactionDetail.getHideDS());
        st.setResponses(solrTransactionDetail.getFound());

        int num_pages;
        int pmc = st.getResponses();
        int cp = st.getCurrent_page();

        if (st.getResponses() % st.getPageSize() > 0) {
            num_pages = (st.getResponses() / st.getPageSize()) + 1;
        } else {
            num_pages = st.getResponses() / st.getPageSize();
        }

        st.setNum_pages(num_pages);

        if ((st.getResponses() < st.getPageSize()) || (cp == num_pages)) {
            pmc = st.getResponses();
        } else if (cp < num_pages) {
            pmc = cp * st.getPageSize();
        }

        st.setCurrent_page(cp);
        st.setPage_max_count(pmc);

        int s2 = st.getStart();
        int ps2 = st.getPageSize();

        if ((cp > 0) && (!(cp > num_pages))) {
            s2 = (cp - 1) * ps2;
            st.setCurrent_page(cp);
            st.setStart(s2);
        }

        if (!(null == request.getParameterValues("page"))) {
            String[] nav_parm = request.getParameterValues("page");
            for (String nav : nav_parm) {

            }
        }

        int npl;
        String[] nav_parm;
        int current_page = 0;
        if (!(null == request.getParameterValues("page"))) {
            nav_parm = request.getParameterValues("page");
            npl = nav_parm.length - 1;
            current_page = Integer.parseInt(nav_parm[npl]);
            for (String nav : nav_parm) {

            }
        }

        if (!(null == request.getParameter("page"))) {
            num_pages = st.getNum_pages();
            int s = st.getStart();
            int ps = st.getPageSize();
            cp = st.getCurrent_page();
            pmc = st.getPage_max_count();

            if (st.getResponses() % st.getPageSize() > 0) {
                num_pages = (st.getResponses() / st.getPageSize()) + 1;
            } else {
                num_pages = st.getResponses() / st.getPageSize();
            }

            st.setNum_pages(num_pages);

            try {

                cp = current_page;

                if ((cp > 0) && (!(cp > num_pages))) {
                    s = (cp - 1) * ps;
                    st.setCurrent_page(cp);
                    st.setStart(s);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            if ((st.getResponses() < ps) || (cp == num_pages)) {
                pmc = st.getResponses();
            } else if (cp < num_pages) {
                pmc = cp * ps;
            }
            st.setPage_max_count(pmc);

        }

        if (!(null == request.getParameterValues("sortattribute"))) {
            String sort_attribute = new String();
            StringBuffer sb = new StringBuffer();

            String[] temp = request.getParameterValues("sortattribute");
            sort_attribute = temp[temp.length - 1];
            sb.append(temp[temp.length - 1]);
            st.setSortattribute(sb.toString());

            num_pages = st.getNum_pages();
            int s = st.getStart();
            int ps = st.getPageSize();
            cp = st.getCurrent_page();
            pmc = st.getPage_max_count();

            if (st.getResponses() % st.getPageSize() > 0) {
                num_pages = (st.getResponses() / st.getPageSize()) + 1;
            } else {
                num_pages = st.getResponses() / st.getPageSize();
            }

            st.setNum_pages(num_pages);

            if ((st.getResponses() < ps) || (cp == num_pages)) {
                pmc = st.getResponses();
            } else if (cp < num_pages) {
                pmc = cp * ps;
            }

            st.setCurrent_page(cp);
            st.setPage_max_count(pmc);
            s = (cp - 1) * ps;
            st.setStart(s);

        } else {
            st.setSortattribute("default");

        }

        mercury3_query_string = build_base_request(st);

        nb = this.getPageNavBar(st.getCurrent_page(), st.getPageSize(), st.getResponses(),
                st.getNum_pages(), "Prev", "Next", " brief", mercury3_query_string, st);

        solrTransactionDetail.setBrowseStatus(st.getBrowseStatus());
        solrTransactionDetail.setSortattribute(st.getSortattribute());
        solrTransactionDetail.setNb(nb);
        solrTransactionDetail.setCurrent_page(st.getCurrent_page());
        solrTransactionDetail.setStart(st.getStart());

        solrTransactionDetail.setSolr_facets_map(st.getSolr_facets_map());
        solrTransactionDetail.setPage_max_count(st.getPage_max_count());

        solrTransactionDetail.setMercury3_query_string(mercury3_query_string);

        solrTransactionDetail.setFull_queryString(solrTransactionDetail.getQueryString().replace(
                '"', ' '));

        String preCat = solrTransactionDetail.getGui_queryString().replaceAll("%22", "");
        solrTransactionDetail.setPlainqueryString(preCat);
        if (!debug) {
            try {

                UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                userStatUtil.populateUserStatDB(request, response, solrTransactionDetail,
                        "MercuryNavigation", st, term1Map, termMap, psi);
            } catch (Throwable ex) {
                System.err.println("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }
        solrTransactionDetail.setPage_max_count(pmc);
        // setD1DataPackageInfo(solrTransactionDetail, d1Session);
        setMemberNodeDescriptionField(solrTransactionDetail);
        return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);

    }

    private BufferedReader fetchD1Doc(String url, Session d1Session) throws InvalidToken,
            NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources,
            UnsupportedEncodingException {

        InputStream is = null;
        D1RestClient client = new D1RestClient(d1Session);
        try {
            byte[] bytes = IOUtils.toByteArray(client.doGetRequest(url));
            is = new ByteArrayInputStream(bytes);
        } catch (BaseException be) {
            if (be instanceof InvalidToken)
                throw (InvalidToken) be;
            if (be instanceof NotAuthorized)
                throw (NotAuthorized) be;
            if (be instanceof NotImplemented)
                throw (NotImplemented) be;
            if (be instanceof ServiceFailure)
                throw (ServiceFailure) be;
            if (be instanceof NotFound)
                throw (NotFound) be;
            if (be instanceof InsufficientResources)
                throw (InsufficientResources) be;
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IllegalStateException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (HttpException e) {
            e.printStackTrace();
        } finally {
            client.closeIdleConnections();
        }
        return new BufferedReader(new InputStreamReader(is, "UTF-8"));
    }

    private void setDataUrlMap(String pid, SolrTransactionDetail std, Session d1Session) {
        if (pid != null) {
            D1DocTransferObject metadata = solrSearcher.getD1DocInfo(pid, d1Session);
            if (metadata != null) {
                for (String resourceMapPid : metadata.getResourceMaps()) {
                    D1DocTransferObject resourceMap = solrSearcher.getD1DocInfo(resourceMapPid,
                            d1Session);
                    if (null != resourceMap) {
                        resourceMap.setIsResourceMap(true);
                        std.getD1Docs().add(resourceMap);
                    }
                }
                metadata.setMetadata(true);
                std.getD1Docs().add(metadata);
            }
            List<D1DocTransferObject> related = solrSearcher.findRelatedDocByResourceMap(pid,
                    d1Session);
            std.getD1Docs().addAll(related);
            std.setD1DataDocCount(related.size());
        }
    }

    private void setCoinsData(String pid, SolrTransactionDetail std, Session d1Session) {
        if (pid != null) {
            std.setCoins(solrSearcher.getCoinsData(pid, d1Session));
        }
    }

    private String removePidFromFileUrl(String fileURL) {
        int resolveIndex = fileURL.indexOf(Constants.RESOURCE_RESOLVE);
        resolveIndex += Constants.RESOURCE_RESOLVE.length() + 1;
        fileURL = fileURL.substring(0, resolveIndex);
        return fileURL;
    }

    /**
     * Xslt text2.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     * 
     *             modified 10/2011 add switch logic for full page transforms
     *             jmg
     */
    public ModelAndView xsltText2(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        Session d1Session = registerD1Session(request);
        request.setCharacterEncoding("UTF-8");
        HttpSession session = null;
        session = request.getSession(true);

        String urlStr = "";
        StringBuffer htmlContent = new StringBuffer();
        BufferedReader in = null;

        HashMap anchHash = new HashMap();
        Search_Terms st = new Search_Terms();
        String Contents2 = "";
        SolrTransactionDetail std = new SolrTransactionDetail();
        String source = "";
        String solrdb = "";

        request.setAttribute("browse_tree", "true");
        st = get_base_st(request, response);

        st.setSolrdb(solrdb);
        st.setSource(source);

        // do stuff here specifically for DataOne with transforms
        if ((null != request.getParameter("fileURL"))) {

            String fileURL = getRequestParameter(request.getParameter("fileURL")).trim();
            String pid = getRequestParameter(request.getParameter("pid"));

            String pidLessFileURL = removePidFromFileUrl(fileURL);
            String pidEncoded = URLEncoder.encode(pid, "UTF-8");
            fileURL = pidLessFileURL + pidEncoded;

            StringBuffer htmlContent2 = new StringBuffer();

            D1DocTransferObject metadata = solrSearcher.getD1DocInfo(pid, d1Session);
            metadata.getResourceMaps();
            std.setPid(pid);
            std.setResourceMaps(metadata.getResourceMaps());

            setCoinsData(pid, std, d1Session);

            String formatId = getFormatId(d1Session, pid);

            // added by zzr
            std.setFileurl(fileURL);
            session.setAttribute("xsltfileURL", fileURL);// added by zzr

            try {
                if (null != request.getParameter("full_datasource")) {

                    String fds = getRequestParameter(request.getParameter("full_datasource"));

                    /* Adding to get the datasource code from MTM */
                    // System.out.println("fds>>"+ fds);
                    if (getDatasourceMap().containsKey(fds)) {
                        std.setDatasourceCode((getDatasourceMap().get(fds)));
                    }
                    std.setDatasource(getRequestParameter(request.getParameter("full_datasource")));
                    Contents2 = fileURL;

                    std.setContents(Contents2);
                    std.setFull_queryString(st.getFull_queryString());
                    std.setSortattribute(st.getSortattribute());

                    try {
                        std.setFileName(fileURL);
                        in = fetchD1Doc(fileURL, d1Session);
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            htmlContent.append(inputLine);
                        }
                        std.setContents(htmlContent.toString());
                    } catch (Exception ex) {
                        System.err.println("IOException caught...");
                        ex.printStackTrace();
                        std.setErrorMsg("Error connecting to mapped drive. ");
                        String message = "Error connecting to mapped drive in XSLText2. . ";
                        mail(message, ex);

                        return new ModelAndView("myview", "std", std);
                    }
                    // ////////////// new code 11092010 jmg
                    // //////////////////////////////////////////////
                    if ((null != fileURL) && (fileURL.length() > 0)
                            && (fileURL.trim().contains("http"))) {
                        try {
                            // in = fetchD1Doc(fileURL);
                            // String inputLine;
                            // while ((inputLine = in.readLine()) != null) {
                            // htmlContent2.append(inputLine);
                            // }
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            System.out.println("URL Error: '" + urlStr + "' e=" + ex.getMessage());
                            std.setErrorMsg("Error connecting to file as resource. ");
                            String message = "Error connecting to file as resource in XSLText2. ";
                            mail(message, ex);

                            return new ModelAndView("myview", "std", std);
                        }

                        int startBodyIndex = htmlContent2.indexOf("<!--BODY-->");
                        if (startBodyIndex != -1) {
                            htmlContent.delete(0, startBodyIndex);
                        }
                        int endBodyIndex = htmlContent.indexOf("<!--/BODY-->");
                        if (endBodyIndex != -1) {
                            htmlContent.delete(endBodyIndex + 12, htmlContent.length());
                        }
                        String xsltFileName = xsltMapBean.get(formatId);
                        std.setContents(htmlContent.toString());
                        std.setXsltFileName(xsltFileName);

                    }
                    if (session.getAttribute("instance").toString().equalsIgnoreCase("ornldaac")
                            || session.getAttribute("instance").toString().equalsIgnoreCase("nbii")) {
                        try {
                            GetAnchors getAnch = new GetAnchors();

                            anchHash = getAnch.getAnchors(Contents2.substring(2));
                            session.setAttribute("anchors", anchHash);
                        } catch (Exception e) {
                            e.printStackTrace();
                            System.out
                                    .println("Failed trying to get anchor tags from full page -- inside xsltText2");
                        }
                    }

                } else {
                    std.setErrorMsg("Error: full_datasource not specified. ");
                    String message = "Error: full_datasource not specified in XSLText2.. ";
                    mail(message);

                    return new ModelAndView("myview", "std", std);
                }

                String fileId = getRequestParameter(request.getParameter("ds_id"));
                session.setAttribute("fileid", fileId);
                std.setFileId(fileId);

                std.setFull_queryString(st.getFull_queryString());// 1009
                if (!debug) {
                    try {
                        UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                        userStatUtil.populateUserStatDB(request, response, std, "MercuryFullPage",
                                st, term1Map, termMap, psi);
                    } catch (Throwable ex) {
                        System.err.println("Initial SessionFactory creation failed." + ex);
                        throw new ExceptionInInitializerError(ex);
                    }
                }

                return new ModelAndView(fullViewPage, "std", std);
            } catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("fileURL Error calling ia.streamContentsbyID fileURL = > "
                        + fileURL);
                std.setErrorMsg("Probable Error parsing retrieved xml. ");
                String message = "Probable Error parsing retrieved xml in XSLText2.. ";
                mail(message, ex);
                return new ModelAndView("myview", "std", std);
            }

        } else {
            std.setErrorMsg("Error: no fileURL specified. ");
            String message = "Error: no fileURL specified in XSLText2... ";
            mail(message);
            return new ModelAndView("myview", "std", std);
        }
    }

    private String getFormatId(Session d1Session, String pid) {
        String formatId = null;
        if (pid != null) {
            D1DocTransferObject d1Doc = solrSearcher.getD1DocInfo(pid, d1Session);
            formatId = d1Doc.getFormatId();
        }
        return formatId;
    }

    /**
     * @param message
     *            Local error message.
     * @param ex
     *            Throwable object caught as exception. Used to send stacktrace.
     */
    private void mail(String message, Throwable ex) {
        Writer result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        ex.printStackTrace(printWriter);

        mail(message + "\n\n" + result.toString());
    }

    /**
     * @param message
     *            Complete Text error message to embed as body of email.
     */
    private void mail(String message) {
        ServletContext servletContext = getServletContext();
        String WebAppRoot = servletContext.getInitParameter(WebUtils.WEB_APP_ROOT_KEY_PARAM)
                .replace("3.root", "");
        try {
            EmailGenerator.sendTextMail(toEMAIL, WebAppRoot.toUpperCase() + " Controller Error",
                    message, fromEMAIL);
        } catch (Exception exc) {
            exc.printStackTrace();

        }

    }

    /**
     * Referral re direct.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * @param solrTransactionDetail
     *            the solr transaction detail
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView referralReDirect(HttpServletRequest request, HttpServletResponse response,
            SolrTransactionDetail solrTransactionDetail) throws Exception {
        HttpSession session = null;
        session = request.getSession(true);
        Search_Terms st = new Search_Terms();
        HashMap anchors = new HashMap();
        if (!debug && (request.getParameter("url") != null)) {
            try {
                anchors = ((HashMap) session.getAttribute("anchors"));
                String ReferralURL = getRequestParameter(request.getParameter("url")).trim();
                System.out.println("ReferralURL" + ReferralURL);
                if (anchors != null) {
                    for (int i = 0; i < anchors.size(); i++) {
                        if (anchors.get(i).toString().contains(ReferralURL.substring(0, 10))) { // substring
                                                                                                // is
                                                                                                // placed
                                                                                                // because
                                                                                                // of
                                                                                                // special
                                                                                                // characters
                            UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                            userStatUtil.populatereferralDB(request, response, psi);
                            System.out.println("ReferralURL " + ReferralURL);
                            return new ModelAndView(new RedirectView(ReferralURL));

                        }
                    }
                }

            } catch (Throwable ex) {
                System.err.println("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }

        return new ModelAndView("error");

    }

    /**
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return A Spring Framework ModelAndView object, containing the formatted
     *         response.
     * @throws Exception
     */

    /*
     * 
     * public ModelAndView opensearch(HttpServletRequest request,
     * HttpServletResponse response) throws Exception { boolean stSetupError =
     * false;
     * 
     * if((null ==
     * request.getQueryString())||(!(request.getQueryString().trim().
     * length()>0))){ stSetupError = true; }
     * 
     * SolrTransactionServices solrTransactionServices = new
     * SolrTransactionServices(); Search_Terms st = new Search_Terms(); st =
     * get_base_st(request, response);
     * 
     * HashMap<String, String[]> m1 = (HashMap<String, String[]>)
     * request.getParameterMap();
     * 
     * String _query =""; String _start =""; String _pageSize =""; String
     * _sortattribute =""; String _stylesheet ="";
     * 
     * try{
     * 
     * _query =m1.get("query")[0]; _start =m1.get("start")[0]; _pageSize
     * =m1.get("pageSize")[0]; _sortattribute =m1.get("sortattribute")[0];
     * _stylesheet =m1.get("stylesheet")[0];
     * 
     * if((_query.trim().length()>0)&& (_start.trim().length()>0)&&
     * (_pageSize.trim().length()>0)&& (_sortattribute.trim().length()>0)&&
     * (_stylesheet.trim().length()>0)){
     * 
     * st.setFeedValue(_stylesheet); st.setStart(Integer.parseInt(_start));
     * st.setSortattribute(_sortattribute);
     * st.setPageSize(Integer.parseInt(_pageSize)); Terms term1 = new Terms();
     * term1.setValue(_query); term1.setAttribute("fullText");
     * st.setTerm1(term1); }else{ stSetupError = true; }
     * 
     * }catch(Exception exc){ exc.printStackTrace(); stSetupError = true; }
     * 
     * st.setRSS(true);
     * 
     * SolrTransactionDetail solrTransactionDetail = new
     * SolrTransactionDetail(); if(!stSetupError){ solrTransactionDetail =
     * solrTransactionServices.getSolrTransactionDetail(st); return new
     * ModelAndView("rss", "solrTransactionDetail", solrTransactionDetail);
     * }else { return new ModelAndView("openError", "solrTransactionDetail",
     * solrTransactionDetail); }
     * 
     * 
     * 
     * }
     */

    /**
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * @param esip
     *            command bean with the request params
     * 
     * @return A Spring Framework ModelAndView object, containing the formatted
     *         response.
     * @throws Exception
     */
    public ModelAndView esip_opensearch(HttpServletRequest request, HttpServletResponse response,
            EsipOpenSearchBean esip) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean stSetupError = false;
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<EsipOpenSearchBean>> violations = validator.validate(esip);
        for (ConstraintViolation<EsipOpenSearchBean> violation : violations) {
            stSetupError = true;
            String propertyPath = violation.getPropertyPath().toString();
            String message = violation.getMessage();
            System.out.println("Invalid value for: '" + propertyPath + "': " + message);
            sb.append(message + " ");
        }

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        Search_Terms st = new Search_Terms();
        st = get_base_st(request, response);

        if (!stSetupError) {

            try {

                Geo geo = new Geo();
                if (geo.setbounds(esip.getOsLocation())) {
                    Terms spatial = new Terms();
                    spatial.setAttribute("OVERLAPS");// NSEW
                    spatial.setOperation(" AND ");
                    spatial.setValue(esip.getOsLocation());
                    st.setTerm3(spatial);
                } else {
                    stSetupError = true;
                }

                if (esip.getStartTime().length() > 0) {
                    Terms temporal1 = new Terms();
                    temporal1.setAttribute("beginDate");
                    temporal1.setOperation("during");
                    temporal1.setValue(esip.getStartTime());
                    st.setTerm4(temporal1);
                }

                if (esip.getEndTime().length() > 0) {
                    Terms temporal2 = new Terms();
                    temporal2.setAttribute("endDate");
                    temporal2.setOperation("during");
                    temporal2.setValue(esip.getEndTime());
                    st.setTerm5(temporal2);
                }

                st.setFeedValue(esip.getStylesheet());
                st.setStart(Integer.parseInt(esip.getPage()));
                st.setSortattribute(esip.getSortattribute());
                st.setPageSize(Integer.parseInt(esip.getCount()));
                Terms term1 = new Terms();
                term1.setValue(esip.getKeyword());
                term1.setAttribute("fullText");
                st.setTerm1(term1);

            } catch (Exception exc) {
                exc.printStackTrace();
                stSetupError = true;
            }
        }
        st.setRSS(true);
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        solrTransactionDetail.setErrorMsg(sb.toString());
        if (!stSetupError) {
            solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, null);
            return new ModelAndView("rss", "solrTransactionDetail", solrTransactionDetail);
        } else {
            return new ModelAndView("openError", "solrTransactionDetail", solrTransactionDetail);
        }
    }

    /**
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * @param opensearch
     *            command bean with the validated request params
     * 
     * @return A Spring Framework ModelAndView object, containing the formatted
     *         response.
     * @throws Exception
     */

    public ModelAndView opensearch(HttpServletRequest request, HttpServletResponse response,
            OpenSearchBean opensearch) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean stSetupError = false;
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<OpenSearchBean>> violations = validator.validate(opensearch);
        for (ConstraintViolation<OpenSearchBean> violation : violations) {
            stSetupError = true;
            String propertyPath = violation.getPropertyPath().toString();
            String message = violation.getMessage();
            System.out.println("Invalid value for: '" + propertyPath + "': " + message);
            sb.append(message + " ");
        }

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        Search_Terms st = new Search_Terms();

        if (!stSetupError) {
            st = get_base_st(request, response);
            try {

                Geo geo = new Geo();
                if (null != opensearch.getOsLocation()) {
                    if ((opensearch.getOsLocation().length() > 7)
                            && (geo.setbounds(opensearch.getOsLocation()))) {
                        Terms spatial = new Terms();
                        spatial.setAttribute("OVERLAPS");// NSEW
                        spatial.setOperation(" AND ");
                        spatial.setValue(opensearch.getOsLocation());
                        st.setTerm3(spatial);
                    } else {
                        stSetupError = true;
                    }
                }

                if ((null != opensearch.getStartTime()) && (opensearch.getStartTime().length() > 0)) {
                    Terms temporal1 = new Terms();
                    temporal1.setAttribute("beginDate");
                    temporal1.setOperation("during");
                    temporal1.setValue(opensearch.getStartTime());
                    st.setTerm4(temporal1);
                }

                if ((null != opensearch.getEndTime()) && (opensearch.getEndTime().length() > 0)) {
                    Terms temporal2 = new Terms();
                    temporal2.setAttribute("endDate");
                    temporal2.setOperation("during");
                    temporal2.setValue(opensearch.getEndTime());
                    st.setTerm5(temporal2);
                }

                if ((null != opensearch.getStylesheet())
                        && (opensearch.getStylesheet().length() > 0)) {
                    st.setFeedValue(opensearch.getStylesheet());
                } else {
                    stSetupError = true;
                }

                st.setStart(Integer.parseInt(opensearch.getStart()));
                st.setSortattribute(opensearch.getSortattribute());
                st.setPageSize(Integer.parseInt(opensearch.getPageSize()));
                Terms term1 = new Terms();
                term1.setValue(opensearch.getQuery());
                term1.setAttribute("fullText");
                st.setTerm1(term1);

            } catch (Exception exc) {
                exc.printStackTrace();
                stSetupError = true;
            }
        }
        st.setRSS(true);
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        solrTransactionDetail.setErrorMsg(sb.toString());
        if (!stSetupError) {
            solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, null);
            return new ModelAndView("rss", "solrTransactionDetail", solrTransactionDetail);
        } else {
            return new ModelAndView("openError", "solrTransactionDetail", solrTransactionDetail);
        }
    }

    /**
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * @param opensearch
     *            command bean with the validated request params
     * 
     * @return A Spring Framework ModelAndView object, containing the formatted
     *         response.
     * @throws Exception
     */

    public ModelAndView lpdaac_granule_opensearch(HttpServletRequest request,
            HttpServletResponse response, OpenSearchBean opensearch) throws Exception {

        JSONML jsm = new JSONML();
        String basicData = "";
        StringBuilder sb = new StringBuilder();
        boolean stSetupError = false;
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<OpenSearchBean>> violations = validator.validate(opensearch);
        for (ConstraintViolation<OpenSearchBean> violation : violations) {
            stSetupError = true;
            String propertyPath = violation.getPropertyPath().toString();
            String message = violation.getMessage();
            System.out.println("Invalid value for: '" + propertyPath + "': " + message);
            sb.append(message + " ");
        }

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        Search_Terms st = new Search_Terms();

        if (!stSetupError) {
            st = get_base_st(request, response);
            try {

                Geo geo = new Geo();
                if (null != opensearch.getOsLocation()) {
                    if ((opensearch.getOsLocation().length() > 7)
                            && (geo.setbounds(opensearch.getOsLocation()))) {
                        Terms spatial = new Terms();
                        spatial.setAttribute("OVERLAPS");// NSEW
                        spatial.setOperation(" AND ");
                        spatial.setValue(opensearch.getOsLocation());
                        st.setTerm3(spatial);
                    } else {
                        stSetupError = true;
                    }
                }

                if ((null != opensearch.getDatasource())
                        && (opensearch.getDatasource().length() > 0)) {
                    Terms source1 = new Terms();
                    source1.setAttribute("datasource");
                    source1.setOperation(" OR ");
                    source1.setValue(opensearch.getDatasource());
                    st.setTerm6(source1);
                }

                if ((null != opensearch.getStartTime()) && (opensearch.getStartTime().length() > 0)) {
                    Terms temporal1 = new Terms();
                    temporal1.setAttribute("beginDate");
                    temporal1.setOperation("during");
                    temporal1.setValue(opensearch.getStartTime());
                    st.setTerm4(temporal1);
                }

                if ((null != opensearch.getEndTime()) && (opensearch.getEndTime().length() > 0)) {
                    Terms temporal2 = new Terms();
                    temporal2.setAttribute("endDate");
                    temporal2.setOperation("during");
                    temporal2.setValue(opensearch.getEndTime());
                    st.setTerm5(temporal2);
                }

                if ((null != opensearch.getStylesheet())
                        && (opensearch.getStylesheet().length() > 0)) {
                    st.setFeedValue(opensearch.getStylesheet());
                } else {
                    stSetupError = true;
                }

                st.setStart(Integer.parseInt(opensearch.getStart()));
                st.setSortattribute(opensearch.getSortattribute());
                st.setPageSize(Integer.parseInt(opensearch.getPageSize()));
                Terms term1 = new Terms();
                term1.setValue(opensearch.getQuery());
                term1.setAttribute("fullText");
                st.setTerm1(term1);

            } catch (Exception exc) {
                exc.printStackTrace();
                stSetupError = true;
            }
        }
        st.setRSS(true);
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        solrTransactionDetail.setErrorMsg(sb.toString());

        if (!stSetupError) {
            solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, null);

            basicData = jsm.toJSONArray(solrTransactionDetail.getRes().getRss1()).toString();

            return new ModelAndView("lpdaac_geo_model", "solrTransactionDetail",
                    solrTransactionDetail);
        } else {
            return new ModelAndView("openError", "solrTransactionDetail", solrTransactionDetail);
        }
    }

    /**
     * Process rss.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView processRss(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        boolean stSetupError = false;
        if ((null == request.getQueryString()) || (!(request.getQueryString().trim().length() > 0))) {
            stSetupError = true;
        }
        String feed = "";

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        Search_Terms st = new Search_Terms();
        st = get_base_st(request, response);
        st.setRSS(true);
        if ((!(null == request.getParameter("feed")) && (request.getParameter("feed").length() > 0))) {
            feed = getRequestParameter(request.getParameter("feed"));
            st.setFeedValue(feed);

        }
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        st.setPageSize(Integer.parseInt((String) hmProps.get("rssMaxSize")));

        if (!stSetupError) {
            solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, null);
        }

        return new ModelAndView("rss", "solrTransactionDetail", solrTransactionDetail);

    }

    /**
     * Echo OpenSearch.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView echoOpenSearch(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        List entries = null;
        SyndFeed sf = null;
        Logger logger = Logger.getLogger("gov.ornl.mercury3.web.*");
        String logfile = "echo_opensearch_response.log";
        SimpleLayout layout = new SimpleLayout();
        FileAppender appender = null;

        Calendar now;
        SimpleDateFormat formatter = new SimpleDateFormat("mm/dd/yyyy");
        SimpleDateFormat sdfDestination = new SimpleDateFormat("yyyy-mm-dd");
        try {
            appender = new FileAppender(layout, logfile, true);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        logger.addAppender(appender);
        logger.setLevel((Level) Level.DEBUG);
        logger.setAdditivity(false);

        long startTime = System.currentTimeMillis();
        String echofeed = "";
        String clientID = "mercury";
        String maxResults = "10";
        String atomCursor = "";
        String atomStartTime = "1900-05-04T00:00:00-04:00";
        String atomEndTime = "2011-05-04T00:00:00-04:00";
        String numberOfResults = "";
        String shortName = "";
        String versionId = "";
        String dataCenter = "";
        String atomfeed = "";
        String boundingBox = "-180.0,-90.0,180.0,90.0";
        Date StartTimedate = null; // converted dates
        Date EndTimedate = null; // converted dates

        String hreflink, imglink, link = null;
        boolean stSetupError = false;
        echofeed = (String) hmProps.get("echofeed");
        clientID = (String) hmProps.get("clientID");

        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        ArrayList<HashMap<String, Object>> al = new ArrayList<HashMap<String, Object>>();

        if (!(null == echofeed)) {

            if ((!(null == request.getParameter("shortName")))
                    && (request.getParameter("shortName").length() > 0)) {
                shortName = getRequestParameter(request.getParameter("shortName"));
            } else {
                shortName = "";
            }
            if ((!(null == request.getParameter("versionId")))
                    && (request.getParameter("versionId").length() > 0)) {
                versionId = getRequestParameter(request.getParameter("versionId"));
            } else {
                versionId = "";
            }
            if ((!(null == request.getParameter("dataCenter")))
                    && (request.getParameter("dataCenter").length() > 0)) {
                dataCenter = getRequestParameter(request.getParameter("dataCenter"));
            } else {
                dataCenter = "";
            }
            if ((!(null == request.getParameter("atomCursor")))
                    && (request.getParameter("atomCursor").length() > 0)) {
                atomCursor = getRequestParameter(request.getParameter("atomCursor"));
            } else {
                atomCursor = "";
            }
            if ((!(null == request.getParameter("startTime")))
                    && (request.getParameter("startTime").length() > 0)) {

                atomStartTime = getRequestParameter(request.getParameter("startTime"));
                StartTimedate = formatter.parse(atomStartTime);
                atomStartTime = sdfDestination.format(StartTimedate);
            } else {
                atomStartTime = "";
            }
            if ((!(null == request.getParameter("endTime")))
                    && (request.getParameter("endTime").length() > 0)) {
                atomEndTime = getRequestParameter(request.getParameter("endTime"));
                EndTimedate = formatter.parse(atomEndTime);
                atomEndTime = sdfDestination.format(EndTimedate);

            } else {
                atomEndTime = "";
            }
            if ((!(null == request.getParameter("numberOfResults")))
                    && (request.getParameter("numberOfResults").length() > 0)) {
                numberOfResults = request.getParameter("numberOfResults");
            } else {
                numberOfResults = "";
            }

            if ((!(null == request.getParameter("boundingBox")))
                    && (request.getParameter("boundingBox").length() > 0)) {
                boundingBox = request.getParameter("boundingBox");
            } else {
                boundingBox = "";
            }

            Iterator itr = null;
            try {
                atomfeed = echofeed + "clientId=" + clientID + "&shortName=" + shortName
                        + "&versionId=" + versionId + "&dataCenter=" + dataCenter + "&boundingBox="
                        + boundingBox + "&startTime=" + atomStartTime + "&endTime=" + atomEndTime
                        + "&numberOfResults=" + numberOfResults + "&cursor=" + atomCursor;
                URL feedUrl = new URL(atomfeed);
                System.out.println("feedUrl " + feedUrl);
                SyndFeedInput input = new SyndFeedInput();
                try {

                    XmlReader resp = new XmlReader(feedUrl);

                    sf = input.build(resp);
                    entries = sf.getEntries();
                    itr = entries.iterator();

                    while (itr.hasNext()) {
                        HashMap bind = new HashMap();
                        SyndEntry entry = (SyndEntry) itr.next();
                        if (entry.getTitle() != null) {
                            bind.put("title", entry.getTitle());
                        }
                        List links = entry.getLinks();
                        Iterator it2 = links.iterator();
                        while (it2.hasNext()) {
                            link = it2.next().toString();
                            if (link.contains(".hdf")) {
                                hreflink = link
                                        .substring(link.indexOf("SyndLinkImpl.href="),
                                                link.indexOf(".hdf"))
                                        .replaceAll("SyndLinkImpl.href=", "").concat(".hdf");
                                bind.put("link", hreflink);
                            }
                            if (link.contains(".jpg")) {
                                imglink = link
                                        .substring(link.indexOf("SyndLinkImpl.href="),
                                                link.indexOf(".jpg"))
                                        .replaceAll("SyndLinkImpl.href=", "").concat(".jpg");
                                bind.put("imglink", imglink);
                            }
                        }
                        SyndContent description = entry.getDescription();
                        bind.put("desc", description.getValue());
                        al.add(bind);
                    }
                    solrTransactionDetail.setBriefResList(al);

                } catch (Exception exc) {
                    logger.debug("\nEcho Response error " + exc.getCause());

                }
            } catch (IOException IOE) {
            }
        } else {
            stSetupError = true;
        }

        if (!stSetupError) {
            System.out.println("Model: " + solrTransactionDetail);
            long finishTime = System.currentTimeMillis();
            long elapsedTime = finishTime - startTime;

            logger.debug("\nEcho Open Search took " + elapsedTime + " ms for " + numberOfResults
                    + " Records requested.   \t" + entries);

            return new ModelAndView("opensearchresults", "solrTransactionDetail",
                    solrTransactionDetail);
        } else {
            long finishTime = System.currentTimeMillis();
            long elapsedTime = finishTime - startTime;

            logger.debug("\nEcho Open Search errored out in  " + elapsedTime + " ms for "
                    + numberOfResults + " Records requested.   \n" + entries);

            return new ModelAndView("myview");
        }
    }

    /**
     * Process custom rss.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView processCustomRss(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        ApplicationContext xf = new ClassPathXmlApplicationContext(
                "gov/ornl/mercury3/services/facets.xml");

        ArrayList sourcelist = new ArrayList();

        Solr_datasource sd = new Solr_datasource();
        boolean stSetupError = false;

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();

        Search_Terms st = new Search_Terms();

        st = get_base_st(request, response);

        st.setHideDS("false");
        st.setRSS(true);
        String feed = "";

        if ((!(null == request.getParameter("feed")) && (request.getParameter("feed").length() > 0))) {
            feed = getRequestParameter(request.getParameter("feed"));
            st.setFeedValue(feed);

        } else {
            stSetupError = true;
        }

        CustomRssBean crb = (CustomRssBean) xf.getBean(feed + "_customRss");
        HashMap<String, Object> rshm = (HashMap<String, Object>) crb.getCustomRss();
        RssKeywords rsk = (RssKeywords) rshm.get(feed + "_keyword");
        List<String> keywords = rsk.getKeywords();

        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();

        String feed_field_name = feed + "_field";
        String keyword_name = feed + "_keyword";
        String datasource_name = feed + "_datasource";
        String additional_datasource_name = feed + "_additional_datasource";
        String feed_limit_name = feed + "_feed_limit";
        String feed_sort_name = feed + "_sort";

        String feed_field = "";
        String keyword = "";
        String datasource = "";
        String additional_datasource = "";
        String feed_limit = "";
        String feed_sort = "";

        Terms term2 = new Terms();
        Terms term6 = new Terms();

        try {
            StringBuilder sb = new StringBuilder();
            feed_field = (String) rshm.get(feed_field_name);
            datasource = (String) rshm.get(datasource_name);
            additional_datasource = (String) rshm.get(additional_datasource_name);
            feed_limit = (String) rshm.get(feed_limit_name);
            feed_sort = (String) rshm.get(feed_sort_name);
            if (feed_sort.length() < 1) {
                feed_sort = "beginDate";
            }
            if (keywords.size() > 0) {
                Iterator<String> it = keywords.iterator();
                while (it.hasNext()) {
                    sb.append(it.next() + " OR ");
                }
                sb.replace(sb.lastIndexOf("OR"), sb.length(), " ");
                keyword = sb.toString();
            }

        } catch (Exception e) {
            stSetupError = true;
            System.out.println("Exception in trying to read customRssProp values");
            e.printStackTrace();
        }

        try {
            int limit = Integer.parseInt(feed_limit);
            if (limit < 1) {
                limit = 100;
            }
            term2.setAttribute(feed_field);
            term2.setValue(keyword);
            term2.setOperation("AND");
            st.setTerm2(term2);
            st.setPageSize(limit);
            term6.setValue(datasource);
            term6.setAttribute("datasource");
            term6.setOperation(" AND ");
            st.setTerm6(term6);
            st.setSortattribute(feed_sort);

            if (getDatasourceMap().containsKey(additional_datasource)) {
                st.setAdditional_datasource(getDatasourceMap().get(additional_datasource));
            }
        } catch (Exception ex) {
            stSetupError = true;
            System.out.println("Exception in trying to set customRssProp values");
            ex.printStackTrace();
        }

        if (!stSetupError) {
            String[] rss_ds = { datasource };

            if (sd.setDatasourcearray(rss_ds)) {

                if (!(null == sd.getDatasourcearray()) && (sd.getDatasourcearray().length > 0)) {
                    String[] temp = sd.getDatasourcearray();

                    st.setDatasourcearray(temp);

                    for (int x = 0; x < temp.length; x++) {
                        if (getDatasourceMap().containsKey(temp[x])) {
                            sourcelist.add(getDatasourceMap().get(temp[x]));

                        }
                    }

                    st.setDatasources(sourcelist);
                }
            }
            // /////////// Code below for handling term2 array
            // ////////////////////////////

            ArrayList<Terms> al2 = new ArrayList<Terms>();
            String temp_attr = "";

            for (String str : keywords) {
                Terms tkeyword2 = new Terms();
                tkeyword2.setOperation(" OR ");
                tkeyword2.setValue("\"" + str + "\"");
                tkeyword2.setAttribute(feed_field);
                al2.add(tkeyword2);
            }

            st.setTerm2_list(al2);
            // /////////// Code above for handling term2 array
            // ////////////////////////////
            st.setSortattribute(feed_sort);
            solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, null);
        }

        return new ModelAndView("rss", "solrTransactionDetail", solrTransactionDetail);

    }

    /**
     * Process custom mlt.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return SpringFramework ModelAndView object
     * 
     * @throws Exception
     *             the exception
     */
    public ModelAndView processCustomMLT(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        Session d1Session = registerD1Session(request);
        String refererm = "";

        HttpSession session = request.getSession();

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        Search_Terms st = new Search_Terms();
        st = get_base_st(request, response);
        st.setHideDS("false");
        st.setMLT(true);

        HashMap<String, String[]> m1 = (HashMap<String, String[]>) request.getParameterMap();
        st.setMlt_request_terms(m1);
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();
        solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, d1Session);

        solrTransactionDetail.setBrowseStatus("true");

        synchronized (session) {
            if (session.getAttribute("refererm") == null) {
                refererm = request.getHeader("referer");
                session.setAttribute("refererm", refererm);
            }

        }

        if (!debug) {
            try {
                UserStatUtil_2 userStatUtil = new UserStatUtil_2();
                userStatUtil.populateUserStatDB(request, response, solrTransactionDetail,
                        "MercuryMoreLikeThis", st, term1Map, termMap, psi);
            } catch (Throwable ex) {
                System.err.println("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }
        // setD1DataPackageInfo(solrTransactionDetail, d1Session);
        setMemberNodeDescriptionField(solrTransactionDetail);
        return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);

    }

    public ModelAndView multiple_facets(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();

        Search_Terms st = new Search_Terms();

        st = get_base_st(request, response);
        st.setRSS(true);

        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();

        // String AllFacets = request.getParameter("facetattribute");
        String AllFacets[] = request.getParameterValues("facetattribute");
        // Map s=null;
        for (int i = 0; i < AllFacets.length; i++) {
            // System.out.println(AllFacets[i]);
            if (AllFacets[i].startsWith("parameter")) {
                System.out.println("facetattribute1= parameter");
                System.out.println("facet1value"
                        + " ="
                        + AllFacets[i].subSequence(AllFacets[i].indexOf(":") + 1,
                                AllFacets[i].length()));
            }
            if (AllFacets[i].startsWith("sensor")) {
                System.out.println("facetattribute2= sensor");
                System.out.println("facet2value"
                        + " ="
                        + AllFacets[i].subSequence(AllFacets[i].indexOf(":") + 1,
                                AllFacets[i].length()));

            }
            if (AllFacets[i].startsWith("topic")) {
                System.out.println("facetattribute3= topic");
                System.out.println("facet3value"
                        + " ="
                        + AllFacets[i].subSequence(AllFacets[i].indexOf(":") + 1,
                                AllFacets[i].length()));

            }
            if (AllFacets[i].startsWith("project")) {
                System.out.println("facetattribute4= project");
                System.out.println("facet4value"
                        + " ="
                        + AllFacets[i].subSequence(AllFacets[i].indexOf(":") + 1,
                                AllFacets[i].length()));

            }
            if (AllFacets[i].startsWith("keywords")) {
                System.out.println("facetattribute5= keywords");
                System.out.println("facet5value"
                        + " ="
                        + AllFacets[i].subSequence(AllFacets[i].indexOf(":") + 1,
                                AllFacets[i].length()));

            }
            if (AllFacets[i].startsWith("investigator")) {
                System.out.println("facetattribute6= investigator");
                System.out.println("facet6value"
                        + " ="
                        + AllFacets[i].subSequence(AllFacets[i].indexOf(":") + 1,
                                AllFacets[i].length()));

            }

        }

        solrTransactionDetail = solrTransactionServices.getSolrTransactionDetail(st, null);

        return new ModelAndView("brief", "solrTransactionDetail", solrTransactionDetail);

    }

    public String getPageNavBar(int tCurPage, int tPageSize, int tRsSize, int tPageCnt,
            String tPrevText, String tNextText, String pageName) {

        tPageCnt = 10;

        String returnVal = "";
        int liStartPage = 1;
        int liStartIndex = 1;
        int liEndPage = 0;
        int liTotalPage = 0;

        liTotalPage = tRsSize / tPageSize;
        if ((tRsSize % tPageSize) != 0)
            liTotalPage++;

        if (tCurPage == 0) {
            liStartPage = 1;
            tCurPage = 1;
        } else {
            liStartPage = tCurPage - (tPageCnt / 2);
            if (liStartPage < 1) {
                liStartPage = 1;
            }
        }

        liEndPage = liStartPage + tPageCnt - 1;
        if (liEndPage > liTotalPage) {
            if (liStartPage - (liEndPage - liTotalPage) >= 1) {
                liStartPage = liStartPage - (liEndPage - liTotalPage);
            }
            liEndPage = liTotalPage;
        }

        if (tCurPage > 1)
            returnVal += "<a href=\""
                    + "../send/results_navigation?nav=prev\"  onClick=\"loadingMes();\">";
        returnVal += tPrevText;
        if (tCurPage > 1)
            returnVal += "</a>";

        returnVal += " ";

        for (int i = liStartPage; i <= liEndPage; i++) {
            if (i == tCurPage)
                returnVal += i + " ";
            else

                returnVal += "<a href=\"" + "../send/results_navigation?page=" + (i)
                        + "&from=brief\"  onClick=\"loadingMes();\">" + i + "</a> ";

        }

        if (tCurPage < liTotalPage)
            returnVal += "<a href=\""
                    + "../send/results_navigation?nav=next\"  onClick=\"loadingMes();\">";

        returnVal += tNextText;
        if (tCurPage < tRsSize)
            returnVal += "</a>";

        return returnVal;
    }

    /**
     * Gets the page nav bar.
     * 
     * @param tCurPage
     *            the t cur page
     * @param tPageSize
     *            the t page size
     * @param tRsSize
     *            the t rs size
     * @param tPageCnt
     *            the t page cnt
     * @param tPrevText
     *            the t prev text
     * @param tNextText
     *            the t next text
     * @param pageName
     *            the page name
     * @param mercury3_query_string
     *            the mercury3_query_string
     * @param st
     *            the st
     * 
     * @return the page nav bar
     */
    public String getPageNavBar(int tCurPage, int tPageSize, int tRsSize, int tPageCnt,
            String tPrevText, String tNextText, String pageName, String mercury3_query_string,
            Search_Terms st) {
        String mercury3_query_string2 = "";

        tPageCnt = 10;

        String returnVal = "";
        int liStartPage = 1;
        int liStartIndex = 1;
        int liEndPage = 0;
        int liTotalPage = 0;

        liTotalPage = tRsSize / tPageSize;
        if ((tRsSize % tPageSize) != 0)
            liTotalPage++;

        if (tCurPage == 0) {
            liStartPage = 1;
            tCurPage = 1;
        } else {
            liStartPage = tCurPage - (tPageCnt / 2);
            if (liStartPage < 1) {
                liStartPage = 1;
            }
        }

        liEndPage = liStartPage + tPageCnt - 1;
        if (liEndPage > liTotalPage) {
            if (liStartPage - (liEndPage - liTotalPage) >= 1) {
                liStartPage = liStartPage - (liEndPage - liTotalPage);
            }
            liEndPage = liTotalPage;
        }

        int cp = st.getCurrent_page();
        int num_pages = st.getNum_pages();
        int s = 0;
        int ps = st.getPageSize();
        if ((cp > 0) && (!(cp > num_pages))) {
            s = (cp - 1) * ps;
            st.setCurrent_page(cp);
            st.setStart(s);
        }

        try {
            mercury3_query_string2 = build_base_request(st);

        } catch (Exception exn) {
            exn.printStackTrace();
        }

        if (tCurPage > 1)
            returnVal += "<a href=\"" + "../send/results_navigation2?" + mercury3_query_string2
                    + "&page=" + (tCurPage - 1) + "&from=brief\"  onClick=\"loadingMes();\">";
        returnVal += tPrevText;
        if (tCurPage > 1)
            returnVal += "</a>";

        returnVal += " ";

        for (int i = liStartPage; i <= liEndPage; i++) {
            if (i == tCurPage)
                returnVal += i + " ";
            else

                returnVal += "<a href=\"" + "../send/results_navigation2?" + mercury3_query_string2
                        + "&page=" + (i) + "&from=brief\"  onClick=\"loadingMes();\">" + i
                        + "</a> ";

        }

        if (tCurPage < liTotalPage)
            returnVal += "<a href=\"" + "../send/results_navigation2?" + mercury3_query_string2
                    + "&page=" + (tCurPage + 1) + "&from=brief\"  onClick=\"loadingMes();\">";

        returnVal += tNextText;
        if (tCurPage < tRsSize)
            returnVal += "</a>";

        return returnVal;
    }

    /**
     * Nu_get_base_st.
     * 
     * @param request
     *            the HttpServletRequest
     * @param PathInfo
     *            the path info
     * 
     * @return the array list
     * 
     * @throws Exception
     *             the exception
     */
    public ArrayList nu_get_base_st(HttpServletRequest request, String PathInfo) throws Exception {
        request.setCharacterEncoding("UTF-8");
        ArrayList<Terms> al2 = new ArrayList<Terms>();
        String temp_attr = "";
        HashMap<String, String[]> t2_map = new HashMap<String, String[]>();
        HashMap<String, String> t2_pair_map = new HashMap<String, String>();
        HashMap<String, String[]> pm = (HashMap<String, String[]>) request.getParameterMap();

        LinkedHashMap<String, String[]> lhm = new LinkedHashMap<String, String[]>();

        String temp_key = "";
        String attribute_key = "";
        String tmp2 = "";
        String tmp2a = "";
        String tmp_op = "";
        String op_key = "";
        String tmp2a2 = "";
        ArrayList keys = new ArrayList();
        keys.addAll(pm.keySet());
        Collections.sort(keys);

        for (Iterator pmit0 = keys.iterator(); pmit0.hasNext();) {
            temp_key = (String) pmit0.next();
            if (temp_key.contains("term2")) {
                lhm.put(temp_key, pm.get(temp_key));
            }
        }

        for (Iterator pmit = lhm.keySet().iterator(); pmit.hasNext();) {
            temp_key = (String) pmit.next();
            attribute_key = temp_key + "attribute";
            if (temp_key.contains("term2")) {
                t2_map.put(temp_key, pm.get(temp_key));
                if (!(temp_key.contains("attribute")) && (null != pm.get(attribute_key))
                        && (pm.get(attribute_key).length > 0)) {
                    op_key = "op" + temp_key.substring(4);
                    t2_pair_map.put(pm.get(temp_key)[0], pm.get(attribute_key)[0]);
                    tmp2 = pm.get(temp_key)[0];

                    // no point in more processing if there is no data. so test
                    // for tmp2 empty
                    if ((tmp2 != null) && (tmp2.trim().length() > 0)) {

                        temp_attr = termMap.get(pm.get(attribute_key)[0]);// change

                        if ((null != pm.get(op_key)) && (pm.get(op_key).length > 0)) {
                            tmp_op = pm.get(op_key)[0];
                        } else {
                            tmp_op = " AND ";
                        }

                        Terms tkeyword2 = new Terms();
                        tkeyword2.setValue(tmp2);
                        tkeyword2.setAttribute(temp_attr);
                        tkeyword2.setOperation(tmp_op);

                        if ((temp_attr != null) && (temp_attr.trim().length() > 0)) {
                            if ((temp_attr.trim().equalsIgnoreCase("fullText"))
                                    || (temp_attr.trim().equalsIgnoreCase("text"))) {
                                tkeyword2.setAttribute("text");
                                if (tmp2.trim().equalsIgnoreCase("*")) {

                                    /**
                                     * Remove workaround for solr leading
                                     * wildcards jmg 10/22/2010
                                     */

                                    /*
                                     * tmp2a = "a" + tmp2; tmp2a2 = "a" + tmp2;
                                     */
                                    tmp2a = tmp2;
                                    tmp2a2 = tmp2;

                                } else if (PathInfo.trim().endsWith("query")) {

                                    Mercury3_EditBoxParser parser2 = new Mercury3_EditBoxParser(
                                            tmp2, temp_attr.trim());

                                    List<Tokenz> ltz2 = parser2.parseSearchText_adv();
                                    tmp2a2 = parser2.getStringwithBools(ltz2);
                                } else {
                                    tmp2a2 = tmp2;
                                }
                            } else if (PathInfo.trim().endsWith("query")) {

                                Mercury3_EditBoxParser parser2 = new Mercury3_EditBoxParser(tmp2,
                                        temp_attr.trim());

                                List<Tokenz> ltz2 = parser2.parseSearchText_adv();
                                tmp2a2 = parser2.getStringwithBools(ltz2);
                            } else {
                                tmp2a2 = tmp2;
                            }
                            tkeyword2.setValue(tmp2a2);
                        }
                        //                        System.out
                        //                                .println("tkeyword2.getValue() ,tkeyword2.getAttribute(), tkeyword2.getOp() => "
                        //                                        + tkeyword2.getValue()
                        //                                        + " , "
                        //                                        + tkeyword2.getAttribute()
                        //                                        + " , " + tkeyword2.getOperation());
                        if (!(null == temp_attr) && (temp_attr.length() > 0)) {
                            al2.add(tkeyword2);
                        }
                        for (int i = 0; i < al2.size(); i++) {
                            Terms tz = al2.get(i);
                            //                            System.out.println(i + " al2 size : " + al2.size() + "  "
                            //                                    + "tz.getValue() ,tz.getAttribute(), tz.getOp() => "
                            //                                    + tz.getValue() + " , " + tz.getAttribute() + " , "
                            //                                    + tz.getOperation());
                        }
                    }
                }
            }
        }
        return al2;
    }

    private String getRequestParameter(String parameter) {
        //        try {
        //            return new String(parameter.getBytes("iso-8859-1"), "UTF-8");
        //        } catch (UnsupportedEncodingException e) {
        //
        //        }
        //        return "";
        return parameter;
    }

    /**
     * Constructs a search_terms object by parsing the request.
     * 
     * @param request
     *            the HttpServletRequest
     * @param response
     *            the HttpServletResponse
     * 
     * @return a populated search_terms object.
     * 
     * @throws Exception
     *             the exception
     */
    public Search_Terms get_base_st(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        String[] facet_array;
        String[] facetattribute_array;
        HashMap hm2 = new HashMap();
        HashMap hm3 = new HashMap();
        // Mercury_term_maps mtm = new Mercury_term_maps();
        StringBuffer sb_uri = request.getRequestURL();

        String PathInfo = request.getPathInfo();
        String nu_url = sb_uri.toString();
        String nu_qry = request.getQueryString();
        String mercury3_query_string = "";// request.getQueryString();

        ArrayList sourcelist = new ArrayList();
        ArrayList sitelist = new ArrayList();

        String nb = "";
        Solr_datasource sd = new Solr_datasource();
        Solr_datasource sites = new Solr_datasource();
        HttpSession session = request.getSession(true);

        ServletContext servletContext = getServletContext();
        String WebAppRoot = servletContext.getInitParameter(WebUtils.WEB_APP_ROOT_KEY_PARAM)
                .replace("3.root", "");

        session.setAttribute("instance", WebAppRoot);
        session.setAttribute("sessioninstance", WebAppRoot);
        String WebAppRoot2 = servletContext.getInitParameter(WebUtils.WEB_APP_ROOT_KEY_PARAM)
                .replace(".root", "");

        SolrTransactionService solrTransactionServices = SolrTransactionServiceFactory
                .getTransactionService();
        SolrTransactionDetail solrTransactionDetail = new SolrTransactionDetail();

        Search_Terms st = new Search_Terms();

        String filterForData = request.getParameter("filterForDataHidden");
        System.out.println("filter for data hidden: " + filterForData);
        if (null == filterForData || StringUtils.isEmpty(filterForData)) {
            st.setFilterForData(defaultFilterDataValue);
        } else {
            st.setFilterForData(Boolean.valueOf(filterForData));
        }

        String Struct = "";
        st.setWebAppRoot(WebAppRoot2);

        if (!(null == request.getParameter("browseStatus"))) {
            String browseStatus = request.getParameter("browseStatus");

            st.setBrowseStatus(browseStatus);
        }

        if ((!(null == request.getParameter("term1attribute")))
                && (!(null == request.getParameter("term1")))) {

            if (term1Map.containsKey(request.getParameter("term1attribute"))) {

                PrintStream out8 = new PrintStream(System.out, true, "UTF-8");

                Terms simple = new Terms();

                simple.setAttribute("text");

                String tmp1 = getRequestParameter(request.getParameter("term1"));
                st.setRawTerm1(tmp1);
                String tmp1a = "";

                out8.println("QUERY STRING IS: " + tmp1);

                if (tmp1.trim().equalsIgnoreCase("*")) {
                    /**
                     * Remove workaround for solr leading wildcards jmg
                     * 10/22/2010
                     */

                    /*
                     * tmp1a = "a" + tmp1;
                     */
                    tmp1a = tmp1;

                } else if ((PathInfo.endsWith("query")) && (tmp1.trim().length() > 0)) {

                    Mercury3_EditBoxParser parser = new Mercury3_EditBoxParser(tmp1, "text");
                    List<Tokenz> ltz = parser.parseSearchText_adv();
                    tmp1a = parser.getStringwithBools(ltz);

                } else {
                    tmp1a = tmp1;
                }

                simple.setValue(tmp1a);

                simple.setOperation(request.getParameter("op1"));
                st.setTerm1(simple);
            }
        }

        ArrayList al2 = nu_get_base_st(request, PathInfo);

        st.setTerm2_list(al2);

        if ((!(null == request.getParameter("term3attribute")))
                && (!(null == request.getParameter("term3")))) {
            Terms spatial = new Terms();
            spatial.setAttribute(request.getParameter("term3attribute"));// NSEW
            spatial.setOperation(request.getParameter("op3"));
            spatial.setValue(getRequestParameter(request.getParameter("term3")));
            st.setTerm3(spatial);
        }

        if ((!(null == request.getParameter("term4attribute")))
                && (!(null == request.getParameter("term4")))) {
            Terms temporal1 = new Terms();
            temporal1.setAttribute(request.getParameter("term4attribute"));
            temporal1.setOperation(request.getParameter("op4"));
            temporal1.setValue(getRequestParameter(request.getParameter("term4")));
            st.setTerm4(temporal1);
        }

        if ((!(null == request.getParameter("term5attribute")))
                && (!(null == request.getParameter("term5")))) {
            Terms temporal2 = new Terms();
            temporal2.setAttribute(request.getParameter("term5attribute"));
            temporal2.setOperation(request.getParameter("op5"));
            temporal2.setValue(getRequestParameter(request.getParameter("term5")));
            st.setTerm5(temporal2);
        }

        SourceObject so = new SourceObject();// jmg

        if ((!(null == request.getParameter("term6attribute")))
                && (!(null == request.getParameter("term6")))) {

            if (sd.setDatasourcearray(request.getParameterValues("term6"))) {

                if (!(null == sd.getDatasourcearray()) && (sd.getDatasourcearray().length > 0)) {
                    String[] temp = sd.getDatasourcearray();

                    st.setDatasourcearray(temp);

                    for (int x = 0; x < temp.length; x++) {
                        if (use_mn_source_cache) {
                            String value = StringUtils.replace(temp[x], "\\:", ":");
                            if (getDatasourceMap().containsKey(value)) {
                                String escapedValue = StringUtils.replace(value, ":", "\\:");
                                sourcelist.add(escapedValue);
                                if (temp[x].equalsIgnoreCase("ALL")) {
                                    so.setDs_all("true");
                                }
                            }
                        } else {
                            if (getDatasourceMap().containsKey(temp[x])) {
                                sourcelist.add(getDatasourceMap().get(temp[x]));
                                if (temp[x].equalsIgnoreCase("ALL")) {
                                    so.setDs_all("true");
                                }
                            }
                        }
                    }
                    so.setT6(sourcelist);
                    st.setDatasources(sourcelist);
                    session.setAttribute("sessionDataSource", sourcelist);
                }
            }
        }
        // Searchmode Only for IABIN
        if ((!(null == request.getParameter("searchmodeAttribute")))
                && (!(null == request.getParameter("searchmode")))) {

            Terms searchmode = new Terms();
            searchmode.setAttribute(request.getParameter("searchmodeAttribute"));
            searchmode.setValue(request.getParameter("searchmode"));
            st.setSearchmode(searchmode);
        }
        // ///////////////////////
        if (!(null == request.getParameterValues("term10"))) {
            if (sites.setDatasourcearray(request.getParameterValues("term10"))) {
                if (!(null == sites.getDatasourcearray())
                        && ((sites.getDatasourcearray()).length > 0)) {
                    String[] temp = sites.getDatasourcearray();
                    sites.setDatasourcearray(temp);
                    for (int x = 0; x < temp.length; x++) {
                        if (temp[x].equalsIgnoreCase("All LTER Sites")) {
                            sourcelist.add(getDatasourceMap().get(temp[x]));
                            st.setDatasources(sourcelist);
                            so.setDs_lter("true");
                        } else if (temp[x].equalsIgnoreCase("All NBII Partner Nodes")) {
                            sourcelist.add(getDatasourceMap().get(temp[x]));
                            // so.setDs_all("true");
                            st.setDatasources(sourcelist);
                        } else if (getDatasourceMap().containsKey((temp[x].trim()))) {
                            sitelist.add(getDatasourceMap().get(temp[x].trim()));
                            // ////////////////////////////////////
                            sourcelist.add(getDatasourceMap().get(temp[x]));
                            st.setDatasources(sourcelist);

                            // /////////////////////////
                        } else if (getDatasourceMap().containsValue(temp[x])) {
                            sitelist.add(temp[x].trim());
                        }
                    }
                    so.setT10(sitelist);
                    st.setLterSites(sitelist);
                }
            }
        }

        // ///////////////////////
        if (!(null == request.getParameterValues("term11"))) {
            ArrayList<String> isitelist = new ArrayList<String>();
            if (sites.setDatasourcearray(request.getParameterValues("term11"))) {
                if (!(null == sites.getDatasourcearray())
                        && ((sites.getDatasourcearray()).length > 0)) {
                    String[] temp = sites.getDatasourcearray();
                    sites.setDatasourcearray(temp);
                    for (int x = 0; x < temp.length; x++) {
                        if (temp[x].equalsIgnoreCase("All iLTER Sites")) {
                            sourcelist.add(getDatasourceMap().get(temp[x]));
                            st.setDatasources(sourcelist);
                            so.setDs_ilter("true");
                        } else {
                            if (getDatasourceMap().containsKey(temp[x])) {
                                isitelist.add(getDatasourceMap().get(temp[x]));
                                // ////////////
                                sourcelist.add(getDatasourceMap().get(temp[x]));
                                st.setDatasources(sourcelist);

                                // /////////////
                            }
                        }
                    }
                    so.setT11(isitelist);
                }
            }
        }

        // /////////////////////////////
        st.setSo(so);

        // ////////////////
        if ((!(null == request.getParameter("term7attribute")))
                && (!(null == request.getParameter("term7")))) {
            if (termMap.containsKey(request.getParameter("term7attribute"))) {
                Terms keyword7 = new Terms();
                keyword7.setAttribute((String) termMap.get(request.getParameter("term7attribute")));
                keyword7.setOperation(" AND ");

                String term7string = getRequestParameter(request.getParameter("term7"));

                keyword7.setValue(term7string);

                st.setTerm7(keyword7);
            }
        }

        if (!(null == request.getParameter("term8"))) {

            Terms keyword8 = new Terms();

            keyword8.setValue(getRequestParameter(request.getParameter("term8")));

            st.setTerm8(keyword8);

        }

        if (!(null == request.getParameter("term9"))) {
            if (termMap.containsKey(request.getParameter("term9attribute"))) {
                Terms keyword9 = new Terms();
                keyword9.setAttribute((String) termMap.get(request.getParameter("term9attribute")));
                keyword9.setOperation(" AND ");

                String term9string = getRequestParameter(request.getParameter("term9"));

                keyword9.setValue(term9string);

                st.setTerm9(keyword9);
            }
        }

        if ((!(null == request.getParameter("term12attribute")))
                && (!(null == request.getParameter("term12")))) {
            if (termMap.containsKey(request.getParameter("term12attribute"))) {
                Terms keyword12 = new Terms();
                keyword12
                        .setAttribute((String) termMap.get(request.getParameter("term12attribute")));
                keyword12.setOperation(" AND ");
                keyword12.setValue(getRequestParameter(request.getParameter("term12"))
                        .toLowerCase());

                st.setTerm12(keyword12);
            }
        }

        if (!(null == request.getParameterValues("sortattribute"))) {

            String[] temp = request.getParameterValues("sortattribute");

            st.setSortattribute(temp[temp.length - 1]);
            st.setSortattribute(temp[temp.length - 1]);
        }
        int t_ps = 0;
        if (!(null == request.getParameter("pageSize"))) {

            try {
                t_ps = Integer.parseInt(request.getParameter("pageSize"));
                st.setPageSize(Integer.parseInt(request.getParameter("pageSize")));
            } catch (NumberFormatException ex) {

                t_ps = 10;
                st.setPageSize(t_ps);
            }

        } else {
            st.setPageSize((Integer.parseInt(("10"))));

        }
        if (!(null == request.getParameter("page"))) {

            int t_page = 1;
            try {
                t_page = Integer.parseInt(request.getParameter("page"));
            } catch (NumberFormatException ex) {

            }

            int t_start = (t_page - 1) * t_ps;
            st.setStart(t_start);
        }

        if (!(null == request.getParameter("queryString"))) {
            st.setGui_queryString(getRequestParameter(request.getParameter("queryString")));
            st.setFull_queryString(getRequestParameter(request.getParameter("queryString")));

        }
        String fqs = "";
        if (!(null == request.getParameter("full_queryString"))) {

            fqs = getRequestParameter(request.getParameter("full_queryString"));

            st.setFull_queryString(fqs);
        }

        if (!(null == request.getParameter("hideDS"))) {
            st.setHideDS(request.getParameter("hideDS"));
        }

        st.setPage_max_count(st.getPageSize());
        int num_pages;
        int pmc = st.getResponses();
        int cp = 1;
        if (st.getPageSize() <= 0) {
            st.setPageSize(10);
        }
        if (st.getResponses() % st.getPageSize() > 0) {
            num_pages = (st.getResponses() / st.getPageSize()) + 1;
        } else {
            num_pages = st.getResponses() / st.getPageSize();
        }

        st.setNum_pages(num_pages);

        if ((st.getResponses() < st.getPageSize()) || (cp == num_pages)) {
            pmc = st.getResponses();
        } else if (cp < num_pages) {
            pmc = cp * st.getPageSize();
        }

        st.setCurrent_page(cp);
        st.setPage_max_count(pmc);
        nb = this.getPageNavBar(1, st.getPageSize(), st.getResponses(), st.getNum_pages(), "Prev",
                "Next", " brief");

        if ((!(null == request.getParameter("facetattribute")))
                && (!(null == request.getParameter("facet")))) {

            facet_array = request.getParameterValues("facet");
            facetattribute_array = request.getParameterValues("facetattribute");

            if ((facet_array.length > 0) && (facet_array.length == facetattribute_array.length)) {
                for (int i = 0; i < facet_array.length; i++) {
                    hm2.put(facetattribute_array[i], getRequestParameter(facet_array[i]));
                    if ((facetattribute_array[i]).equalsIgnoreCase("datasource")) {
                        ArrayList<String> t6a = new ArrayList<String>();
                        if (getDatasourceMap().containsKey(facet_array[i])) {
                            String escapedValue = StringUtils.replace(facet_array[i], ":", "\\:");
                            // t6a.add(datasourceMap.get(facet_array[i]));
                            t6a.add(escapedValue);
                            so.setFacet_ds(getDatasourceMap().get(facet_array[i]));
                            so.setT6(t6a);
                        } else {
                            so.setFacet_ds(getRequestParameter(facet_array[i]));
                        }
                        st.setSo(so);
                    }
                    st.setSo(so);
                }
            }

            if (!(null == request.getParameter("del_facet"))) {
                String[] del_facet_array = request.getParameterValues("del_facet");
                String[] del_facet_array2 = null;
                st.setDel_facet_array(del_facet_array);

                if ((request.getParameter("del_facet")).equalsIgnoreCase("datasource")) {
                    st.setHideDS("false");
                }
                String[] temp = st.getDel_facet_array();
                for (int x = 0; x < temp.length; x++) {
                    if (hm2.containsKey(temp[x])) {
                        hm2.remove(temp[x]);
                        if (("datasource").equalsIgnoreCase(temp[x])) {
                            ArrayList<String> t6a = new ArrayList<String>(sourcelist);
                            so.setT6(t6a);
                            so.setFacet_ds("");
                            st.setSo(so);
                        }
                    }
                }
                st.setSolr_facets_map(hm2);
            }
        }
        if (hm2.size() > 0) {
            st.setSolr_facets_map(hm2);
        }
        mercury3_query_string = build_base_request(st);
        st.setMercury3_query_string(mercury3_query_string);
        return st;
    }

    /**
     * Builds an embeddable querystring from the terms contained in the
     * search_terms object.
     * 
     * @param st
     *            the search terms object
     * 
     * @return an embeddable queerystring
     * 
     * @throws Exception
     */
    public String build_base_request(Search_Terms st) throws Exception {

        final HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);

        final List<NameValuePair> params = new ArrayList<NameValuePair>();

        if (st.getFilterForData()) {
            params.add(new NameValuePair("filterForDataHidden", "true"));
        } else {
            params.add(new NameValuePair("filterForDataHidden", "false"));
        }

        if (!(null == st.getTerm1()) && (!(null == st.getTerm1().getAttribute()))
                && (!(null == st.getTerm1().getValue()))
                && (st.getTerm1().getAttribute().length() > 0)
                && (st.getTerm1().getValue().length() > 0)) {
            params.add(new NameValuePair("term1", st.getTerm1().getValue()));
            params.add(new NameValuePair("term1attribute", "text"));
            params.add(new NameValuePair("op1", st.getTerm1().getOperation()));

        }

        // new for generic term2 handling
        ArrayList alt2 = st.getTerm2_list();
        if (!(null == alt2) && alt2.size() > 0) {
            String val = "term2.";
            String op = "op2.";
            int i = 1;
            for (Iterator pmit = alt2.iterator(); pmit.hasNext();) {
                Terms tl2 = (Terms) pmit.next();
                if (!(null == tl2) && (!(null == tl2.getAttribute()))
                        && (!(null == tl2.getValue())) && (tl2.getAttribute().length() > 0)
                        && (tl2.getValue().length() > 0)) {
                    i++;
                    params.add(new NameValuePair(val + i, tl2.getValue()));
                    params.add(new NameValuePair(val + i + "attribute", tl2.getAttribute()));
                    params.add(new NameValuePair(op + i, tl2.getOperation()));
                }
            }
        }

        if (!(null == st.getTerm3()) && (!(null == st.getTerm3().getAttribute()))
                && (!(null == st.getTerm3().getValue()))
                && (st.getTerm3().getAttribute().length() > 0)
                && (st.getTerm3().getValue().length() > 0)) {
            params.add(new NameValuePair("term3attribute", st.getTerm3().getAttribute()));
            params.add(new NameValuePair("term3", st.getTerm3().getValue()));
            params.add(new NameValuePair("op3", st.getTerm3().getOperation()));

        }

        if (!(null == st.getTerm4()) && (!(null == st.getTerm4().getAttribute()))
                && (!(null == st.getTerm4().getValue()))
                && (st.getTerm4().getAttribute().length() > 0)
                && (st.getTerm4().getValue().length() > 0)) {
            params.add(new NameValuePair("term4", st.getTerm4().getValue()));
            params.add(new NameValuePair("term4attribute", st.getTerm4().getAttribute()));
            params.add(new NameValuePair("op4", st.getTerm4().getOperation()));
        }

        if (!(null == st.getTerm5()) && (!(null == st.getTerm5().getAttribute()))
                && (!(null == st.getTerm5().getValue()))
                && (st.getTerm5().getAttribute().length() > 0)
                && (st.getTerm5().getValue().length() > 0)) {
            params.add(new NameValuePair("term5", st.getTerm5().getValue()));
            params.add(new NameValuePair("term5attribute", st.getTerm5().getAttribute()));
            params.add(new NameValuePair("op5", st.getTerm5().getOperation()));

        }

        if (!(null == st.getDatasources()) && (st.getDatasources().size() > 0)) {

            ArrayList temp_src = st.getDatasources();

            params.add(new NameValuePair("term6attribute", "datasource"));
            params.add(new NameValuePair("op6", " OR "));

            if (temp_src.size() > 0) {
                boolean DataSourceClauseGenerated = false;
                for (int i = 0; i < temp_src.size(); i++) {
                    if (!((String) temp_src.get(i)).trim().equalsIgnoreCase("all")) {
                        params.add(new NameValuePair("term6", (String) temp_src.get(i)));
                    }
                }

            }
        }

        // start new code to parse and recreate attributes from the SourceObject
        SourceObject sob = new SourceObject();
        sob = st.getSo();
        if (sob != null) {
            ArrayList temp_src = sob.getT10();
            if ((temp_src != null) && (temp_src.size() > 0)) {
                params.add(new NameValuePair("term10attribute", "LTERSite"));
                params.add(new NameValuePair("op10", " OR "));
                if (temp_src.size() > 0) {
                    for (int i = 0; i < temp_src.size(); i++) {
                        if (temp_src.get(i) != null) {
                            if (!((String) temp_src.get(i)).trim().equalsIgnoreCase("all")) {
                                params.add(new NameValuePair("term10", (String) temp_src.get(i)));
                            }
                        }
                    }
                }
            }
        }
        if (sob != null) {
            ArrayList temp_src11 = sob.getT11();
            if ((temp_src11 != null) && (temp_src11.size() > 0)) {
                params.add(new NameValuePair("term11attribute", "LTERSite"));
                params.add(new NameValuePair("op11", " OR "));
                if (temp_src11.size() > 0) {
                    for (int i = 0; i < temp_src11.size(); i++) {
                        if (temp_src11 != null) {
                            if (!((String) temp_src11.get(i)).trim().equalsIgnoreCase("all")) {
                                params.add(new NameValuePair("term11", (String) temp_src11.get(i)));
                            }
                        }
                    }
                }
            }
        }

        // end new code to parse and recreate attributes from the SourceObject

        // ///////////////////

        if (!(null == st.getTerm7()) && (!(null == st.getTerm7().getAttribute()))
                && (!(null == st.getTerm7().getValue()))
                && (st.getTerm7().getAttribute().length() > 0)
                && (st.getTerm7().getValue().length() > 0)) {

            params.add(new NameValuePair("term7", st.getTerm7().getValue()));
            params.add(new NameValuePair("term7attribute", st.getTerm7().getAttribute()));

        }

        if (!(null == st.getTerm8()) && (!(null == st.getTerm8().getValue()))
                && (st.getTerm8().getValue().length() > 0)) {
            params.add(new NameValuePair("term8", st.getTerm8().getValue()));

        }

        if (!(null == st.getSearchmode()) && (!(null == st.getSearchmode().getAttribute()))
                && (!(null == st.getSearchmode().getValue()))
                && (st.getSearchmode().getAttribute().length() > 0)
                && (st.getSearchmode().getValue().length() > 0)) {
            params.add(new NameValuePair("searchmode", st.getSearchmode().getValue()));
            params.add(new NameValuePair("searchmodeAttribute", st.getSearchmode().getAttribute()));

        }

        if (!(null == st.getTerm9()) && (!(null == st.getTerm9().getAttribute()))
                && (!(null == st.getTerm9().getValue()))
                && (st.getTerm9().getAttribute().length() > 0)
                && (st.getTerm9().getValue().length() > 0)) {
            params.add(new NameValuePair("term9", st.getTerm9().getValue()));
            params.add(new NameValuePair("term9attribute", st.getTerm9().getAttribute()));

        }

        if (!(null == st.getTerm12())) {
            params.add(new NameValuePair("term12", st.getTerm12().getValue()));
            params.add(new NameValuePair("term12attribute", st.getTerm12().getAttribute()));
            params.add(new NameValuePair("op12", st.getTerm12().getOperation()));

        }

        int ps = 10;
        if (!(0 == st.getPageSize())) {
            params.add(new NameValuePair("pageSize", Integer.toString(st.getPageSize())));
            ps = st.getPageSize();
        }

        if (!(st.getStart() < 0)) {
            params.add(new NameValuePair("start", Integer.toString(st.getStart())));
        }

        if (!(null == st.getSortattribute())) {
            params.add(new NameValuePair("sortattribute", st.getSortattribute()));
        }

        if ((!(null == st.getSolr_facets_map())) && (st.getSolr_facets_map().size() > 0)) {
            Set entries = st.getSolr_facets_map().entrySet();
            Iterator entryIter = entries.iterator();

            while (entryIter.hasNext()) {
                Map.Entry entry = (Map.Entry) entryIter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();

                params.add(new NameValuePair("facetattribute", (String) key));

                params.add(new NameValuePair("facet", (String) value));
            }

        }
        if ((!(null == st.getHideDS())) && (st.getHideDS().length() > 0)) {
            params.add(new NameValuePair("hideDS", st.getHideDS()));
        }

        if (!(null == st.getBrowseStatus())) {
            String browseStatus = st.getBrowseStatus();
            params.add(new NameValuePair("browseStatus", browseStatus));
        }

        final HttpMethod method = new GetMethod();

        method.setQueryString(EncodingUtil.formUrlEncode(params.toArray(new NameValuePair[0]),
                "UTF-8"));

        String my_query_string = method.getQueryString();

        return my_query_string;
    }

}
