/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import gov.ornl.mercury3.beans.*;

import gov.ornl.mercury3.commands.Search_Terms;

import gov.ornl.mercury3.commands.SolrTransactionDetail;

import gov.ornl.mercury3.dwr_utils.DateUtil;
import java.util.HashMap;





/**
 * Coordinates database access using Hibernate /Spring utilities.
 *
 */
public class UserStatUtil_2{


    
	public boolean populateUserStatDB(HttpServletRequest request,
			HttpServletResponse response,
			SolrTransactionDetail solrTransactionDetail, String search_type,
			Search_Terms st,
			HashMap<String,String> term1Map,
			HashMap<String,String> termMap,
			Mercury_db_ServiceImpl psi
			) throws Exception {
		browseBean browseBean = new browseBean();
		boolean status = true;
		
		HttpSession session = null;
		session = request.getSession(true);

		
		
		//get browser info. if not a bot continue orelse die
		Boolean bot = false;
		String checkBrowser = request.getHeader("User-Agent");
		String fileurl = "";
		if(checkBrowser.toLowerCase().trim().contains("bot")||checkBrowser.toLowerCase().trim().contains("robot")){
			bot = true;
		}
		else{
			bot = false;
		}
		
		
		if(!bot){
		
		
		Session session1 = null;
		int count = 1;
		int transactionID = 0;
		session = request.getSession(true);

	
		
		session.setAttribute("lTargetName", (String) session
				.getAttribute("instance"));
		
		
		if(search_type != "MercuryWBT" && search_type != "MercuryFullPage")	
		{	
			if (!(null == solrTransactionDetail.getFacets().get("datasource"))) {
				session
						.setAttribute("newIndex", ((String) session
								.getAttribute("instance")
								+ " " + solrTransactionDetail.getFacets().get(
								"datasource")));
				
			} else {
				session.setAttribute("newIndex", ((String) session
						.getAttribute("lTargetName")
						+ " " + solrTransactionDetail.getPlainqueryString()));
				
			}
		}
		else if(search_type == "MercuryFullPage")	
		{
		
			session
			.setAttribute("newIndex", ((String) session
					.getAttribute("instance")
					+ " datasource: " + solrTransactionDetail.getDatasource()));
			
		}
		/**
		 * Saving fileid to the current session
		 * 
		 */
		if (!(null == request.getParameter("ds_id"))) {
			session.setAttribute("fileid", request.getParameter("ds_id"));
		} else {
			session.setAttribute("fileid", "n/a");
		}
		
		//get FileID
		if (!(null == solrTransactionDetail.getFileurl())) {
			fileurl = solrTransactionDetail.getFileurl();
			//System.out.println("fileurl "+fileurl);
		} else {
			fileurl = "n/a";
		//	System.out.println("no fileurl");
		}
		
		try {
			String Struct = "";

			
			
			
			try {
				// Saving user info to the session table
				if ((session.getAttribute("sessionLogged") == null)
						|| (!session.getAttribute("sessionLogged").equals(
								(String) session
										.getAttribute("sessioninstance")))) {
					
					session.setAttribute("sessionLogged", ((String) session
							.getAttribute("sessioninstance")));

					Session s1 = new Session();
					String i2 = (DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
										
					s1.setId(new SessionId(i2,(String) session.getAttribute("sessioninstance")));
					
					s1.setIpName(request.getRemoteUser());
					s1.setIpNumber(request.getRemoteAddr());
					s1.setBrowserInfo(request.getHeader("User-Agent"));
					s1.setSessionDate(new Date());
					
					psi.saveSession(s1);
				}
			}

			catch (Exception e) {
				System.out.println(e.getMessage());
			} 

			session.removeAttribute("LogStatusLookup"); // to handle multiple
			if (session.getAttribute("transID") != null) {
				transactionID = Integer.parseInt((String) session
						.getAttribute("transID"));
			}
			transactionID++;
			session.setAttribute("transID", "" + transactionID);

			/**
			 * Populating Query table into the DB
			 * 
			 */

			try {
				Query q1 = new Query();
				Short zero=0,one=1;	
				String i2 = (DateUtil.getInstance().dateToString(
						new Date(), "yyyyMMdd")
						+ ":" + (String) session.getId());
				q1.setId(new QueryId(i2,(String) session.getAttribute("sessioninstance"),transactionID));

			//	q1.setQueryDatetime(DateUtil.getInstance().toDate(new Date().toString(), "yyyy-MM-dd hh:mm:ss"));
				q1.setQueryDatetime(new Date());
				q1.setSearchType(search_type);
				
				if ((null != request.getParameter("term1"))
						&& (request.getParameter("term1").length() > 1)) {
					q1.setFreeTextSearch(one);
					
				} else {
					q1.setFreeTextSearch(zero);
				}
				if ((null != request.getParameter("term2"))
						&& (request.getParameter("term2").length() > 1)) {
					q1.setFieldedSearch(one);
				} else {
					q1.setFieldedSearch(zero);
				}
				if ((null != request.getParameter("term3"))
						&& (request.getParameter("term3").length() > 1)) {
					q1.setSpatialSearch(one);
				} else {
					q1.setSpatialSearch(zero);
				}
				if ((null != request.getParameter("term4"))
						&& (request.getParameter("term4").length() > 1)) {
					q1.setTemporalSearch(one);
				} else {
					q1.setTemporalSearch(zero);
				}
				if(search_type != "MercuryWBT"){
				q1.setQueryString(solrTransactionDetail.getPlainqueryString());
				}
				else{
					q1.setQueryString(request.getParameter("field"));
				}

				
				
				psi.saveQuery(q1);

			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());

			} 

			/**
			 * Populating terms table into the DB
			 */
			if ((!(null == request.getParameter("term1attribute")))
					&& (!(null == request.getParameter("term1")))) {

				if (term1Map.containsKey(request
						.getParameter("term1attribute"))) {
					if ((request.getParameter("term1").length() > 1)) {
						try {

							Term t1 = new Term();
							String i2 = (DateUtil.getInstance().dateToString(
									new Date(), "yyyyMMdd")
									+ ":" + (String) session.getId());
							t1.setId(new TermId(i2,
											(String) session.getAttribute("sessioninstance"),
											Integer.parseInt((String) session.getAttribute("transID")),
											count++
											));
												
							t1.setQueryDate(new Date());
							t1.setOperator(request.getParameter("op1"));
							t1.setTerm(request.getParameter("term1"));
							t1.setUseAttribute((String) term1Map.get(request.getParameter("term1attribute")));

							psi.saveTerm(t1);
							
						} catch (Exception e) {
							e.printStackTrace();
							status = false;
							System.out.println(e.getMessage());
						} 
					}
				}
			}

			if ((!(null == request.getParameter("term2attribute")))
					&& (!(null == request.getParameter("term2")))) {

				if (termMap.containsKey(request
						.getParameter("term2attribute"))) {
					try {
						Term t2 = new Term();
						
						String i2 = (DateUtil.getInstance().dateToString(
								new Date(), "yyyyMMdd")
								+ ":" + (String) session.getId());
						t2.setId(new TermId(i2,
										(String) session.getAttribute("sessioninstance"),
										Integer.parseInt((String) session.getAttribute("transID")),
										count++
										));
											
						t2.setQueryDate(new Date());
						t2.setOperator(request.getParameter("op2"));
						t2.setTerm(request.getParameter("term2"));
						t2.setUseAttribute((String) term1Map.get(request.getParameter("term2attribute")));

						



						if ((request.getParameter("term2").length() > 1)) {
							psi.saveTerm(t2);
						}
					} catch (Exception e) {
						e.printStackTrace();
						status = false;
						System.out.println(e.getMessage());
					} 
				}
			}

			if ((!(null == request.getParameter("term3attribute")))
					&& (!(null == request.getParameter("term3")))) {
				try {
					Term t3 = new Term();
					
					String i2 = (DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					t3.setId(new TermId(i2,
									(String) session.getAttribute("sessioninstance"),
									Integer.parseInt((String) session.getAttribute("transID")),
									count++
									));
										
					t3.setQueryDate(new Date());
					t3.setOperator(request.getParameter("op3"));
					t3.setTerm(request.getParameter("term3"));
					t3.setUseAttribute((String) term1Map.get(request.getParameter("term3attribute")));

					
					
					


					if ((request.getParameter("term3").length() > 1)) {
						
						psi.saveTerm(t3);
					}
				} catch (Exception e) {
					e.printStackTrace();
					status = false;
					System.out.println(e.getMessage());
				} 
			}

			if ((!(null == request.getParameter("term4attribute")))
					&& (!(null == request.getParameter("term4")))) {
				try {

					Term t4 = new Term();
					
					String i2 = (DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					t4.setId(new TermId(i2,
									(String) session.getAttribute("sessioninstance"),
									Integer.parseInt((String) session.getAttribute("transID")),
									count++
									));
										
					t4.setQueryDate(new Date());
					t4.setOperator(request.getParameter("op4"));
					t4.setTerm(request.getParameter("term4"));
					t4.setUseAttribute((String) term1Map.get(request.getParameter("term4attribute")));

					
					
					
					

					if ((request.getParameter("term4").length() > 1)) {
						psi.saveTerm(t4);

					}
				} catch (Exception e) {
					e.printStackTrace();
					status = false;
					System.out.println(e.getMessage());
				} 
			}

			if ((!(null == request.getParameter("term5attribute")))
					&& (!(null == request.getParameter("term5")))) {
				try {

					Term t5 = new Term();
					
					String i2 = (DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					t5.setId(new TermId(i2,
									(String) session.getAttribute("sessioninstance"),
									Integer.parseInt((String) session.getAttribute("transID")),
									count++
									));
										
					t5.setQueryDate(new Date());
					t5.setOperator(request.getParameter("op5"));
					t5.setTerm(request.getParameter("term5"));
					t5.setUseAttribute((String) term1Map.get(request.getParameter("term5attribute")));

					
					
					if ((request.getParameter("term5").length() > 1)) {
						psi.saveTerm(t5);
					}
				} catch (Exception e) {
					e.printStackTrace();
					status = false;
					System.out.println(e.getMessage());
				} 
			}

			try {
				ResultSet rs1 = new ResultSet();
				
				session.setAttribute("st", st);
				// Saving user info to the result_set table

				String i2 = (DateUtil.getInstance().dateToString(
						new Date(), "yyyyMMdd")
						+ ":" + (String) session.getId());
				rs1.setId(new ResultSetId(i2,
								(String) session.getAttribute("sessioninstance"),
								Integer.parseInt((String) session.getAttribute("transID")),
								(String) session.getAttribute("sessioninstance")
								));
				
				
				rs1.setRsDatetime(new Date());
				rs1.setSearchStatus("Search Complete");
				rs1.setRecordCount((long)st.getResponses());
				
				rs1.setSource((String) session.getAttribute("newIndex"));
				
				

				psi.saveResultSet(rs1);
				
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());
				status = false;
			} 

			try {
				
				Retrieval rt = new Retrieval();
				String i2 = (DateUtil.getInstance().dateToString(
						new Date(), "yyyyMMdd")
						+ ":" + (String) session.getId());
				
				rt.setId(new RetrievalId(i2,
						(String) session.getAttribute("sessioninstance"),
						Integer.parseInt((String) session.getAttribute("transID")),
						(String) session.getAttribute("sessioninstance"),
						search_type,
						new Date()
						));
				
			
				
				if (st.getResponses() < st.getPageSize()) {
					rt.setRecordsOnPage(new Integer(st.getResponses()));
				} else {
					rt.setRecordsOnPage(new Integer(st.getPageSize()));
				}
				rt.setStartRecordNo((long)((st.getCurrent_page() * st.getPageSize()) - st.getPageSize()) + 1);
				
				
				rt.setFileId(fileurl);
				rt.setSource((String) session.getAttribute("newIndex"));
				psi.saveRetrieval(rt);

			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());
				status = false;
			} 

			
		} catch (Exception e) {
			System.out.println("problem in hibernate intialize "
					+ e.getMessage());
		} 
		
		}
		
		else{ /*If bot- don't record any stats*/
			
			System.out.println("Browser identified as BOT/ROBOT (Did not record stats)");
		}
		return status;
	}
	
	public boolean populatereferralDB(HttpServletRequest request,
			HttpServletResponse response,
			Mercury_db_ServiceImpl psi
			) throws Exception {
		boolean status = true;
		HttpSession session = null;
		session = request.getSession(true);
		
		//get browser info. if not a bot continue orelse die
		Boolean bot = false;
		String checkBrowser = request.getHeader("User-Agent");
		if(checkBrowser.toLowerCase().trim().contains("bot")||checkBrowser.toLowerCase().trim().contains("robot")){
			bot = true;
		}
		else{
			bot = false;
		}
		
		
		if(!bot){
		
		Session session1 = null;	
		
		Referral rf = new Referral();
		String dwrurl = request.getParameter("url");
		String urltype = request.getParameter("type");
		String urlsubtype = request.getParameter("subType");
		String urltitle = request.getParameter("title");
		
		if((String)session.getAttribute("xsltfileURL") != null){
			urltitle = (String)session.getAttribute("xsltfileURL").toString().trim();
		}
		//System.out.println("utltitle "+urltitle);
		try {
			
			
			String i2 = (DateUtil.getInstance().dateToString(
					new Date(), "yyyyMMdd")
					+ ":" + (String) session.getId());
			
			rf.setId(new ReferralId(i2,
					(String) session.getAttribute("instance"),
					Integer.parseInt((String) session.getAttribute("transID")),
					(String) session.getAttribute("sessioninstance"),
					(String) session.getAttribute("fileid"),
					new Date()
					));
			
	
			rf.setType(urltype);
			rf.setSubtype(urlsubtype);
			rf.setUrl(dwrurl);
			rf.setTitle(urltitle);
			rf.setSource((String) session.getAttribute("newIndex"));

			psi.saveReferral(rf);
			
		}

		catch (Exception e) {
			e.printStackTrace();
			System.out.println(e.getMessage());
			status = false;
		}

		}
		else{ /*If bot- don't record any stats*/
			
			System.out.println("Browser identified as BOT/ROBOT (Did not record stats)");
		}
		return status;
	}
	
	
	
}
