/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import gov.ornl.mercury3.beans.*;
import gov.ornl.mercury3.commands.QueryBean;
import gov.ornl.mercury3.commands.Referral;
import gov.ornl.mercury3.commands.ResultsetBean;
import gov.ornl.mercury3.commands.Retrieval;
import gov.ornl.mercury3.commands.Search_Terms;
import gov.ornl.mercury3.commands.SessionBean;
import gov.ornl.mercury3.commands.SolrTransactionDetail;
import gov.ornl.mercury3.commands.Terms;
import gov.ornl.mercury3.dwr_utils.DateUtil;
import java.util.HashMap;
import org.hibernate.Session;
import org.hibernate.Transaction;


/**
 * ornldaac3
 * 
 * @Created 2007 Aug 17, 2007 10:47:44 AM
 * @author zzr
 * @Modified by: Ranjeet Devarakonda
 */
public class UserStatUtil{

//	public Mercury_term_maps mtm = new Mercury_term_maps();

	/**
	 * 
	 * @param request
	 * @param response
	 * @param solrTransactionDetail
	 * @param search_type
	 * @param st
	 * @return
	 * @throws Exception
	 */
	
    
	public boolean populateUserStatDB(HttpServletRequest request,
			HttpServletResponse response,
			SolrTransactionDetail solrTransactionDetail, String search_type,
			Search_Terms st,
			HashMap<String,String> term1Map,
			HashMap<String,String> termMap,
			Mercury_db_ServiceImpl psi
			) throws Exception {
		browseBean browseBean = new browseBean();
		boolean status = true;
		
		HttpSession session = null;
		session = request.getSession(true);

		Session session1 = null;
		int count = 1;
		int transactionID = 0;
		session = request.getSession(true);

		/**
		 * saving index name to the current ession
		 */
    

		session.setAttribute("lTargetName", (String) session
				.getAttribute("instance"));
		
		//System.out.println("solrTransactionDetail.getDatasource()=="+solrTransactionDetail.getDatasource());
		
		
	if(search_type != "MercuryWBT" && search_type != "MercuryFullPage")	
	{	
		if (!(null == solrTransactionDetail.getFacets().get("datasource"))) {
			session
					.setAttribute("newIndex", ((String) session
							.getAttribute("instance")
							+ " " + solrTransactionDetail.getFacets().get(
							"datasource")));
			
		} else {
			session.setAttribute("newIndex", ((String) session
					.getAttribute("lTargetName")
					+ " " + solrTransactionDetail.getPlainqueryString()));
			
		}
	}
	else if(search_type == "MercuryFullPage")	
	{
	session
	.setAttribute("newIndex", ((String) session
			.getAttribute("instance")
			+ " " + solrTransactionDetail.getDatasource()));
	}
		/**
		 * Saving fileid to the current session
		 * 
		 */
		if (!(null == request.getParameter("ds_id"))) {
			session.setAttribute("fileid", request.getParameter("ds_id"));
		} else {
			session.setAttribute("fileid", "n/a");
		}

		try {
			//session1 = HibernateSessionFactory.currentSession();
			session1 = HibernateSessionFactory.getSession();
			String Struct = "";

			
			
			
			try {
				// Saving user info to the session table
				if ((session.getAttribute("sessionLogged") == null)
						|| (!session.getAttribute("sessionLogged").equals(
								(String) session
										.getAttribute("sessioninstance")))) {
					SessionBean sb = new SessionBean();
					sb.setSessionId(DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					//System.out.println("sessioninstance=="+((String) session
							//.getAttribute("sessioninstance")));
					sb.setInstanceName(((String) session.getAttribute("sessioninstance")));
					sb.setRemoteIP(request.getRemoteAddr());
					//sb.setipName(request.getRemoteUser());
					sb.setBrowserInfo(request.getHeader("User-Agent"));
					sb.setSessionDate(DateUtil.getInstance().dateToString(
							new Date(), "yyyy-MM-dd"));
					session.setAttribute("sessionLogged", ((String) session
							.getAttribute("sessioninstance")));

					Transaction tx = null;
					tx = session1.beginTransaction();
					session1.save(sb);
					tx.commit();
				}
			}

			catch (Exception e) {
				System.out.println(e.getMessage());
			} finally {
				session1.clear();
				session1.flush();				
				session1.disconnect();
			}

			session.removeAttribute("LogStatusLookup"); // to handle multiple
			if (session.getAttribute("transID") != null) {
				transactionID = Integer.parseInt((String) session
						.getAttribute("transID"));
			}
			transactionID++;
			session.setAttribute("transID", "" + transactionID);

			/**
			 * Populating Query table into the DB
			 * 
			 */

			try {
				QueryBean qb = new QueryBean();
				qb.setsessionId(DateUtil.getInstance().dateToString(new Date(),
						"yyyyMMdd")
						+ ":" + (String) session.getId());
				qb.setinstanceName(((String) session
						.getAttribute("sessioninstance")));
				qb.settransactionID(Integer.parseInt((String) session
						.getAttribute("transID")));
				qb.setqueryDateTime(DateUtil.getInstance().dateToString(
						new Date(), "yyyy-MM-dd hh:mm:ss"));
				qb.setsearchType(search_type);
				if ((null != request.getParameter("term1"))
						&& (request.getParameter("term1").length() > 1)) {
					qb.setfreeTextSearch(1);
				} else {
					qb.setfreeTextSearch(0);
				}
				if ((null != request.getParameter("term2"))
						&& (request.getParameter("term2").length() > 1)) {
					qb.setfieldedSearch(1);
				} else {
					qb.setfieldedSearch(0);
				}
				if ((null != request.getParameter("term3"))
						&& (request.getParameter("term3").length() > 1)) {
					qb.setspatialSearch(1);
				} else {
					qb.setspatialSearch(0);
				}
				if ((null != request.getParameter("term4"))
						&& (request.getParameter("term4").length() > 1)) {
					qb.settemporalSearch(1);
				} else {
					qb.settemporalSearch(0);
				}
				if(search_type != "MercuryWBT"){
				qb.setqueryString(solrTransactionDetail.getPlainqueryString());
				}
				else{
					qb.setqueryString(request.getParameter("field"));
				}

				Transaction tx = null;
				tx = session1.beginTransaction();
				session1.save(qb);				
				tx.commit();

			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());

			} finally {
				session1.clear();
				session1.flush();
				session1.disconnect();
			}

			/**
			 * Populating terms table into the DB
			 */
			if ((!(null == request.getParameter("term1attribute")))
					&& (!(null == request.getParameter("term1")))) {

				if (term1Map.containsKey(request
						.getParameter("term1attribute"))) {
					if ((request.getParameter("term1").length() > 1)) {
						try {
							Terms simple = new Terms();
							simple.setsessionId(DateUtil.getInstance()
									.dateToString(new Date(), "yyyyMMdd")
									+ ":" + (String) session.getId());
							simple.setAttribute((String) term1Map.get(request
									.getParameter("term1attribute")));
							simple.setValue(request.getParameter("term1"));
							simple.setOperation(request.getParameter("op1"));
							simple.setdate(DateUtil.getInstance().dateToString(
									new Date(), "yyyy-MM-dd"));
							simple.settransID(Integer.parseInt((String) session
									.getAttribute("transID")));
							simple.setSequenceNum(count++);
							simple.setinstance(((String) session
									.getAttribute("sessioninstance")));

							Transaction tx = null;
							tx = session1.beginTransaction();
							session1.save(simple);
							tx.commit();

						} catch (Exception e) {
							e.printStackTrace();
							status = false;
							System.out.println(e.getMessage());
						} finally {
							session1.clear();
							session1.flush();
							session1.disconnect();
						}
					}
				}
			}

			if ((!(null == request.getParameter("term2attribute")))
					&& (!(null == request.getParameter("term2")))) {

				if (termMap.containsKey(request
						.getParameter("term2attribute"))) {
					try {

						Terms keyword2 = new Terms();
						keyword2.setsessionId(DateUtil.getInstance()
								.dateToString(new Date(), "yyyyMMdd")
								+ ":" + (String) session.getId());
						keyword2.setAttribute((String) termMap.get(request
								.getParameter("term2attribute")));
						keyword2.setValue(request.getParameter("term2"));
						keyword2.setdate(DateUtil.getInstance().dateToString(
								new Date(), "yyyy-MM-dd"));
						keyword2.settransID(Integer.parseInt((String) session
								.getAttribute("transID")));
						keyword2.setinstance(((String) session
								.getAttribute("sessioninstance")));
						keyword2.setSequenceNum(count++);

						if ((request.getParameter("term2").length() > 1)) {
							Transaction tx = null;
							tx = session1.beginTransaction();
							session1.save(keyword2);
							tx.commit();
						}
					} catch (Exception e) {
						e.printStackTrace();
						status = false;
						System.out.println(e.getMessage());
					} finally {
						session1.flush();
						session1.clear();
						session1.disconnect();
					}
				}
			}

			if ((!(null == request.getParameter("term3attribute")))
					&& (!(null == request.getParameter("term3")))) {
				try {
					Terms spatial = new Terms();
					spatial.setsessionId(DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					spatial
							.setAttribute(request
									.getParameter("term3attribute"));// NSEW
					spatial.setOperation(request.getParameter("op3"));
					spatial.setValue(request.getParameter("term3"));
					spatial.setdate(DateUtil.getInstance().dateToString(
							new Date(), "yyyy-MM-dd"));
					spatial.settransID(Integer.parseInt((String) session
							.getAttribute("transID")));
					spatial.setinstance(((String) session
							.getAttribute("sessioninstance")));
					spatial.setSequenceNum(count++);

					if ((request.getParameter("term3").length() > 1)) {
						Transaction tx = null;
						tx = session1.beginTransaction();
						session1.save(spatial);
						tx.commit();
					}
				} catch (Exception e) {
					e.printStackTrace();
					status = false;
					System.out.println(e.getMessage());
				} finally {

					session1.clear();
					session1.flush();
					session1.disconnect();
				}
			}

			if ((!(null == request.getParameter("term4attribute")))
					&& (!(null == request.getParameter("term4")))) {
				try {

					Terms temporal1 = new Terms();
					temporal1.setsessionId(DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					temporal1.setAttribute(request
							.getParameter("term4attribute"));
					temporal1.setOperation(request.getParameter("op4"));
					temporal1.setValue(request.getParameter("term4"));
					temporal1.setdate(DateUtil.getInstance().dateToString(
							new Date(), "yyyy-MM-dd"));
					temporal1.settransID(Integer.parseInt((String) session
							.getAttribute("transID")));
					temporal1.setinstance(((String) session
							.getAttribute("sessioninstance")));
					// st.setTerm4(temporal1);

					if ((request.getParameter("term3").length() > 1)) {

						Transaction tx = null;
						tx = session1.beginTransaction();
						session1.save(temporal1);

						tx.commit();
					}
				} catch (Exception e) {
					e.printStackTrace();
					status = false;
					System.out.println(e.getMessage());
				} finally {
					session1.clear();
					session1.flush();
					session1.disconnect();
				}
			}

			if ((!(null == request.getParameter("term5attribute")))
					&& (!(null == request.getParameter("term5")))) {
				try {

					Terms temporal2 = new Terms();
					temporal2.setsessionId(DateUtil.getInstance().dateToString(
							new Date(), "yyyyMMdd")
							+ ":" + (String) session.getId());
					temporal2.setAttribute(request
							.getParameter("term5attribute"));
					temporal2.setOperation(request.getParameter("op5"));
					temporal2.setValue(request.getParameter("term5"));
					temporal2.setdate(DateUtil.getInstance().dateToString(
							new Date(), "yyyy-MM-dd"));
					temporal2.settransID(Integer.parseInt((String) session
							.getAttribute("transID")));
					temporal2.setinstance(((String) session
							.getAttribute("sessioninstance")));
					if ((request.getParameter("term5").length() > 1)) {
						Transaction tx = null;
						tx = session1.beginTransaction();
						session1.save(temporal2);
						tx.commit();
					}
				} catch (Exception e) {
					e.printStackTrace();
					status = false;
					System.out.println(e.getMessage());
				} finally {
					session1.clear();
					session1.flush();
					session1.disconnect();
				}
			}

			try {
				ResultsetBean rsb = new ResultsetBean();
				session.setAttribute("st", st);
				// Saving user info to the result_set table

				rsb.setsessionId(DateUtil.getInstance().dateToString(
						new Date(), "yyyyMMdd")
						+ ":" + (String) session.getId());
				rsb.setInstanceName(((String) session
						.getAttribute("sessioninstance")));
				rsb.setTransID(Integer.parseInt((String) session
						.getAttribute("transID")));
				rsb.setIndexName((String) session.getAttribute("sessioninstance"));
				rsb.setRecordCount(st.getResponses());
				rsb.setSearchStatus("Search Complete");
				rsb.setsource((String) session.getAttribute("newIndex"));
				rsb.setdatetime(DateUtil.getInstance().dateToString(new Date(),
						"yyyy-MM-dd hh:mm:ss"));

				Transaction tx = null;
				tx = session1.beginTransaction();
				session1.save(rsb);
				tx.commit();
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());
				status = false;
			} finally {
				session1.clear();
				session1.flush();
				session1.disconnect();
			}

			try {
				Retrieval rt = new Retrieval();
				rt.setsessionId(DateUtil.getInstance().dateToString(new Date(),
						"yyyyMMdd")
						+ ":" + (String) session.getId());
				rt.setInstanceName(((String) session
						.getAttribute("sessioninstance")));
				rt.setTransID(Integer.parseInt((String) session
						.getAttribute("transID")));
				rt.setIndexName((String) session.getAttribute("sessioninstance"));
				rt.setElementSet(search_type);
				rt.setdateTime(DateUtil.getInstance().dateToString(new Date(),
						"yyyy-MM-dd hh:mm:ss"));
				rt.setsource((String) session.getAttribute("newIndex"));
				if (st.getResponses() < st.getPageSize()) {
					rt.setRecsOnPage(st.getResponses());
				} else {
					rt.setRecsOnPage(st.getPageSize());
				}
				rt
						.setStartRecNum(((st.getCurrent_page() * st
								.getPageSize()) - st.getPageSize()) + 1);
				rt.setFileID("n/a");

				Transaction tx = null;
				tx = session1.beginTransaction();
				session1.save(rt);
				tx.commit();
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());
				status = false;
			} finally {
				session1.clear();
				session1.flush();
				session1.disconnect();

			}

			
		} catch (Exception e) {
			System.out.println("problem in hibernate intialize "
					+ e.getMessage());
		} finally {
			// close any hibernate session here
			session1.clear();
			session1.flush();
			session1.disconnect();	
			HibernateSessionFactory.closeSession();	
		}

		return status;
	}
	
	public boolean populatereferralDB(HttpServletRequest request,
			HttpServletResponse response,
			Mercury_db_ServiceImpl psi
			
			) throws Exception {
		boolean status = true;
		HttpSession session = null;
		session = request.getSession(true);
		Session session1 = null;

		Referral rf = new Referral();
		String dwrurl = request.getParameter("url");
		String urltype = request.getParameter("type");
		String urlsubtype = request.getParameter("subType");
		String urltitle = request.getParameter("title");
		try {
			//session1 = HibernateSessionFactory.currentSession();
			session1 = HibernateSessionFactory.getSession();
			rf.setsessionId(DateUtil.getInstance().dateToString(new Date(),
					"yyyyMMdd")
					+ ":" + (String) session.getId());
			rf.setinstance((String) session.getAttribute("instance"));
			rf.settransaction_id(Integer.parseInt((String) session
					.getAttribute("transID")));
			rf.setindex_name((String) session.getAttribute("sessioninstance"));
			rf.setfile_id((String) session.getAttribute("fileid"));
			rf.setdate_time(DateUtil.getInstance().dateToString(new Date(),
					"yyyy-MM-dd hh:mm:ss"));
			rf.settype(urltype);
			rf.setsub_type(urlsubtype);
			rf.seturl(dwrurl);
			rf.settitle(urltitle);
			rf.setsource((String) session.getAttribute("newIndex"));
			Transaction tx = null;
			tx = session1.beginTransaction();
			session1.save(rf);
			tx.commit();
		}

		catch (Exception e) {
			e.printStackTrace();
			System.out.println(e.getMessage());
			status = false;
		}

		finally {
			session1.clear();
			session1.flush();
			session1.disconnect();
			HibernateSessionFactory.closeSession();			
		}	
	
		
		return status;
	}
	
	
	
}
