/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;


import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;


public class TransformedFilesDAO extends HibernateDaoSupport {
	private static final Log log = LogFactory.getLog(TransformedFilesDAO.class);
	// property constants
	public static final String FILE_NAME = "fileName";
	public static final String FILE_CONTENT = "fileContent";
	public static final String FILE_URL = "fileUrl";
	public static final String CKSUM = "cksum";

	protected void initDao() {
		// do nothing
	}

	public void save(TransformedFiles transientInstance) {
		log.debug("saving TransformedFiles instance");
		try {
			getHibernateTemplate().save(transientInstance);
			log.debug("save successful");
		} catch (RuntimeException re) {
			log.error("save failed", re);
			throw re;
		}
	}

	public void delete(TransformedFiles persistentInstance) {
		log.debug("deleting TransformedFiles instance");
		try {
			getHibernateTemplate().delete(persistentInstance);
			log.debug("delete successful");
		} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

	public TransformedFiles findById(java.lang.Integer id) {
		log.debug("getting TransformedFiles instance with id: " + id);
		try {
			TransformedFiles instance = (TransformedFiles) getHibernateTemplate().get("gov.ornl.mercury3.services.TransformedFiles", id);
			return instance;
		} catch (RuntimeException re) {
			log.error("get failed", re);
			throw re;
		}
	}

	public List findByExample(TransformedFiles instance) {
		log.debug("finding TransformedFiles instance by example");
		try {
			List results = getHibernateTemplate().findByExample(instance);
			log.debug("find by example successful, result size: "
					+ results.size());
			return results;
		} catch (RuntimeException re) {
			log.error("find by example failed", re);
			throw re;
		}
	}

	public List findByProperty(String propertyName, Object value) {
		log.debug("finding TransformedFiles instance with property: "
				+ propertyName + ", value: " + value);
		try {
			String queryString = "from TransformedFiles as model where model."
					+ propertyName + "= ?";
			return getHibernateTemplate().find(queryString, value);
		} catch (RuntimeException re) {
			log.error("find by property name failed", re);
			throw re;
		}
	}

	public List findByFileName(Object fileName) {
		return findByProperty(FILE_NAME, fileName);
	}

	public List findByFileContent(Object fileContent) {
		return findByProperty(FILE_CONTENT, fileContent);
	}

	public List findByFileUrl(Object fileUrl) {
		return findByProperty(FILE_URL, fileUrl);
	}

	public List findByCksum(Object cksum) {
		return findByProperty(CKSUM, cksum);
	}

	public List findAll() {
		log.debug("finding all TransformedFiles instances");
		try {
			String queryString = "from TransformedFiles";
			return getHibernateTemplate().find(queryString);
		} catch (RuntimeException re) {
			log.error("find all failed", re);
			throw re;
		}
	}

	public TransformedFiles merge(TransformedFiles detachedInstance) {
		log.debug("merging TransformedFiles instance");
		try {
			TransformedFiles result = (TransformedFiles) getHibernateTemplate()
					.merge(detachedInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}

	public void attachDirty(TransformedFiles instance) {
		log.debug("attaching dirty TransformedFiles instance");
		try {
			getHibernateTemplate().saveOrUpdate(instance);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void attachClean(TransformedFiles instance) {
		log.debug("attaching clean TransformedFiles instance");
		try {
			getHibernateTemplate().lock(instance, LockMode.NONE);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public static TransformedFilesDAO getFromApplicationContext(
			ApplicationContext ctx) {
		return (TransformedFilesDAO) ctx.getBean("TransformedFilesDAO");
	}
}
