/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.Field;
import gov.ornl.mercury3.commands.FilterCatField;
import gov.ornl.mercury3.commands.Response;
import gov.ornl.mercury3.commands.Solr_Terms;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TestSolr implements Solr_Terms {

    public static void main(String[] args) {

        System.out.println("testing solr query");

        String solrSelectURL;
        // load parameters and get the party started
        Properties p = new Properties();
        try {

            p.load(new FileInputStream("mercury3.properties"));

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception in property loading");

        }

        solrSelectURL = p.getProperty("mercury3.solrSelectURL", "");

        // //////////
        System.out.println("solrSelectURL " + solrSelectURL);

        try {
            SolrSearcher solrSearcher = new SolrSearcher(solrSelectURL);
            List filedsList = new ArrayList();

            filedsList.add("title");
            filedsList.add("source");
            filedsList.add("abstract");

            List facetsList = new ArrayList();
            for (int x = 0; x < sl.length; x++) {
                facetsList.add(sl[x]);

            }

            // test plain query
            // Response res = solrSearcher.search("water", 0, 0, filedsList,
            // "",null,
            // null,null,null,null);

            // test facet query
            // Response res = solrSearcher.search("water", 0, 10, filedsList,
            // "",null,
            // null,"true","-1","geoform");
            Response res = solrSearcher.search("rain and geoform:Virginia", 5, 5, filedsList, "",
                    null, null, "true", "5", facetsList, null, null);
            // Response res = solrSearcher.search("rain", 0, 0, filedsList,
            // "",null,
            // null,"true","5",facetsList);

            // http://giri.ornl.gov:8095/nbii_solr/select/?q=rain&rows=0&facet=true&facet.limit=-1&facet.field=geoform
            System.out.println("# of results =" + res.getFound() + " status=" + res.getStatus()
                    + " qTime=" + res.getQtime());
            List<Map<String, Field>> documents = res.getDocuments();

            for (int i = 0; i < documents.size(); i++) {
                // System.out.println(documents.get(i));
                System.out.println("i===" + i);
                HashMap aField = (HashMap) documents.get(i);
                for (Iterator iter = aField.keySet().iterator(); iter.hasNext();) {
                    String fieldStr = (String) iter.next();
                    System.out.println("fieldStr=" + fieldStr);

                    Field tField = (Field) aField.get(fieldStr);
                    System.out.println("j_documents value= " + tField.getValue());

                }

            }

            // now get the facet values

            ArrayList al = new ArrayList(res.getFacets().entrySet());
            Iterator a_IT = al.iterator();

            Map<FilterCatField, List> facets = res.getFacets();
            Iterator fIT = facets.keySet().iterator();
            int ctr = 1;
            // while (fIT.hasNext()) {
            while (a_IT.hasNext()) {
                String facetCat = (String) fIT.next();
                List fields = (List) facets.get(facetCat);
                System.out.println(ctr + "  " + facetCat);
                for (int j = 0; j < fields.size(); j++) {
                    Field aField = (Field) fields.get(j);
                    // System.out.println("name="+aField.getName()+"
                    // value="+aField.getValue()+" type="+aField.getType());
                    System.out.println(j + 1 + "  " + aField.getName() + "  " + aField.getValue()
                            + "  " + aField.getType());

                }
                ctr++;

            }

        } catch (Exception e) {
            System.out.println("ERROR=" + e.getMessage());
        }
    }

}
