/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;
import gov.ornl.mercury3.dwr_utils.ErrorLogUtil;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;


/**
 * Utility for validating html strings. 
 *
 */
public class StringUtility {
//	ErrorLogUtil logger = ErrorLogUtil.getInstance();
	private static StringUtility instance; // The single instance

	/**
	  * A private constructor since this is a Singleton
	 */
	
	  
	/**
	  * Returns a single instance, creating one if this method is called first time
	  * @return FilePathChecker - a single instance.
	  */
	  static synchronized public StringUtility getInstance()
	  {
	  	//System.out.println("Inside StringUtility.getInstance()");
	    if (instance == null)
	    {
	      instance = new StringUtility();
	    }
	      return instance;
	  }

	/**
	  * A private constructor since this is a Singleton
	 */
	  private StringUtility()
	  {     
	     super();
	  }
	
	
	
	  public StringBuffer replaceToReferralURLS (StringBuffer OriginalHtmlStr)
	  {
	    
	    StringBuffer modifiedHtmlStr = new StringBuffer();  
	    HashMap referalList = new HashMap();
	    boolean haveBaseURL=false;
	    String baseURL="";
	    
	    // search html document for a <base href=" "> tag, if found use the base for all relative urls
	    
	    try
	    {
	      Pattern p = Pattern.compile("< *base +href *= *\"(.*?)\" *>",Pattern.CASE_INSENSITIVE);
	      Matcher m = p.matcher(OriginalHtmlStr);
	      //StringBuffer htmlStr = new StringBuffer(m.replaceAll("a href"));
	      if (m.find()) 
	      {       
	        String baseRef=m.group(1);
	        Pattern urlP=Pattern.compile("^ *(.*)/(.*)$");
	        Matcher urlM= urlP.matcher(baseRef);
	        if (urlM.find()) 
	        {
	            baseURL=urlM.group(1)+ "/";
	            haveBaseURL=true;
	        }
	        OriginalHtmlStr=new StringBuffer(m.replaceFirst(""));
	      }
	    }
	    catch (PatternSyntaxException e)
	    {    
	     System.out.println("Regex syntax error: " + e.getMessage ()); 
	    }
	   // System.out.println("base Ref= " + baseURL); 
	    
	    int counter = 0;
	    try
	    {
	      Pattern p = Pattern.compile("< *a +href *= *\"(.*?)\"",Pattern.CASE_INSENSITIVE);
	      Matcher m = p.matcher(OriginalHtmlStr);
	      //StringBuffer htmlStr = new StringBuffer(m.replaceAll("a href"));
	      while(m.find()) 
	      {       
	 	   if(!m.group(1).trim().startsWith("#") && !m.group(1).trim().toLowerCase().startsWith("mailto"))
	 	   {
	 	       //counter++;
	         //   System.out.println("baseURL0="+baseURL);
	            System.out.println("m.group(1)0="+m.group(1));
	            if(!m.group(1).trim().toLowerCase().startsWith("http") && !m.group(1).trim().toLowerCase().startsWith("ftp"))
	            {
	              referalList.put(""+counter,baseURL+m.group(1)+"|"+"General"+"|"+"General");
	         //   System.out.println("baseURL="+baseURL);
	          //  System.out.println("m.group(1)="+m.group(1));
	            }
	            else 
	            {
	              //  referalList.put(""+counter,m.group(1)+"|"+"General"+"|"+"General");
	            }
	            m.appendReplacement(modifiedHtmlStr, "<a href="+m.group(1)+" onClick=\"survey('"+m.group(1)+"')\"");
	 	   }
	      }
	 	 m.appendTail(modifiedHtmlStr);
	    }
	    catch (PatternSyntaxException e)
	    {	
	    	System.out.println("Regex syntax error: " + e.getMessage ()); 
	    }
	 //	  System.out.println("modifiedHtmlStr"+modifiedHtmlStr);  
	    return modifiedHtmlStr;    	
	  }
}
