/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package gov.ornl.mercury3.services;

import java.util.ArrayList;

/**
 * Builds a composite datasource clause for querying.
 *
 */
public class SourceQuery {

	private ArrayList<String> t6 = new ArrayList<String>();
	private ArrayList<String> t10 = new ArrayList<String>();
	private ArrayList<String> t11 = new ArrayList<String>();

	private String ds_all = "false", ds_lter = "false", ds_ilter = "false",
			facet_ds = "";

	public SourceQuery() {
	}

	public SourceQuery(SourceObject so) {
		super();
		this.t6 = so.getT6();
		this.t10 = so.getT10();
		this.t11 = so.getT11();
		this.ds_all = so.getDs_all();
		this.ds_lter = so.getDs_lter();
		this.ds_ilter = so.getDs_ilter();
		this.facet_ds = so.getFacet_ds();
	}

	public String buildT6Snippet(ArrayList<String> al) {
		String attribute = "datasource";
		String query = buildSnippet(al, attribute);
		return query;
	}

	public String buildT10Snippet(ArrayList<String> al) {
		String attribute = "LTERSite";
		String query = buildSnippet(al, attribute);
		return query;
	}

	public String buildT11Snippet(ArrayList<String> al) {
		String attribute = "LTERSite";
		String query = buildSnippet(al, attribute);
		return query;
	}

	public String buildSnippet(ArrayList<String> al, String attribute) {
		StringBuffer sb = new StringBuffer();
		int log = 0;
		// sb.append( " OR ");
		for (String str : al) {
			if (str.trim().length()>0){
				if (log > 0) {
					sb.append(" OR " + attribute + ":" + str + " ");
				} else {
					sb.append(" ( " + attribute + ":" + str + " ");
					log = 1;
				}
			}
		}
		sb.append(" )  ");
		return sb.toString();
	}

	public String build_ds_Snippet(ArrayList<String> al, String attribute) {
		StringBuffer sb = new StringBuffer();
		int log = 0;

		for (String str : al) {
			if (log > 0) {
				sb.append(str + " ");
			} else {
				sb.append(attribute + " :( " + str + " ");
				log = 1;
			}

		}
		sb.append(" )  ");
		return sb.toString();
	}

	public String buildT6_ds_Snippet(ArrayList<String> al) {
		String attribute = "datasource";
		String query = build_ds_Snippet(al, attribute);
		return query;
	}

	public String buildT10_ds_Snippet(ArrayList<String> al) {
		String attribute = "LTERSite";
		String query = build_ds_Snippet(al, attribute);
		return query;
	}

	public String buildT11_ds_Snippet(ArrayList<String> al) {
		String attribute = "iLTERSite";
		String query = build_ds_Snippet(al, attribute);
		return query;
	}

	public String build_display_query() {
		StringBuffer sb = new StringBuffer();
		String query = "", t6Snip = "", t10Snip = "", t11Snip = "";
		if (!Boolean.parseBoolean(ds_all)) {

			if ((t6 != null) && (t6.size() > 0)) {
				t6Snip = buildT6_ds_Snippet(t6);
			}

			if (Boolean.parseBoolean(ds_lter)) {
			//	t10Snip = (" datasource:lter");
			} else if ((t10 != null) && (t10.size() > 0)) {
				t10Snip = buildT10_ds_Snippet(t10);
			}
			if ((t6Snip.length() > 0) && (t10Snip.length() > 0)) {
				t10Snip = " OR " + t10Snip;
			}

			if (Boolean.parseBoolean(ds_ilter)) {
			//	t11Snip = ("datasource:ilter");
			} else if ((t11 != null) && (t11.size() > 0)) {
				t11Snip = buildT11_ds_Snippet(t11);
			}

			if ((t11Snip.length() > 0)
					&& ((t6Snip.length() > 0) || (t10Snip.length() > 0))) {
				t11Snip = " OR " + t11Snip;
			}
	
			// if this is a faceted datasource search
			if (facet_ds.length()>0) {
				if ((facet_ds.equalsIgnoreCase("lter"))&&((t10.size()>0))){
					sb.append(" AND ( " + buildT10_ds_Snippet(t10).trim()  + " ) ");
					
				}else if ((facet_ds.equalsIgnoreCase("ilter"))&&((t11.size()>0))){
					sb.append(" AND ( " + buildT11_ds_Snippet(t11).trim()  + " ) ");
				
				}else if (t6Snip.trim().length() > 0)  {
					sb.append(" AND ( " + t6Snip.trim() + " ) ");
				}
			}else if ((t6Snip.trim().length() > 0) || (t10Snip.trim().length() > 0)|| (t11Snip.trim().length() > 0)) {
				//sb.append(" AND ( " + t6Snip.trim() + t10Snip.trim() + t11Snip.trim() + " ) ");
				sb.append(" AND ( " + t6Snip.trim()  + " ) ");
		}						
			
		}

		return sb.toString();
	}

	public String buildQuery() {
		StringBuffer sb = new StringBuffer();
		String query = "", t6Snip = "", t10Snip = "", t11Snip = "";
		if (!Boolean.parseBoolean(ds_all)) {

			if ((t6 != null) && (t6.size() > 0)) {
				t6Snip = buildT6Snippet(t6);
			}

			if (Boolean.parseBoolean(ds_lter)) {
			//	t10Snip = (" datasource:lter");
			} else if ((t10 != null) && (t10.size() > 0)) {
				t10Snip = buildT10Snippet(t10);
			}


			if ((t6Snip.trim().length() > 0) && (t10Snip.trim().length() > 0)) {
				t10Snip = " OR " + t10Snip.trim();
			}

			if (Boolean.parseBoolean(ds_ilter)) {
			//	t11Snip = ("datasource:ilter");
			} else if ((t11 != null) && (t11.size() > 0)) {
				t11Snip = buildT11Snippet(t11);
			}

			if ((t11Snip.length() > 0)&& ((t6Snip.length() > 0) || (t10Snip.length() > 0))) {
				t11Snip = " OR " + t11Snip;
			}
			

			
			// if this is a faceted datasource search
			if (facet_ds.length()>0) {
				if ((facet_ds.equalsIgnoreCase("lter"))&&((t10.size()>0))){
					sb.append(" AND ( " + buildT10Snippet(t10).trim()  + " ) ");
					
				}else if ((facet_ds.equalsIgnoreCase("ilter"))&&((t11.size()>0))){
					sb.append(" AND ( " + buildT11Snippet(t11).trim()  + " ) ");
				
				}else if (t6Snip.trim().length() > 0)  {
					sb.append(" AND ( " + t6Snip.trim() + " ) ");
				}
			}else if ((t6Snip.trim().length() > 0) || (t10Snip.trim().length() > 0)|| (t11Snip.trim().length() > 0)) {
				sb.append(" AND ( " + t6Snip.trim() + t10Snip.trim() + t11Snip.trim() + " ) ");
		}			
		}
		return sb.toString();
		
	}

	// main method for testing . returns test string by populating a dummy
	// SourceObject & creating query string fragment
	public static void main(String... args) {
		SourceObject so = new SourceObject();
		ArrayList<String> al_6 = new ArrayList<String>();
		ArrayList<String> al_10 = new ArrayList<String>();
		ArrayList<String> al_11 = new ArrayList<String>();
		al_6.add("nbii");
		al_10.add("andlter");
		al_11.add("saeonilter");
		al_6.add("ornldaac");
		al_10.add("gcelter");
		al_11.add("tilter");
		so.setDs_ilter("false");
		so.setDs_all("false");
		so.setDs_lter("false");
		so.setT6(al_6);
		so.setT10(al_10);
		so.setT11(al_11);
		SourceQuery sq = new SourceQuery(so);
		System.out.println("Test 1: two from each category"+"\n");
		System.out.println(sq.buildQuery()+"\n");
//////////////////////	
		so.init();
		ArrayList<String> al_6a = new ArrayList<String>();
		ArrayList<String> al_10a = new ArrayList<String>();
		ArrayList<String> al_11a = new ArrayList<String>();
		//al_6.add("nbii");
		al_10.add("andlter");
		al_11.add("saeonilter");
		//al_6.add("ornldaac");
		al_10.add("gcelter");
		al_11.add("tilter");
		so.setDs_ilter("false");
		so.setDs_all("false");
		so.setDs_lter("false");
		so.setT6(al_6a);
		so.setT10(al_10a);
		so.setT11(al_11a);
		SourceQuery sq1 = new SourceQuery(so);
		System.out.println("Test 2 No sources selected "+"\n");
		System.out.println(sq1.buildQuery()+"\n");	
//////////////////////////////////////////////////	
		so.init();
		al_10a.add("andlter");
		so.setT10(al_10a);
		SourceQuery sq2 = new SourceQuery(so);
		System.out.println("Test 3 one in catehory t10 "+"\n");
		System.out.println(sq1.buildQuery()+"\n");	
		
//////////////////////////////////////////////////
		so.init();
		al_11a.add("tilter");
		so.setT11(al_11a);
		SourceQuery sq3 = new SourceQuery(so);
		System.out.println("Test 4 one in category t11"+"\n");
		System.out.println(sq3.buildQuery()+"\n");	
		
//////////////////////////////////////////////////
		so.init();
		al_6a.add("nbii");
		so.setT6(al_6a);
		SourceQuery sq4 = new SourceQuery(so);
		System.out.println("Test 4 one in category t6"+"\n");
		System.out.println(sq4.buildQuery()+"\n");	
		
//////////////////////////////////////////////////
		so.init();
		al_11a = new ArrayList<String>();
		al_11a.add("tilter");
		al_10a= new ArrayList<String>();
		so.setT11(al_11a);
		al_10a.add("andlter");
		so.setT10(al_10a);
		SourceQuery sq5 = new SourceQuery(so);
		System.out.println("Test 5 one in category t10 & one in t11"+"\n");
		System.out.println(sq5.buildQuery()+"\n");	
		
//////////////////////////////////////////////////
		so.init();
		al_11a = new ArrayList<String>();
		al_11a.add("tilter");
		al_10a= new ArrayList<String>();
		so.setT11(al_11a);
		al_10a.add("andlter");
		so.setT10(al_10a);
		so.setFacet_ds("somesourcve");
		SourceQuery sq6 = new SourceQuery(so);
		System.out.println("Test 6 one in category t10 & one in t11 and facet datasource"+"\n");
		System.out.println(sq6.buildQuery()+"\n");	
		
//////////////////////////////////////////////////
		so.init();
		
		so.setFacet_ds("somesourcve");
		SourceQuery sq7 = new SourceQuery(so);
		System.out.println("Test 7 facet datasource only "+"\n");
		System.out.println(sq7.buildQuery()+"\n");	
		
	}

}
